/*
 * Decompiled with CFR 0.152.
 */
package uk.org.primrose.pool.core;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import uk.org.primrose.pool.core.ConnectionHolder;
import uk.org.primrose.pool.core.PoolResultSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PoolStatement
implements Statement {
    Statement s = null;
    ConnectionHolder connHolder = null;

    public PoolStatement(Statement s, ConnectionHolder connHolder) {
        this.connHolder = connHolder;
        this.connHolder.statementObjects.push(this);
        this.s = s;
    }

    public PoolStatement() {
    }

    protected void closeNoPop() throws SQLException {
        this.s.close();
    }

    @Override
    public void close() throws SQLException {
        for (int i = 0; i < this.connHolder.statementObjects.size(); ++i) {
            PoolStatement ts = (PoolStatement)this.connHolder.statementObjects.get(i);
            if (ts != this) continue;
            this.connHolder.statementObjects.remove(this);
            break;
        }
        if (this.connHolder.bDumpConnectionOnSQLException) {
            try {
                this.s.close();
            }
            catch (SQLException sqle) {
                this.connHolder.closeBehaviour = 14;
                this.connHolder.logger.warn("Closing connection due to SQLException on close()");
                this.connHolder.myPool.notifyExceptionEvent();
                throw sqle;
            }
        } else {
            this.s.close();
        }
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.connHolder.sql = sql;
        if (this.connHolder.bDumpConnectionOnSQLException) {
            try {
                PoolResultSet prs = new PoolResultSet(this.s.executeQuery(sql), this.connHolder, this);
                return prs;
            }
            catch (SQLException sqle) {
                this.connHolder.closeBehaviour = 14;
                this.connHolder.logger.warn("Closing connection due to SQLException on execute");
                this.connHolder.myPool.notifyExceptionEvent();
                throw sqle;
            }
        }
        PoolResultSet prs = new PoolResultSet(this.s.executeQuery(sql), this.connHolder, this);
        return prs;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.connHolder.sql = sql;
        if (this.connHolder.bDumpConnectionOnSQLException) {
            try {
                return this.s.executeUpdate(sql);
            }
            catch (SQLException sqle) {
                this.connHolder.closeBehaviour = 14;
                this.connHolder.logger.warn("Closing connection due to SQLException on execute");
                this.connHolder.myPool.notifyExceptionEvent();
                throw sqle;
            }
        }
        return this.s.executeUpdate(sql);
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.connHolder.sql = sql;
        if (this.connHolder.bDumpConnectionOnSQLException) {
            try {
                return this.s.executeUpdate(sql, autoGeneratedKeys);
            }
            catch (SQLException sqle) {
                this.connHolder.closeBehaviour = 14;
                this.connHolder.logger.warn("Closing connection due to SQLException on execute");
                this.connHolder.myPool.notifyExceptionEvent();
                throw sqle;
            }
        }
        return this.s.executeUpdate(sql, autoGeneratedKeys);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.connHolder.sql = sql;
        if (this.connHolder.bDumpConnectionOnSQLException) {
            try {
                return this.s.executeUpdate(sql, columnIndexes);
            }
            catch (SQLException sqle) {
                this.connHolder.closeBehaviour = 14;
                this.connHolder.logger.warn("Closing connection due to SQLException on execute");
                this.connHolder.myPool.notifyExceptionEvent();
                throw sqle;
            }
        }
        return this.s.executeUpdate(sql, columnIndexes);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.connHolder.sql = sql;
        if (this.connHolder.bDumpConnectionOnSQLException) {
            try {
                return this.s.executeUpdate(sql, columnNames);
            }
            catch (SQLException sqle) {
                this.connHolder.closeBehaviour = 14;
                this.connHolder.logger.warn("Closing connection due to SQLException on execute");
                this.connHolder.myPool.notifyExceptionEvent();
                throw sqle;
            }
        }
        return this.s.executeUpdate(sql, columnNames);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.connHolder.sql = sql;
        if (this.connHolder.bDumpConnectionOnSQLException) {
            try {
                return this.s.execute(sql, autoGeneratedKeys);
            }
            catch (SQLException sqle) {
                this.connHolder.closeBehaviour = 14;
                this.connHolder.logger.warn("Closing connection due to SQLException on execute");
                this.connHolder.myPool.notifyExceptionEvent();
                throw sqle;
            }
        }
        return this.s.execute(sql, autoGeneratedKeys);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.connHolder.sql = sql;
        if (this.connHolder.bDumpConnectionOnSQLException) {
            try {
                return this.s.execute(sql, columnIndexes);
            }
            catch (SQLException sqle) {
                this.connHolder.closeBehaviour = 14;
                this.connHolder.logger.warn("Closing connection due to SQLException on execute");
                this.connHolder.myPool.notifyExceptionEvent();
                throw sqle;
            }
        }
        return this.s.execute(sql, columnIndexes);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.connHolder.sql = sql;
        if (this.connHolder.bDumpConnectionOnSQLException) {
            try {
                return this.s.execute(sql, columnNames);
            }
            catch (SQLException sqle) {
                this.connHolder.closeBehaviour = 14;
                this.connHolder.logger.warn("Closing connection due to SQLException on execute");
                this.connHolder.myPool.notifyExceptionEvent();
                throw sqle;
            }
        }
        return this.s.execute(sql, columnNames);
    }

    @Override
    public int[] executeBatch() throws SQLException {
        if (this.connHolder.bDumpConnectionOnSQLException) {
            try {
                return this.s.executeBatch();
            }
            catch (SQLException sqle) {
                this.connHolder.closeBehaviour = 14;
                this.connHolder.logger.warn("Closing connection due to SQLException on execute");
                this.connHolder.myPool.notifyExceptionEvent();
                throw sqle;
            }
        }
        return this.s.executeBatch();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.s.getMaxFieldSize();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.s.setMaxFieldSize(max);
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.s.getMaxRows();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.s.setMaxRows(max);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.s.setEscapeProcessing(enable);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.s.getQueryTimeout();
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.s.setQueryTimeout(seconds);
    }

    @Override
    public void cancel() throws SQLException {
        this.s.cancel();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.s.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.s.clearWarnings();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.s.setCursorName(name);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.connHolder.sql = sql;
        return this.s.execute(sql);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        PoolResultSet prs = new PoolResultSet(this.s.getResultSet(), this.connHolder, this);
        return prs;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.s.getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.s.getMoreResults();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.s.setFetchDirection(direction);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.s.getFetchDirection();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.s.setFetchSize(rows);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.s.getFetchSize();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.s.getResultSetConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.s.getResultSetType();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.s.addBatch(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        this.s.clearBatch();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.s.getConnection();
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return this.s.getMoreResults(current);
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        PoolResultSet prs = new PoolResultSet(this.s.getGeneratedKeys(), this.connHolder, this);
        return prs;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.s.getResultSetHoldability();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.s.isClosed();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.s.isPoolable();
    }

    @Override
    public void setPoolable(boolean arg0) throws SQLException {
        this.s.setPoolable(arg0);
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        return this.s.isWrapperFor(arg0);
    }

    @Override
    public <T> T unwrap(Class<T> arg0) throws SQLException {
        return this.s.unwrap(arg0);
    }
}

