/*
 * Decompiled with CFR 0.152.
 */
package uk.org.primrose.console;

import java.io.IOException;
import uk.org.primrose.Logger;
import uk.org.primrose.console.WebConsole;

public class GenericWebConsoleFactory {
    private static WebConsole wc = null;
    private int port = -1;
    private String logFile = null;
    private Logger logger = null;
    private String logLevel = "";
    private String username = null;
    private String password = null;

    public void setLogLevel(String logLevel) {
        this.logLevel = logLevel;
    }

    public String getLogLevel() {
        return this.logger.getLogLevel();
    }

    public void setPort(String port) throws IOException {
        this.port = Integer.parseInt(port);
        this.start();
    }

    public void setLogFile(String logFile) throws IOException {
        this.logFile = logFile;
        this.logger = new Logger();
        this.logger.setLogWriter(logFile);
        this.logger.setLogLevel(this.logLevel);
        this.start();
    }

    public String getLogFile() {
        return this.logFile;
    }

    public String getPort() {
        return this.port + "";
    }

    public void start() throws IOException {
        if (this.port > 0 && this.logger != null) {
            wc = new WebConsole(this.username, this.password, this.port, this.logger);
            wc.start();
        }
    }

    public void stop() throws IOException {
        WebConsole.shutdown();
    }

    public void setUsername(String username) {
        this.username = username;
        if (wc != null) {
            wc.setUsername(username);
        }
    }

    public void setPassword(String password) {
        this.password = password;
        if (wc != null) {
            wc.setPassword(password);
        }
    }

    public String getPassword() {
        if (wc != null) {
            return wc.getPassword();
        }
        return null;
    }

    public String getUsername() {
        if (wc != null) {
            return wc.getUsername();
        }
        return null;
    }
}

