/*
 * Decompiled with CFR 0.152.
 */
package uk.org.primrose;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import uk.org.primrose.Logger;

public class SendMail {
    static String mxServer;
    static String mxServerPort;
    String toAddress;
    String fromAddress;
    String subject;
    String text;
    MimeBodyPart mbp = null;
    Multipart mp = new MimeMultipart();
    Logger logger = null;

    public SendMail(Logger logger, String mxServer, String mxServerPort, String toAddress, String fromAddress, String subject, String text) {
        SendMail.mxServer = mxServer;
        SendMail.mxServerPort = mxServerPort;
        this.toAddress = toAddress;
        this.fromAddress = fromAddress;
        this.subject = subject;
        this.text = text;
        this.logger = logger;
    }

    public void attach(File file) {
        try {
            this.mbp = new MimeBodyPart();
            this.mbp.setFileName(file.getName());
            this.mbp.setDataHandler(new DataHandler((DataSource)new FileDataSource(file)));
            this.mp.addBodyPart((BodyPart)this.mbp);
        }
        catch (MessagingException me) {
            this.logger.printStackTrace(me);
        }
    }

    public void send() {
        new SendThread().start();
    }

    public String nslookup(String domain) {
        String mailserver = null;
        try {
            Process p = Runtime.getRuntime().exec("nslookup -type=mx " + domain);
            BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
            boolean gotMxLine = false;
            String line = null;
            String token = null;
            while ((line = br.readLine()) != null) {
                gotMxLine = false;
                StringTokenizer st = new StringTokenizer(line);
                while (st.hasMoreTokens()) {
                    token = st.nextToken();
                    if (token.equals("exchanger")) {
                        gotMxLine = true;
                    }
                    if (!gotMxLine) continue;
                    mailserver = token;
                }
            }
        }
        catch (IOException ioe) {
            this.logger.printStackTrace(ioe);
            return null;
        }
        System.out.println("Mail Server to use is :: " + mailserver);
        return mailserver;
    }

    class SendThread
    extends Thread {
        SendThread() {
        }

        public void run() {
            Properties props = System.getProperties();
            props.put("mail.smtp.host", mxServer);
            props.put("mail.smtp.port", mxServerPort);
            Session session = Session.getDefaultInstance((Properties)props, null);
            try {
                MimeMessage msg = new MimeMessage(session);
                msg.setFrom((Address)new InternetAddress(SendMail.this.fromAddress));
                msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)SendMail.this.toAddress, (boolean)false));
                msg.setSubject(SendMail.this.subject);
                msg.setHeader("X-Mailer", "JavaMail");
                if (SendMail.this.mbp != null) {
                    MimeBodyPart mbp2 = new MimeBodyPart();
                    mbp2.setText(SendMail.this.text);
                    SendMail.this.mp.addBodyPart((BodyPart)mbp2);
                    msg.setContent(SendMail.this.mp);
                } else {
                    msg.setText(SendMail.this.text);
                }
                Transport.send((Message)msg);
            }
            catch (AddressException ae) {
                SendMail.this.logger.printStackTrace(ae);
            }
            catch (MessagingException me) {
                SendMail.this.logger.printStackTrace(me);
            }
        }
    }
}

