/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.server.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import org.apache.abdera.Abdera;
import org.apache.abdera.model.Service;
import org.apache.abdera.protocol.Resolver;
import org.apache.abdera.protocol.server.CategoriesInfo;
import org.apache.abdera.protocol.server.CategoryInfo;
import org.apache.abdera.protocol.server.CollectionAdapter;
import org.apache.abdera.protocol.server.CollectionInfo;
import org.apache.abdera.protocol.server.Filter;
import org.apache.abdera.protocol.server.MediaCollectionAdapter;
import org.apache.abdera.protocol.server.Provider;
import org.apache.abdera.protocol.server.ProviderHelper;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.ResponseContext;
import org.apache.abdera.protocol.server.Target;
import org.apache.abdera.protocol.server.TargetBuilder;
import org.apache.abdera.protocol.server.TargetType;
import org.apache.abdera.protocol.server.Transactional;
import org.apache.abdera.protocol.server.WorkspaceInfo;
import org.apache.abdera.protocol.server.WorkspaceManager;
import org.apache.abdera.protocol.server.context.StreamWriterResponseContext;
import org.apache.abdera.protocol.server.impl.SimpleSubjectResolver;
import org.apache.abdera.writer.StreamWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProvider
implements Provider {
    private static final Log log = LogFactory.getLog(AbstractProvider.class);
    protected Abdera abdera;
    protected Map<String, String> properties;
    protected List<Filter> filters = new ArrayList<Filter>();

    @Override
    public void init(Abdera abdera, Map<String, String> properties) {
        this.abdera = abdera;
        this.properties = properties;
    }

    @Override
    public String getProperty(String name) {
        return this.properties.get(name);
    }

    @Override
    public String[] getPropertyNames() {
        return this.properties.keySet().toArray(new String[this.properties.size()]);
    }

    @Override
    public Abdera getAbdera() {
        return this.abdera;
    }

    @Override
    public Subject resolveSubject(RequestContext request) {
        Resolver<Subject> subjectResolver = this.getSubjectResolver(request);
        return subjectResolver != null ? subjectResolver.resolve(request) : null;
    }

    @Override
    public Target resolveTarget(RequestContext request) {
        Resolver<Target> targetResolver = this.getTargetResolver(request);
        return targetResolver != null ? targetResolver.resolve(request) : null;
    }

    @Override
    public String urlFor(RequestContext request, Object key, Object param) {
        TargetBuilder tm = this.getTargetBuilder(request);
        return tm != null ? tm.urlFor(request, key, param) : null;
    }

    protected Resolver<Subject> getSubjectResolver(RequestContext request) {
        return new SimpleSubjectResolver();
    }

    protected abstract TargetBuilder getTargetBuilder(RequestContext var1);

    protected abstract Resolver<Target> getTargetResolver(RequestContext var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResponseContext process(RequestContext request) {
        Target target = request.getTarget();
        if (target == null || target.getType() == TargetType.TYPE_NOT_FOUND) {
            return ProviderHelper.notfound(request);
        }
        String method = request.getMethod();
        TargetType type = target.getType();
        if (type == TargetType.TYPE_SERVICE && method.equalsIgnoreCase("GET")) {
            return this.getServiceDocument(request);
        }
        WorkspaceManager wm = this.getWorkspaceManager(request);
        CollectionAdapter adapter = wm.getCollectionAdapter(request);
        if (adapter == null) {
            return ProviderHelper.notfound(request);
        }
        Transactional transaction = adapter instanceof Transactional ? (Transactional)((Object)adapter) : null;
        ResponseContext response = null;
        try {
            Object mcadapter;
            if (transaction != null) {
                transaction.start(request);
            }
            if (type == TargetType.TYPE_CATEGORIES) {
                if (method.equalsIgnoreCase("GET")) {
                    response = adapter.getCategories(request);
                }
            } else if (type == TargetType.TYPE_COLLECTION) {
                if (method.equalsIgnoreCase("GET")) {
                    response = adapter.getFeed(request);
                } else if (method.equalsIgnoreCase("POST")) {
                    response = ProviderHelper.isAtom(request) ? adapter.postEntry(request) : (adapter instanceof MediaCollectionAdapter ? ((MediaCollectionAdapter)adapter).postMedia(request) : ProviderHelper.notsupported(request));
                }
            } else if (type == TargetType.TYPE_ENTRY) {
                if (method.equalsIgnoreCase("GET")) {
                    response = adapter.getEntry(request);
                } else if (method.equalsIgnoreCase("PUT")) {
                    response = adapter.putEntry(request);
                } else if (method.equalsIgnoreCase("DELETE")) {
                    response = adapter.deleteEntry(request);
                } else if (method.equalsIgnoreCase("HEAD")) {
                    response = adapter.headEntry(request);
                } else if (method.equalsIgnoreCase("OPTIONS")) {
                    response = adapter.optionsEntry(request);
                }
            } else if (type == TargetType.TYPE_MEDIA) {
                if (adapter instanceof MediaCollectionAdapter) {
                    mcadapter = (MediaCollectionAdapter)adapter;
                    if (method.equalsIgnoreCase("GET")) {
                        response = mcadapter.getMedia(request);
                    } else if (method.equalsIgnoreCase("PUT")) {
                        response = mcadapter.putMedia(request);
                    } else if (method.equalsIgnoreCase("DELETE")) {
                        response = mcadapter.deleteMedia(request);
                    } else if (method.equalsIgnoreCase("HEAD")) {
                        response = mcadapter.headMedia(request);
                    } else if (method.equalsIgnoreCase("OPTIONS")) {
                        response = mcadapter.optionsMedia(request);
                    }
                } else {
                    response = ProviderHelper.notsupported(request);
                }
            } else {
                response = type == TargetType.TYPE_NOT_FOUND ? ProviderHelper.notfound(request) : adapter.extensionRequest(request);
            }
            if (response == null) {
                response = ProviderHelper.notsupported(request);
            }
            mcadapter = response;
            if (transaction != null) {
                transaction.end(request, response);
            }
            return mcadapter;
        }
        catch (Throwable e) {
            try {
                log.error((Object)e);
                if (transaction != null) {
                    transaction.compensate(request, e);
                }
                ResponseContext responseContext = response = ProviderHelper.servererror(request, e);
                if (transaction != null) {
                    transaction.end(request, response);
                }
                return responseContext;
            }
            catch (Throwable throwable) {
                if (transaction != null) {
                    transaction.end(request, response);
                }
                throw throwable;
            }
        }
    }

    protected abstract WorkspaceManager getWorkspaceManager(RequestContext var1);

    protected Service getServiceElement(RequestContext request) {
        Service service = this.abdera.newService();
        for (WorkspaceInfo wi : this.getWorkspaceManager(request).getWorkspaces(request)) {
            service.addWorkspace(wi.asWorkspaceElement(request));
        }
        return service;
    }

    protected ResponseContext getServiceDocument(final RequestContext request) {
        return new StreamWriterResponseContext(request.getAbdera()){

            protected void writeTo(StreamWriter sw) throws IOException {
                sw.startDocument().startService();
                for (WorkspaceInfo wi : AbstractProvider.this.getWorkspaceManager(request).getWorkspaces(request)) {
                    sw.startWorkspace().writeTitle(wi.getTitle(request));
                    for (CollectionInfo ci : wi.getCollections(request)) {
                        sw.startCollection(ci.getHref(request)).writeTitle(ci.getTitle(request)).writeAccepts(ci.getAccepts(request));
                        CategoriesInfo[] catinfos = ci.getCategoriesInfo(request);
                        if (catinfos != null) {
                            for (CategoriesInfo catinfo : catinfos) {
                                String cathref = catinfo.getHref(request);
                                if (cathref != null) {
                                    sw.startCategories().writeAttribute("href", request.getTargetBasePath() + cathref).endCategories();
                                    continue;
                                }
                                sw.startCategories(catinfo.isFixed(request), catinfo.getScheme(request));
                                for (CategoryInfo cat : catinfo) {
                                    sw.writeCategory(cat.getTerm(request), cat.getScheme(request), cat.getLabel(request));
                                }
                                sw.endCategories();
                            }
                        }
                        sw.endCollection();
                    }
                    sw.endWorkspace();
                }
                sw.endService().endDocument();
            }
        }.setStatus(200).setContentType("application/atomsvc+xml");
    }

    public void setFilters(List<Filter> filters) {
        this.filters = filters;
    }

    @Override
    public Filter[] getFilters(RequestContext request) {
        return this.filters.toArray(new Filter[this.filters.size()]);
    }

    public void addFilter(Filter ... filters) {
        for (Filter filter : filters) {
            this.filters.add(filter);
        }
    }
}

