/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.ext.json;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.abdera.Abdera;
import org.apache.abdera.ext.bidi.BidiHelper;
import org.apache.abdera.ext.history.FeedPagingHelper;
import org.apache.abdera.ext.html.HtmlHelper;
import org.apache.abdera.ext.json.JSONStream;
import org.apache.abdera.ext.thread.InReplyTo;
import org.apache.abdera.ext.thread.ThreadHelper;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.i18n.text.Bidi;
import org.apache.abdera.model.Base;
import org.apache.abdera.model.Categories;
import org.apache.abdera.model.Category;
import org.apache.abdera.model.Collection;
import org.apache.abdera.model.Content;
import org.apache.abdera.model.Control;
import org.apache.abdera.model.Div;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.ExtensibleElement;
import org.apache.abdera.model.Feed;
import org.apache.abdera.model.Generator;
import org.apache.abdera.model.Link;
import org.apache.abdera.model.Person;
import org.apache.abdera.model.Service;
import org.apache.abdera.model.Source;
import org.apache.abdera.model.Text;
import org.apache.abdera.model.TextValue;
import org.apache.abdera.model.Workspace;
import org.apache.abdera.xpath.XPath;

public class JSONUtil {
    public static void toJson(Base base, Writer writer) throws IOException {
        JSONStream jstream = new JSONStream(writer);
        if (base instanceof Document) {
            JSONUtil.toJson((Document)base, jstream);
        } else if (base instanceof Element) {
            JSONUtil.toJson((Element)base, jstream);
        }
        writer.flush();
    }

    private static boolean isSameAsParentBase(Element element) {
        IRI parentbase = null;
        if (element.getParentElement() != null) {
            parentbase = element instanceof Document ? ((Document)((Object)element)).getBaseUri() : element.getResolvedBaseUri();
        }
        IRI base = element.getResolvedBaseUri();
        if (parentbase == null && base != null) {
            return false;
        }
        if (parentbase == null && base == null) {
            return true;
        }
        return parentbase.equals(element.getResolvedBaseUri());
    }

    private static void toJson(Element element, JSONStream jstream) throws IOException {
        if (element instanceof Text) {
            Text text = (Text)element;
            Text.Type texttype = text.getTextType();
            if (texttype.equals((Object)Text.Type.TEXT) && !JSONUtil.needToWriteLanguageFields(text)) {
                jstream.writeQuoted(text.getValue());
            } else {
                jstream.startObject();
                jstream.writeField("attributes");
                jstream.startObject();
                jstream.writeField("type", texttype.name().toLowerCase());
                JSONUtil.writeLanguageFields(element, jstream);
                if (!JSONUtil.isSameAsParentBase(element)) {
                    jstream.writeField("xml:base", element.getResolvedBaseUri());
                }
                jstream.endObject();
                jstream.writeField("children");
                switch (text.getTextType()) {
                    case TEXT: {
                        jstream.startArray();
                        jstream.writeQuoted(text.getValue());
                        jstream.endArray();
                        break;
                    }
                    case HTML: {
                        Div div = HtmlHelper.parse(text.getValue());
                        JSONUtil.writeElementValue(div, jstream);
                        break;
                    }
                    case XHTML: {
                        JSONUtil.writeElementValue(text.getValueElement(), jstream);
                    }
                }
                jstream.endObject();
            }
        } else if (element instanceof Content) {
            Content content = (Content)element;
            Content.Type contenttype = content.getContentType();
            if (contenttype.equals((Object)Content.Type.TEXT) && !JSONUtil.needToWriteLanguageFields(content)) {
                jstream.writeQuoted(content.getValue());
            } else {
                jstream.startObject();
                jstream.writeField("attributes");
                jstream.startObject();
                switch (content.getContentType()) {
                    case TEXT: 
                    case HTML: 
                    case XHTML: {
                        jstream.writeField("type", contenttype.name().toLowerCase());
                        break;
                    }
                    case MEDIA: 
                    case XML: {
                        jstream.writeField("type", content.getMimeType());
                    }
                }
                JSONUtil.writeLanguageFields(element, jstream);
                if (!JSONUtil.isSameAsParentBase(element)) {
                    jstream.writeField("xml:base", element.getResolvedBaseUri());
                }
                JSONUtil.writeLanguageFields(content, jstream);
                jstream.writeField("src", content.getResolvedSrc());
                jstream.endObject();
                jstream.writeField("children");
                switch (content.getContentType()) {
                    case TEXT: {
                        jstream.startArray();
                        jstream.writeQuoted(content.getValue());
                        jstream.endArray();
                        break;
                    }
                    case HTML: {
                        Div div = HtmlHelper.parse(content.getValue());
                        JSONUtil.writeElementValue(div, jstream);
                        break;
                    }
                    case XHTML: {
                        JSONUtil.writeElementValue(content.getValueElement(), jstream);
                        break;
                    }
                    case MEDIA: 
                    case XML: {
                        jstream.startArray();
                        jstream.writeQuoted(content.getValue());
                        jstream.endArray();
                    }
                }
                jstream.endObject();
            }
        } else if (element instanceof Categories) {
            Categories categories;
            jstream.startObject();
            JSONUtil.writeLanguageFields(element, jstream);
            if (!JSONUtil.isSameAsParentBase(element)) {
                jstream.writeField("xml:base", element.getResolvedBaseUri());
            }
            jstream.writeField("fixed", (categories = (Categories)element).isFixed() ? "true" : "false");
            jstream.writeField("scheme", categories.getScheme());
            JSONUtil.writeList("categories", categories.getCategories(), jstream);
            JSONUtil.writeExtensions((ExtensibleElement)element, jstream);
            jstream.endObject();
        } else if (element instanceof Category) {
            jstream.startObject();
            JSONUtil.writeLanguageFields(element, jstream);
            if (!JSONUtil.isSameAsParentBase(element)) {
                jstream.writeField("xml:base", element.getResolvedBaseUri());
            }
            Category category = (Category)element;
            jstream.writeField("term", category.getTerm());
            jstream.writeField("scheme", category.getScheme());
            jstream.writeField("label", category.getLabel());
            JSONUtil.writeExtensions((ExtensibleElement)element, jstream);
            jstream.endObject();
        } else if (element instanceof Collection) {
            List<Categories> cats;
            jstream.startObject();
            JSONUtil.writeLanguageFields(element, jstream);
            if (!JSONUtil.isSameAsParentBase(element)) {
                jstream.writeField("xml:base", element.getResolvedBaseUri());
            }
            Collection collection = (Collection)element;
            jstream.writeField("href", collection.getResolvedHref());
            JSONUtil.writeElement("title", collection.getTitleElement(), jstream);
            String[] accepts = collection.getAccept();
            if (accepts != null || accepts.length > 0) {
                jstream.writeField("accept");
                jstream.startArray();
                for (int n = 0; n < accepts.length; ++n) {
                    jstream.writeQuoted(accepts[n]);
                    if (n >= accepts.length - 1) continue;
                    jstream.writeSeparator();
                }
                jstream.endArray();
            }
            if ((cats = collection.getCategories()).size() > 0) {
                JSONUtil.writeList("categories", collection.getCategories(), jstream);
            }
            JSONUtil.writeExtensions((ExtensibleElement)element, jstream);
            jstream.endObject();
        } else if (element instanceof Control) {
            Control control;
            jstream.startObject();
            JSONUtil.writeLanguageFields(element, jstream);
            if (!JSONUtil.isSameAsParentBase(element)) {
                jstream.writeField("xml:base", element.getResolvedBaseUri());
            }
            jstream.writeField("draft", (control = (Control)element).isDraft() ? "true" : "false");
            JSONUtil.writeExtensions((ExtensibleElement)element, jstream);
            jstream.endObject();
        } else if (element instanceof Entry) {
            jstream.startObject();
            JSONUtil.writeLanguageFields(element, jstream);
            if (!JSONUtil.isSameAsParentBase(element)) {
                jstream.writeField("xml:base", element.getResolvedBaseUri());
            }
            Entry entry = (Entry)element;
            jstream.writeField("id", entry.getId());
            JSONUtil.writeElement("title", entry.getTitleElement(), jstream);
            JSONUtil.writeElement("summary", entry.getSummaryElement(), jstream);
            JSONUtil.writeElement("rights", entry.getRightsElement(), jstream);
            JSONUtil.writeElement("content", entry.getContentElement(), jstream);
            jstream.writeField("updated", entry.getUpdated());
            jstream.writeField("published", entry.getPublished());
            jstream.writeField("edited", entry.getEdited());
            JSONUtil.writeElement("source", entry.getSource(), jstream);
            JSONUtil.writeList("authors", entry.getAuthors(), jstream);
            JSONUtil.writeList("contributors", entry.getContributors(), jstream);
            JSONUtil.writeList("links", entry.getLinks(), jstream);
            JSONUtil.writeList("categories", entry.getCategories(), jstream);
            JSONUtil.writeList("inreplyto", ThreadHelper.getInReplyTos(entry), jstream);
            JSONUtil.writeElement("control", entry.getControl(), jstream);
            JSONUtil.writeExtensions((ExtensibleElement)element, jstream);
            jstream.endObject();
        } else if (element instanceof Generator) {
            jstream.startObject();
            JSONUtil.writeLanguageFields(element, jstream);
            if (!JSONUtil.isSameAsParentBase(element)) {
                jstream.writeField("xml:base", element.getResolvedBaseUri());
            }
            Generator generator = (Generator)element;
            jstream.writeField("version", generator.getVersion());
            jstream.writeField("uri", generator.getResolvedUri());
            jstream.writeField("value", generator.getText());
            jstream.endObject();
        } else if (element instanceof Link) {
            jstream.startObject();
            JSONUtil.writeLanguageFields(element, jstream);
            if (!JSONUtil.isSameAsParentBase(element)) {
                jstream.writeField("xml:base", element.getResolvedBaseUri());
            }
            Link link = (Link)element;
            jstream.writeField("href", link.getResolvedHref());
            jstream.writeField("rel", link.getRel());
            jstream.writeField("title", link.getTitle());
            jstream.writeField("type", link.getMimeType());
            jstream.writeField("hreflang", link.getHrefLang());
            if (link.getLength() > -1L) {
                jstream.writeField("length", link.getLength());
            }
            JSONUtil.writeExtensions((ExtensibleElement)element, jstream);
            jstream.endObject();
        } else if (element instanceof Person) {
            jstream.startObject();
            JSONUtil.writeLanguageFields(element, jstream);
            if (!JSONUtil.isSameAsParentBase(element)) {
                jstream.writeField("xml:base", element.getResolvedBaseUri());
            }
            Person person = (Person)element;
            jstream.writeField("name", person.getName());
            if (person.getEmail() != null) {
                jstream.writeField("email", person.getEmail());
            }
            if (person.getUri() != null) {
                jstream.writeField("uri", person.getUriElement().getResolvedValue());
            }
            JSONUtil.writeExtensions((ExtensibleElement)element, jstream);
            jstream.endObject();
        } else if (element instanceof Service) {
            jstream.startObject();
            JSONUtil.writeLanguageFields(element, jstream);
            if (!JSONUtil.isSameAsParentBase(element)) {
                jstream.writeField("xml:base", element.getResolvedBaseUri());
            }
            Service service = (Service)element;
            JSONUtil.writeList("workspaces", service.getWorkspaces(), jstream);
            JSONUtil.writeExtensions((ExtensibleElement)element, jstream);
            jstream.endObject();
        } else if (element instanceof Source) {
            jstream.startObject();
            JSONUtil.writeLanguageFields(element, jstream);
            if (!JSONUtil.isSameAsParentBase(element)) {
                jstream.writeField("xml:base", element.getResolvedBaseUri());
            }
            Source source = (Source)element;
            jstream.writeField("id", source.getId());
            JSONUtil.writeElement("title", source.getTitleElement(), jstream);
            JSONUtil.writeElement("subtitle", source.getSubtitleElement(), jstream);
            JSONUtil.writeElement("rights", source.getRightsElement(), jstream);
            jstream.writeField("updated", source.getUpdated());
            JSONUtil.writeElement("generator", source.getGenerator(), jstream);
            if (source.getIconElement() != null) {
                jstream.writeField("icon", source.getIconElement().getResolvedValue());
            }
            if (source.getLogoElement() != null) {
                jstream.writeField("logo", source.getLogoElement().getResolvedValue());
            }
            JSONUtil.writeList("authors", source.getAuthors(), jstream);
            JSONUtil.writeList("contributors", source.getContributors(), jstream);
            JSONUtil.writeList("links", source.getLinks(), jstream);
            JSONUtil.writeList("categories", source.getCategories(), jstream);
            if (FeedPagingHelper.isComplete(source)) {
                jstream.writeField("complete", true);
            }
            if (FeedPagingHelper.isArchive(source)) {
                jstream.writeField("archive", true);
            }
            if (source instanceof Feed) {
                JSONUtil.writeList("entries", ((Feed)source).getEntries(), jstream);
            }
            JSONUtil.writeExtensions((ExtensibleElement)element, jstream);
            jstream.endObject();
        } else if (element instanceof Workspace) {
            jstream.startObject();
            JSONUtil.writeLanguageFields(element, jstream);
            if (!JSONUtil.isSameAsParentBase(element)) {
                jstream.writeField("xml:base", element.getResolvedBaseUri());
            }
            Workspace workspace = (Workspace)element;
            JSONUtil.writeElement("title", workspace.getTitleElement(), jstream);
            JSONUtil.writeList("collections", workspace.getCollections(), jstream);
            JSONUtil.writeExtensions((ExtensibleElement)element, jstream);
            jstream.endObject();
        } else if (element instanceof InReplyTo) {
            jstream.startObject();
            JSONUtil.writeLanguageFields(element, jstream);
            if (!JSONUtil.isSameAsParentBase(element)) {
                jstream.writeField("xml:base", element.getResolvedBaseUri());
            }
            InReplyTo irt = (InReplyTo)element;
            jstream.writeField("ref", irt.getRef());
            jstream.writeField("href", irt.getResolvedHref());
            jstream.writeField("type", irt.getMimeType());
            jstream.writeField("source", irt.getResolvedSource());
            jstream.endObject();
        } else {
            JSONUtil.writeElement(element, null, jstream);
        }
    }

    private static void writeElementValue(Element element, JSONStream jstream) throws IOException {
        JSONUtil.writeElementChildren(element, jstream);
    }

    private static String getName(QName qname) {
        String prefix = qname.getPrefix();
        String name = qname.getLocalPart();
        return prefix != null && !"".equals(prefix) ? prefix + ":" + name : name;
    }

    private static void writeElement(Element child, QName parentqname, JSONStream jstream) throws IOException {
        QName childqname = child.getQName();
        String prefix = childqname.getPrefix();
        jstream.startObject();
        jstream.writeField("name", JSONUtil.getName(childqname));
        jstream.writeField("attributes");
        List<QName> attributes = child.getAttributes();
        jstream.startObject();
        if (!JSONUtil.isSameNamespace(childqname, parentqname)) {
            if (prefix != null && !"".equals(prefix)) {
                jstream.writeField("xmlns:" + prefix);
            } else {
                jstream.writeField("xmlns");
            }
            jstream.writeQuoted(childqname.getNamespaceURI());
        }
        if (!JSONUtil.isSameAsParentBase(child)) {
            jstream.writeField("xml:base", child.getResolvedBaseUri());
        }
        JSONUtil.writeLanguageFields(child, jstream);
        for (QName attr : attributes) {
            String name = JSONUtil.getName(attr);
            jstream.writeField(name);
            if ("".equals(attr.getPrefix()) || "xml".equals(attr.getPrefix())) {
                IRI base;
                String val = child.getAttributeValue(attr);
                if (val != null && ("href".equalsIgnoreCase(name) || "src".equalsIgnoreCase(name) || "action".equalsIgnoreCase(name)) && (base = child.getResolvedBaseUri()) != null) {
                    val = base.resolve(val).toASCIIString();
                }
                jstream.writeQuoted(val);
                continue;
            }
            jstream.startObject();
            jstream.writeField("attributes");
            jstream.startObject();
            jstream.writeField("xmlns:" + attr.getPrefix());
            jstream.writeQuoted(attr.getNamespaceURI());
            jstream.endObject();
            jstream.writeField("value");
            jstream.writeQuoted(child.getAttributeValue(attr));
            jstream.endObject();
        }
        jstream.endObject();
        jstream.writeField("children");
        JSONUtil.writeElementChildren(child, jstream);
        jstream.endObject();
    }

    private static void writeElementChildren(Element element, JSONStream jstream) throws IOException {
        jstream.startArray();
        Object[] children = JSONUtil.getChildren(element);
        QName parentqname = element.getQName();
        for (int n = 0; n < children.length; ++n) {
            Object child = children[n];
            if (child instanceof Element) {
                JSONUtil.writeElement((Element)child, parentqname, jstream);
                if (n >= children.length - 1) continue;
                jstream.writeSeparator();
                continue;
            }
            if (!(child instanceof TextValue)) continue;
            TextValue textvalue = (TextValue)child;
            String value = textvalue.getText();
            if (!element.getMustPreserveWhitespace()) {
                if (value.matches("\\s*")) continue;
                jstream.writeQuoted(value.trim());
                if (n >= children.length - 1) continue;
                jstream.writeSeparator();
                continue;
            }
            jstream.writeQuoted(value);
            if (n >= children.length - 1) continue;
            jstream.writeSeparator();
        }
        jstream.endArray();
    }

    private static void writeExtensions(ExtensibleElement element, JSONStream jstream) throws IOException {
        JSONUtil.writeExtensions(element, jstream, true);
    }

    private static void writeExtensions(ExtensibleElement element, JSONStream jstream, boolean startsep) throws IOException {
        List<QName> attributes = element.getExtensionAttributes();
        JSONUtil.writeList("extensions", element.getExtensions(), jstream);
        if (attributes.size() > 0) {
            jstream.writeField("attributes");
            jstream.startObject();
            for (int n = 0; n < attributes.size(); ++n) {
                QName qname = attributes.get(n);
                jstream.writeField(JSONUtil.getName(qname));
                if ("".equals(qname.getPrefix()) || "xml".equals(qname.getPrefix())) {
                    jstream.writeQuoted(element.getAttributeValue(qname));
                    continue;
                }
                jstream.startObject();
                jstream.writeField("attributes");
                jstream.startObject();
                jstream.writeField("xmlns:" + qname.getPrefix());
                jstream.writeQuoted(qname.getNamespaceURI());
                jstream.endObject();
                jstream.writeField("value");
                jstream.writeQuoted(element.getAttributeValue(qname));
                jstream.endObject();
            }
            jstream.endObject();
        }
    }

    private static boolean needToWriteLanguageFields(Element element) {
        return JSONUtil.needToWriteLang(element) || JSONUtil.needToWriteDir(element);
    }

    private static boolean needToWriteLang(Element element) {
        String parentlang = null;
        if (element.getParentElement() != null) {
            Object parent = element.getParentElement();
            parentlang = parent instanceof Document ? ((Document)parent).getLanguage() : ((Element)parent).getLanguage();
        }
        String lang = element.getLanguage();
        return parentlang == null && lang != null || lang != null && parentlang != null && !parentlang.equalsIgnoreCase(lang);
    }

    private static boolean needToWriteDir(Element element) {
        Object parent;
        Bidi.Direction parentdir = Bidi.Direction.UNSPECIFIED;
        Bidi.Direction dir = BidiHelper.getDirection(element);
        if (element.getParentElement() != null && (parent = element.getParentElement()) instanceof Element) {
            parentdir = BidiHelper.getDirection((Element)parent);
        }
        return dir != Bidi.Direction.UNSPECIFIED && !dir.equals((Object)parentdir);
    }

    private static void writeLanguageFields(Element element, JSONStream jstream) throws IOException {
        if (JSONUtil.needToWriteLang(element)) {
            String lang = element.getLanguage();
            jstream.writeField("lang", lang);
        }
        if (JSONUtil.needToWriteDir(element)) {
            Bidi.Direction dir = BidiHelper.getDirection(element);
            jstream.writeField("dir", dir.name().toLowerCase());
        }
    }

    private static void writeElement(String name, Element element, JSONStream jstream) throws IOException {
        if (element != null) {
            jstream.writeField(name);
            JSONUtil.toJson(element, jstream);
        }
    }

    private static boolean writeList(String name, List list, JSONStream jstream) throws IOException {
        if (list == null || list.size() == 0) {
            return false;
        }
        jstream.writeField(name);
        jstream.startArray();
        for (int n = 0; n < list.size(); ++n) {
            Element el = (Element)list.get(n);
            if (el instanceof InReplyTo || el instanceof Control) continue;
            JSONUtil.toJson(el, jstream);
            if (n >= list.size() - 1) continue;
            jstream.writeSeparator();
        }
        jstream.endArray();
        return true;
    }

    private static void toJson(Document document, JSONStream jstream) throws IOException {
        jstream.startObject();
        jstream.writeField("base", document.getBaseUri());
        jstream.writeField("content-type", document.getContentType());
        jstream.writeField("etag", document.getEntityTag());
        jstream.writeField("language", document.getLanguage());
        jstream.writeField("slug", document.getSlug());
        jstream.writeField("last-modified", document.getLastModified());
        Object root = document.getRoot();
        if (root != null) {
            String rootname = root.getQName().getLocalPart();
            JSONUtil.writeElement(rootname, document.getRoot(), jstream);
        }
        jstream.endObject();
    }

    private static Object[] getChildren(Element element) {
        Abdera abdera = element.getFactory().getAbdera();
        XPath xpath = abdera.getXPath();
        List nodes = xpath.selectNodes("node()", element);
        return nodes.toArray(new Object[nodes.size()]);
    }

    private static boolean isSameNamespace(QName q1, QName q2) {
        String n1;
        String p2;
        String p1;
        if (q1 == null && q2 != null) {
            return false;
        }
        if (q1 != null && q2 == null) {
            return false;
        }
        String string = q1 == null ? "" : (p1 = q1.getPrefix() != null ? q1.getPrefix() : "");
        String string2 = q2 == null ? "" : (p2 = q2.getPrefix() != null ? q2.getPrefix() : "");
        String string3 = q1 == null ? "" : (n1 = q1.getNamespaceURI() != null ? q1.getNamespaceURI() : "");
        String n2 = q2 == null ? "" : (q2.getNamespaceURI() != null ? q2.getNamespaceURI() : "");
        return n1.equals(n2) && p1.equals(p2);
    }
}

