/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.servlet;

import com.liferay.portal.kernel.util.Validator;
import com.liferay.util.Encryptor;
import com.liferay.util.EncryptorException;
import java.security.Key;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncryptedServletRequest
extends HttpServletRequestWrapper {
    private Map<String, String[]> _params = new HashMap<String, String[]>();
    private Key _key;

    public EncryptedServletRequest(HttpServletRequest request, Key key) {
        super(request);
        this._key = key;
        Enumeration enu = this.getParameterNames();
        while (enu.hasMoreElements()) {
            String name = (String)enu.nextElement();
            String[] values = super.getParameterValues(name);
            int i = 0;
            while (i < values.length) {
                if (Validator.isNotNull((String)values[i])) {
                    try {
                        values[i] = Encryptor.decrypt(this._key, values[i]);
                    }
                    catch (EncryptorException encryptorException) {
                        values[i] = "";
                    }
                }
                ++i;
            }
            this._params.put(name, values);
        }
    }

    public String getParameter(String name) {
        String[] values = this._params.get(name);
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public Map<String, String[]> getParameterMap() {
        return Collections.unmodifiableMap(this._params);
    }

    public String[] getParameterValues(String name) {
        return this._params.get(name);
    }
}

