/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.shopping.util.comparator;

import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portlet.shopping.model.ShoppingItem;

public class ItemPriceComparator
extends OrderByComparator {
    public static String ORDER_BY_ASC = "categoryId ASC, price ASC, name ASC";
    public static String ORDER_BY_DESC = "categoryId DESC, price DESC, name DESC";
    public static String[] ORDER_BY_FIELDS = new String[]{"categoryId", "price", "name"};
    private boolean _ascending;

    public ItemPriceComparator() {
        this(false);
    }

    public ItemPriceComparator(boolean ascending) {
        this._ascending = ascending;
    }

    public int compare(Object obj1, Object obj2) {
        Long categoryId2;
        ShoppingItem item1 = (ShoppingItem)obj1;
        ShoppingItem item2 = (ShoppingItem)obj2;
        Long categoryId1 = new Long(item1.getCategoryId());
        int value = categoryId1.compareTo(categoryId2 = new Long(item2.getCategoryId()));
        if (value == 0) {
            double price2;
            double price1 = (1.0 - item1.getDiscount()) * item1.getPrice();
            if (price1 < (price2 = (1.0 - item2.getDiscount()) * item2.getPrice())) {
                value = -1;
            } else if (price1 > price2) {
                value = 1;
            }
        }
        if (value == 0) {
            value = item1.getName().toLowerCase().compareTo(item2.getName().toLowerCase());
        }
        if (this._ascending) {
            return value;
        }
        return -value;
    }

    public String getOrderBy() {
        if (this._ascending) {
            return ORDER_BY_ASC;
        }
        return ORDER_BY_DESC;
    }

    public String[] getOrderByFields() {
        return ORDER_BY_FIELDS;
    }

    public boolean isAscending() {
        return this._ascending;
    }
}

