/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import java.util.Enumeration;
import javax.portlet.MimeResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;

public class PortletURLUtil {
    private static final int _CURRENT_URL_PARAMETER_THRESHOLD = 32768;

    public static PortletURL getCurrent(PortletRequest portletRequest, MimeResponse mimeResponse) {
        PortletURL portletURL = mimeResponse.createRenderURL();
        Enumeration enu = portletRequest.getParameterNames();
        while (enu.hasMoreElements()) {
            String param = (String)enu.nextElement();
            String[] values = portletRequest.getParameterValues(param);
            boolean addParam = true;
            int i = 0;
            while (i < values.length) {
                if (values[i].length() > 32768) {
                    addParam = false;
                    break;
                }
                ++i;
            }
            if (!addParam) continue;
            portletURL.setParameter(param, values);
        }
        return portletURL;
    }

    public static PortletURL clone(PortletURL portletURL, MimeResponse mimeResponse) throws PortletException {
        LiferayPortletURL liferayPortletURL = (LiferayPortletURL)portletURL;
        return PortletURLUtil.clone(liferayPortletURL, liferayPortletURL.getLifecycle(), mimeResponse);
    }

    public static PortletURL clone(PortletURL portletURL, String lifecycle, MimeResponse mimeResponse) throws PortletException {
        LiferayPortletURL liferayPortletURL = (LiferayPortletURL)portletURL;
        return PortletURLUtil.clone(liferayPortletURL, lifecycle, mimeResponse);
    }

    public static PortletURL clone(LiferayPortletURL liferayPortletURL, String lifecycle, MimeResponse mimeResponse) throws PortletException {
        PortletMode portletMode;
        LiferayPortletURL newURLImpl = null;
        if (lifecycle.equals("ACTION_PHASE")) {
            newURLImpl = (LiferayPortletURL)mimeResponse.createActionURL();
        } else if (lifecycle.equals("RENDER_PHASE")) {
            newURLImpl = (LiferayPortletURL)mimeResponse.createRenderURL();
        }
        newURLImpl.setPortletId(liferayPortletURL.getPortletId());
        WindowState windowState = liferayPortletURL.getWindowState();
        if (windowState != null) {
            newURLImpl.setWindowState(windowState);
        }
        if ((portletMode = liferayPortletURL.getPortletMode()) != null) {
            newURLImpl.setPortletMode(portletMode);
        }
        newURLImpl.setParameters(liferayPortletURL.getParameterMap());
        return newURLImpl;
    }

    public static String getRefreshURL(HttpServletRequest request, ThemeDisplay themeDisplay) {
        StringBundler sb = new StringBundler();
        sb.append(themeDisplay.getPathMain());
        sb.append("/portal/render_portlet?");
        long plid = themeDisplay.getPlid();
        sb.append("p_l_id=");
        sb.append(plid);
        Portlet portlet = (Portlet)request.getAttribute("RENDER_PORTLET");
        String portletId = portlet.getPortletId();
        sb.append("&p_p_id=");
        sb.append(portletId);
        sb.append("&p_p_lifecycle=0");
        WindowState windowState = WindowState.NORMAL;
        LayoutTypePortlet layoutTypePortlet = themeDisplay.getLayoutTypePortlet();
        if (layoutTypePortlet.hasStateMaxPortletId(portletId)) {
            windowState = WindowState.MAXIMIZED;
        } else if (layoutTypePortlet.hasStateMinPortletId(portletId)) {
            windowState = WindowState.MINIMIZED;
        }
        sb.append("&p_p_state=");
        sb.append(windowState);
        sb.append("&p_p_mode=view");
        String columnId = (String)request.getAttribute("RENDER_PORTLET_COLUMN_ID");
        sb.append("&p_p_col_id=");
        sb.append(columnId);
        Integer columnPos = (Integer)request.getAttribute("RENDER_PORTLET_COLUMN_POS");
        sb.append("&p_p_col_pos=");
        sb.append(columnPos);
        Integer columnCount = (Integer)request.getAttribute("RENDER_PORTLET_COLUMN_COUNT");
        sb.append("&p_p_col_count=");
        sb.append(columnCount);
        if (portlet.isStatic()) {
            sb.append("&p_p_static=1");
            if (portlet.isStaticStart()) {
                sb.append("&p_p_static_start=1");
            }
        }
        sb.append("&p_p_isolated=1");
        String doAsUserId = themeDisplay.getDoAsUserId();
        if (Validator.isNotNull(doAsUserId)) {
            sb.append("&doAsUserId=");
            sb.append(HttpUtil.encodeURL(doAsUserId));
        }
        String currentURL = PortalUtil.getCurrentURL(request);
        sb.append("&currentURL=");
        sb.append(HttpUtil.encodeURL(currentURL));
        String ppid = ParamUtil.getString(request, "p_p_id");
        if (ppid.equals(portletId)) {
            Enumeration enu = request.getParameterNames();
            while (enu.hasMoreElements()) {
                String name = (String)enu.nextElement();
                if (PortalUtil.isReservedParameter(name) || name.equals("currentURL")) continue;
                String[] values = request.getParameterValues(name);
                int i = 0;
                while (i < values.length) {
                    sb.append("&");
                    sb.append(name);
                    sb.append("=");
                    sb.append(HttpUtil.encodeURL(values[i]));
                    ++i;
                }
            }
        }
        return sb.toString();
    }
}

