/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth;

import com.liferay.portal.NoSuchGroupException;
import com.liferay.portal.NoSuchUserException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.ScreenNameGenerator;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;

public class DefaultScreenNameGenerator
implements ScreenNameGenerator {
    private static final String[] _ADMIN_RESERVED_SCREEN_NAMES = StringUtil.split(PropsUtil.get("admin.reserved.screen.names"), "\n");

    public String generate(long companyId, long userId, String emailAddress) throws Exception {
        String[] reservedScreenNames;
        String screenName = null;
        if (Validator.isNotNull(emailAddress)) {
            screenName = StringUtil.extractFirst(emailAddress, "@").toLowerCase();
            if ((screenName = StringUtil.replace(screenName, new String[]{"/", "_"}, new String[]{".", "."})).equals("cyrus") || screenName.equals("postfix")) {
                screenName = String.valueOf(screenName) + "." + userId;
            }
        } else {
            screenName = String.valueOf(userId);
        }
        String[] stringArray = reservedScreenNames = PrefsPropsUtil.getStringArray(companyId, "admin.reserved.screen.names", "\n", _ADMIN_RESERVED_SCREEN_NAMES);
        int n = reservedScreenNames.length;
        int n2 = 0;
        while (n2 < n) {
            String reservedScreenName = stringArray[n2];
            if (screenName.equalsIgnoreCase(reservedScreenName)) {
                return this.getUnusedScreenName(companyId, screenName);
            }
            ++n2;
        }
        try {
            UserLocalServiceUtil.getUserByScreenName(companyId, screenName);
        }
        catch (NoSuchUserException noSuchUserException) {
            try {
                GroupLocalServiceUtil.getFriendlyURLGroup(companyId, "/" + screenName);
            }
            catch (NoSuchGroupException noSuchGroupException) {
                return screenName;
            }
        }
        return this.getUnusedScreenName(companyId, screenName);
    }

    protected String getUnusedScreenName(long companyId, String screenName) throws PortalException, SystemException {
        int i = 1;
        while (true) {
            String tempScreenName = String.valueOf(screenName) + "." + i;
            try {
                UserLocalServiceUtil.getUserByScreenName(companyId, tempScreenName);
            }
            catch (NoSuchUserException noSuchUserException) {
                try {
                    GroupLocalServiceUtil.getFriendlyURLGroup(companyId, "/" + tempScreenName);
                }
                catch (NoSuchGroupException noSuchGroupException) {
                    screenName = tempScreenName;
                    break;
                }
            }
            ++i;
        }
        return screenName;
    }
}

