/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.util.PortalInitableUtil;
import com.liferay.portal.kernel.util.PortalLifecycle;
import java.util.List;
import java.util.Vector;

public class PortalLifecycleUtil {
    private static boolean _inFlushDestroys;
    private static List<PortalLifecycle> _portalLifecyclesDestroy;
    private static List<PortalLifecycle> _portalLifecyclesInit;

    static {
        _portalLifecyclesDestroy = new Vector<PortalLifecycle>();
        _portalLifecyclesInit = new Vector<PortalLifecycle>();
    }

    public static synchronized void flushDestroys() {
        _inFlushDestroys = true;
        for (PortalLifecycle portalLifecycle : _portalLifecyclesDestroy) {
            portalLifecycle.portalDestroy();
        }
        _portalLifecyclesDestroy.clear();
        _inFlushDestroys = false;
    }

    public static synchronized void flushInits() {
        if (_portalLifecyclesInit != null) {
            for (PortalLifecycle portalLifecycle : _portalLifecyclesInit) {
                portalLifecycle.portalInit();
            }
            _portalLifecyclesInit = null;
        }
        PortalInitableUtil.flushInitables();
    }

    public static synchronized void register(PortalLifecycle portalLifecycle) {
        if (_portalLifecyclesInit == null) {
            portalLifecycle.portalInit();
        } else {
            _portalLifecyclesInit.add(portalLifecycle);
        }
        _portalLifecyclesDestroy.add(portalLifecycle);
    }

    public static synchronized void removeDestroy(PortalLifecycle portalLifecycle) {
        if (!_inFlushDestroys) {
            _portalLifecyclesDestroy.remove(portalLifecycle);
        }
    }
}

