/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.portal.kernel.io.unsync.UnsyncPrintWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.jsp.JspWriter;

public class TrimNewLinesJspWriter
extends JspWriter {
    private boolean _lastNewLine;
    private PrintWriter _printWriter;

    public TrimNewLinesJspWriter(PrintWriter printWriter) {
        super(0, false);
        this._printWriter = printWriter;
    }

    public TrimNewLinesJspWriter(Writer writer) {
        super(0, false);
        this._printWriter = new UnsyncPrintWriter(writer, true);
    }

    public void clear() throws IOException {
        throw new IOException();
    }

    public void clearBuffer() {
    }

    public void close() {
        this._printWriter.close();
    }

    public void flush() {
        this._printWriter.flush();
    }

    public int getRemaining() {
        return 0;
    }

    public void newLine() {
        if (!this._lastNewLine) {
            this._printWriter.println();
            this._lastNewLine = true;
        }
    }

    public void print(boolean b) {
        this._printWriter.print(b);
        this._lastNewLine = false;
    }

    public void print(char c) {
        boolean newLine = false;
        if (c == '\n' || c == '\r') {
            newLine = true;
        }
        if (!this._lastNewLine || !newLine) {
            this._printWriter.print(c);
        }
        if (newLine) {
            this._lastNewLine = true;
        }
    }

    public void print(char[] charArray) {
        this._printWriter.print(charArray);
        this._lastNewLine = false;
    }

    public void print(double d) {
        this._printWriter.print(d);
        this._lastNewLine = false;
    }

    public void print(float f) {
        this._printWriter.print(f);
        this._lastNewLine = false;
    }

    public void print(int i) {
        this._printWriter.print(i);
        this._lastNewLine = false;
    }

    public void print(long l) {
        this._printWriter.print(l);
        this._lastNewLine = false;
    }

    public void print(Object object) {
        this._printWriter.print(object);
        this._lastNewLine = false;
    }

    public void print(String string) {
        String trim = this.trim(string);
        if (trim.length() > 0) {
            this._printWriter.print(trim);
            this._lastNewLine = false;
        }
    }

    public void println() {
        if (!this._lastNewLine) {
            this._printWriter.println();
            this._lastNewLine = true;
        }
    }

    public void println(boolean b) {
        this._printWriter.println(b);
        this._lastNewLine = true;
    }

    public void println(char c) {
        this._printWriter.println(c);
        this._lastNewLine = true;
    }

    public void println(char[] charArray) {
        this._printWriter.println(charArray);
        this._lastNewLine = true;
    }

    public void println(double d) {
        this._printWriter.println(d);
        this._lastNewLine = true;
    }

    public void println(float f) {
        this._printWriter.println(f);
        this._lastNewLine = true;
    }

    public void println(int i) {
        this._printWriter.println(i);
        this._lastNewLine = true;
    }

    public void println(long l) {
        this._printWriter.println(l);
        this._lastNewLine = true;
    }

    public void println(Object object) {
        this._printWriter.println(object);
        this._lastNewLine = true;
    }

    public void println(String string) {
        String trim = this.trim(string);
        if (trim.length() > 0) {
            this._printWriter.println(trim);
            this._lastNewLine = true;
        }
    }

    public void write(char[] charArray) {
        this._printWriter.write(charArray);
        this._lastNewLine = false;
    }

    public void write(char[] charArray, int offset, int length) {
        this._printWriter.write(charArray, offset, length);
        this._lastNewLine = false;
    }

    public void write(int c) {
        boolean newLine = false;
        if (c == 10 || c == 13) {
            newLine = true;
        }
        if (!this._lastNewLine || !newLine) {
            this._printWriter.write(c);
        }
        if (newLine) {
            this._lastNewLine = true;
        }
    }

    public void write(String string) {
        String trim = this.trim(string);
        if (trim.length() > 0) {
            this._printWriter.write(trim);
            this._lastNewLine = false;
        }
    }

    public void write(String string, int offset, int length) {
        String trim = this.trim(string.substring(offset, offset + length));
        if (trim.length() > 0) {
            this._printWriter.write(trim);
            this._lastNewLine = false;
        }
    }

    protected String trim(String string) {
        int length;
        int start = length = string.length();
        int i = 0;
        while (i < length) {
            char c = string.charAt(i);
            if (c != '\n' && c != '\r') {
                start = i;
                break;
            }
            ++i;
        }
        int end = 0;
        int i2 = length - 1;
        while (i2 >= 0) {
            char c = string.charAt(i2);
            if (c != '\n' && c != '\r') {
                end = i2 + 1;
                break;
            }
            --i2;
        }
        if (end > start) {
            return string.substring(start, end);
        }
        return "";
    }
}

