/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.messaging.proxy;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.messaging.proxy.ProxyRequest;
import com.liferay.portal.kernel.messaging.proxy.ProxyResponse;
import com.liferay.portal.kernel.util.Validator;

public class ProxyMessageListener
implements MessageListener {
    private static Log _log = LogFactoryUtil.getLog(ProxyMessageListener.class);
    private Object _manager;
    private MessageBus _messageBus;

    public void receive(Message message) {
        ProxyResponse proxyResponse = new ProxyResponse();
        try {
            try {
                Object payload = message.getPayload();
                if (payload == null) {
                    throw new Exception("Payload is null");
                }
                if (!ProxyRequest.class.isAssignableFrom(payload.getClass())) {
                    throw new Exception("Payload " + payload.getClass() + " is not of type " + ProxyRequest.class.getName());
                }
                ProxyRequest proxyRequest = (ProxyRequest)payload;
                Object result = proxyRequest.execute(this._manager);
                proxyResponse.setResult(result);
            }
            catch (Exception e) {
                if (_log.isDebugEnabled()) {
                    _log.debug(e, e);
                }
                proxyResponse.setException(e);
                String responseDestinationName = message.getResponseDestinationName();
                if (Validator.isNotNull(responseDestinationName)) {
                    Message responseMessage = MessageBusUtil.createResponseMessage(message);
                    responseMessage.setPayload(proxyResponse);
                    this._messageBus.sendMessage(responseDestinationName, responseMessage);
                }
            }
        }
        finally {
            String responseDestinationName = message.getResponseDestinationName();
            if (Validator.isNotNull(responseDestinationName)) {
                Message responseMessage = MessageBusUtil.createResponseMessage(message);
                responseMessage.setPayload(proxyResponse);
                this._messageBus.sendMessage(responseDestinationName, responseMessage);
            }
        }
    }

    public void setManager(Object manager) {
        this._manager = manager;
    }

    public void setMessageBus(MessageBus messageBus) {
        this._messageBus = messageBus;
    }
}

