/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.messaging;

import com.liferay.portal.kernel.messaging.BaseDestination;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.util.ThreadLocalRegistry;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParallelDestination
extends BaseDestination {
    public ParallelDestination() {
    }

    public ParallelDestination(String name) {
        super(name);
    }

    public ParallelDestination(String name, int workersCoreSize, int workersMaxSize) {
        super(name, workersCoreSize, workersMaxSize);
    }

    @Override
    protected void dispatch(Set<MessageListener> messageListeners, final Message message) {
        ThreadPoolExecutor threadPoolExecutor = this.getThreadPoolExecutor();
        for (final MessageListener messageListener : messageListeners) {
            Runnable runnable = new Runnable(){

                public void run() {
                    try {
                        messageListener.receive(message);
                    }
                    finally {
                        ThreadLocalRegistry.resetThreadLocals();
                    }
                }
            };
            threadPoolExecutor.execute(runnable);
        }
    }
}

