/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.io;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class FileCacheOutputStream
extends OutputStream {
    private static final int _BUFFER = 2048;
    private static final String _EXTENSION = ".fcos";
    protected FileInputStream _fis;
    protected File _tempFile = File.createTempFile(String.valueOf(PortalUUIDUtil.generate()) + "-", ".fcos");
    protected UnsyncBufferedOutputStream _ubos = new UnsyncBufferedOutputStream(new FileOutputStream(this._tempFile), 2048);
    private static Log _log = LogFactoryUtil.getLog(FileCacheOutputStream.class);

    public void cleanUp() {
        block3: {
            try {
                this.flush();
                this.close();
                if (this._fis != null) {
                    this._fis.close();
                }
                FileUtil.delete(this._tempFile);
            }
            catch (IOException ioe) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn(ioe.getMessage());
            }
        }
    }

    public void close() throws IOException {
        this._ubos.close();
    }

    public void flush() throws IOException {
        this._ubos.flush();
    }

    public byte[] getBytes() throws IOException {
        this.flush();
        this.close();
        return FileUtil.getBytes(this._tempFile);
    }

    public File getFile() throws IOException {
        this.flush();
        this.close();
        return this._tempFile;
    }

    public FileInputStream getFileInputStream() throws IOException {
        if (this._fis == null) {
            this.flush();
            this.close();
            this._fis = new FileInputStream(this._tempFile);
        }
        return this._fis;
    }

    public long getSize() {
        return this._tempFile.length();
    }

    public void write(byte[] b) throws IOException {
        this._ubos.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this._ubos.write(b, off, len);
    }

    public void write(int b) throws IOException {
        this._ubos.write(b);
    }
}

