/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.concurrent;

import java.util.Comparator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoalescedPipe<E> {
    private final AtomicLong _coalescedCount = new AtomicLong(0L);
    private final Comparator<E> _comparator;
    private ElementLink<E> _headElementLink;
    private ElementLink<E> _lastElementLink;
    private final Condition _notEmptyCondition;
    private final AtomicInteger _pendingCount = new AtomicInteger(0);
    private final ReentrantLock _putLock = new ReentrantLock();
    private final ReentrantLock _takeLock = new ReentrantLock();

    public CoalescedPipe() {
        this(null);
    }

    public CoalescedPipe(Comparator<E> comparator) {
        this._comparator = comparator;
        this._notEmptyCondition = this._takeLock.newCondition();
        this._headElementLink = new ElementLink(null);
        this._lastElementLink = this._headElementLink;
    }

    public long coalescedCount() {
        return this._coalescedCount.get();
    }

    public int pendingCount() {
        return this._pendingCount.get();
    }

    public void put(E e) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        int pendingElements = -1;
        this._putLock.lockInterruptibly();
        try {
            if (this._coalesceElement(e)) {
                return;
            }
            ((ElementLink)this._lastElementLink)._nextElementLink = new ElementLink(e);
            this._lastElementLink = ((ElementLink)this._lastElementLink)._nextElementLink;
            pendingElements = this._pendingCount.getAndIncrement();
        }
        finally {
            this._putLock.unlock();
        }
        if (pendingElements == 0) {
            this._takeLock.lock();
            try {
                this._notEmptyCondition.signal();
            }
            finally {
                this._takeLock.unlock();
            }
        }
    }

    public E take() throws InterruptedException {
        Object element = null;
        this._takeLock.lockInterruptibly();
        try {
            while (this._pendingCount.get() == 0) {
                this._notEmptyCondition.await();
            }
            ElementLink<E> garbageELementLink = this._headElementLink;
            this._headElementLink = ((ElementLink)this._headElementLink)._nextElementLink;
            ((ElementLink)garbageELementLink)._nextElementLink = null;
            element = ((ElementLink)this._headElementLink)._element;
            ((ElementLink)this._headElementLink)._element = null;
            int pendingElements = this._pendingCount.getAndDecrement();
            if (pendingElements > 1) {
                this._notEmptyCondition.signal();
            }
        }
        finally {
            this._takeLock.unlock();
        }
        return (E)element;
    }

    public Object[] takeSnapshot() {
        this._putLock.lock();
        this._takeLock.lock();
        try {
            Object[] pendingElements = new Object[this._pendingCount.get()];
            ElementLink currentElementLink = ((ElementLink)this._headElementLink)._nextElementLink;
            int i = 0;
            while (currentElementLink != null) {
                pendingElements[i] = currentElementLink._element;
                currentElementLink = currentElementLink._nextElementLink;
                ++i;
            }
            Object[] objectArray = pendingElements;
            return objectArray;
        }
        finally {
            this._putLock.unlock();
            this._takeLock.unlock();
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean _coalesceElement(E e) {
        try {
            this._takeLock.lockInterruptibly();
            try {
                currentElementLink = ElementLink.access$2(this._headElementLink);
                if (this._comparator == null) ** GOTO lbl19
                while (currentElementLink != null) {
                    if (this._comparator.compare(ElementLink.access$3(currentElementLink), e) == 0) {
                        this._coalescedCount.incrementAndGet();
                        return true;
                    }
                    currentElementLink = ElementLink.access$2(currentElementLink);
                }
                return false;
lbl-1000:
                // 1 sources

                {
                    if (ElementLink.access$3(currentElementLink).equals(e)) {
                        this._coalescedCount.incrementAndGet();
                        return true;
                    }
                    currentElementLink = ElementLink.access$2(currentElementLink);
lbl19:
                    // 2 sources

                    ** while (currentElementLink != null)
                }
lbl20:
                // 1 sources

                return false;
            }
            finally {
                this._takeLock.unlock();
            }
        }
        catch (InterruptedException v0) {}
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ElementLink<E> {
        private E _element;
        private ElementLink<E> _nextElementLink;

        private ElementLink(E element) {
            this._element = element;
        }
    }
}

