/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.cache;

import com.liferay.portal.kernel.cache.Lifecycle;
import com.liferay.portal.kernel.cache.ThreadLocalCache;
import com.liferay.portal.kernel.util.InitialThreadLocal;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadLocalCacheManager {
    private static ThreadLocal<Map<Lifecycle, Map<String, ThreadLocalCache<?>>>> _threadLocalCacheMaps = new InitialThreadLocal(ThreadLocalCacheManager.class + "._threadLocalCacheMaps", new EnumMap(Lifecycle.class));

    public static void clearAll(Lifecycle lifecycle) {
        Map<Lifecycle, Map<String, ThreadLocalCache<?>>> threadLocalCacheMaps = _threadLocalCacheMaps.get();
        Map<String, ThreadLocalCache<?>> threadLocalCacheMap = threadLocalCacheMaps.get((Object)lifecycle);
        if (threadLocalCacheMap != null) {
            threadLocalCacheMap.clear();
        }
    }

    public static void destroy() {
        _threadLocalCacheMaps.remove();
    }

    public static <T> ThreadLocalCache<T> getThreadLocalCache(Lifecycle lifecycle, String name) {
        ThreadLocalCache<Object> threadLocalCache;
        Map<Lifecycle, Map<String, ThreadLocalCache<?>>> threadLocalCacheMaps = _threadLocalCacheMaps.get();
        Map<String, ThreadLocalCache<?>> threadLocalCacheMap = threadLocalCacheMaps.get((Object)lifecycle);
        if (threadLocalCacheMap == null) {
            threadLocalCacheMap = new HashMap();
            threadLocalCacheMaps.put(lifecycle, threadLocalCacheMap);
        }
        if ((threadLocalCache = threadLocalCacheMap.get(name)) == null) {
            threadLocalCache = new ThreadLocalCache(name, lifecycle);
            threadLocalCacheMap.put(name, threadLocalCache);
        }
        return threadLocalCache;
    }
}

