/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.compat.log;

import net.spy.memcached.compat.log.AbstractLogger;
import net.spy.memcached.compat.log.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class Log4JLogger
extends AbstractLogger {
    private final Logger l4jLogger;

    public Log4JLogger(String name) {
        super(name);
        this.l4jLogger = Logger.getLogger((String)name);
    }

    public boolean isDebugEnabled() {
        return this.l4jLogger.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.l4jLogger.isInfoEnabled();
    }

    public void log(Level level, Object message, Throwable e) {
        org.apache.log4j.Level pLevel = org.apache.log4j.Level.DEBUG;
        switch (level == null ? Level.FATAL : level) {
            case DEBUG: {
                pLevel = org.apache.log4j.Level.DEBUG;
                break;
            }
            case INFO: {
                pLevel = org.apache.log4j.Level.INFO;
                break;
            }
            case WARN: {
                pLevel = org.apache.log4j.Level.WARN;
                break;
            }
            case ERROR: {
                pLevel = org.apache.log4j.Level.ERROR;
                break;
            }
            case FATAL: {
                pLevel = org.apache.log4j.Level.FATAL;
                break;
            }
            default: {
                pLevel = org.apache.log4j.Level.FATAL;
                this.l4jLogger.log("net.spy.compat.log.AbstractLogger", (Priority)pLevel, (Object)("Unhandled log level:  " + (Object)((Object)level) + " for the following message"), null);
            }
        }
        this.l4jLogger.log("net.spy.compat.log.AbstractLogger", (Priority)pLevel, message, e);
    }
}

