/*
 * Decompiled with CFR 0.152.
 */
package jodd.util;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import jodd.io.StreamUtil;

public class NetUtil {
    public static String resolveHost(String hostname) {
        try {
            InetAddress addr = Inet4Address.getByName(hostname);
            byte[] ipAddr = addr.getAddress();
            StringBuilder ipAddrStr = new StringBuilder(15);
            for (int i = 0; i < ipAddr.length; ++i) {
                if (i > 0) {
                    ipAddrStr.append('.');
                }
                ipAddrStr.append(ipAddr[i] & 0xFF);
            }
            return ipAddrStr.toString();
        }
        catch (UnknownHostException uhex) {
            return null;
        }
    }

    public static String resolveIp(String ip) {
        try {
            InetAddress addr = InetAddress.getByName(ip);
            return addr.getHostName();
        }
        catch (UnknownHostException uhex) {
            return null;
        }
    }

    public static String resolveIp(byte[] ip) {
        try {
            InetAddress addr = InetAddress.getByAddress(ip);
            return addr.getHostName();
        }
        catch (UnknownHostException uhex) {
            return null;
        }
    }

    public static byte[] downloadBytes(String url) throws IOException {
        HttpURLConnection conection = (HttpURLConnection)new URL(url).openConnection();
        return StreamUtil.readBytes(conection.getInputStream());
    }

    public static String downloadString(String url, String encoding) throws IOException {
        HttpURLConnection conection = (HttpURLConnection)new URL(url).openConnection();
        return new String(StreamUtil.readChars(conection.getInputStream(), encoding));
    }

    public static String downloadString(String url) throws IOException {
        HttpURLConnection conection = (HttpURLConnection)new URL(url).openConnection();
        return new String(StreamUtil.readChars(conection.getInputStream()));
    }
}

