/*
 * Decompiled with CFR 0.152.
 */
package jodd.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import jodd.io.FileUtilParams;
import jodd.io.StreamUtil;

public class FileUtil {
    public static FileUtilParams defaultParams = new FileUtilParams();

    public static boolean equals(String file1, String file2) {
        return FileUtil.equals(new File(file1), new File(file2));
    }

    public static boolean equals(File file1, File file2) {
        try {
            file1 = file1.getCanonicalFile();
            file2 = file2.getCanonicalFile();
        }
        catch (IOException ioex) {
            return false;
        }
        return file1.equals(file2);
    }

    public static File toFile(URL url) {
        return new File(FileUtil.toFileName(url));
    }

    public static String toFileName(URL url) {
        if (url == null || !url.getProtocol().equals("file")) {
            return null;
        }
        String filename = url.getFile().replace('/', File.separatorChar);
        int pos = 0;
        while ((pos = filename.indexOf(37, pos)) >= 0) {
            if (pos + 2 >= filename.length()) continue;
            String hexStr = filename.substring(pos + 1, pos + 3);
            char ch = (char)Integer.parseInt(hexStr, 16);
            filename = filename.substring(0, pos) + ch + filename.substring(pos + 3);
        }
        return filename;
    }

    public static String toFileNames(URL[] urls) {
        StringBuilder path = new StringBuilder();
        for (URL url : urls) {
            String fileName = FileUtil.toFileName(url);
            if (fileName == null) continue;
            path.append(fileName).append(File.pathSeparatorChar);
        }
        return path.toString();
    }

    public static void mkdirs(String dirs) throws IOException {
        FileUtil.mkdirs(new File(dirs));
    }

    public static void mkdirs(File dirs) throws IOException {
        if (dirs.exists()) {
            if (!dirs.isDirectory()) {
                throw new IOException("Directory '' is not a directory.");
            }
            return;
        }
        if (!dirs.mkdirs()) {
            throw new IOException("Unable to create directory '" + dirs + "'.");
        }
    }

    public static void mkdir(String dir) throws IOException {
        FileUtil.mkdir(new File(dir));
    }

    public static void mkdir(File dir) throws IOException {
        if (dir.exists()) {
            if (!dir.isDirectory()) {
                throw new IOException("Destination '' is not a directory.");
            }
            return;
        }
        if (!dir.mkdir()) {
            throw new IOException("Unable to create directory '" + dir + "'.");
        }
    }

    public static void touch(String file) throws IOException {
        FileUtil.touch(new File(file));
    }

    public static void touch(File file) throws IOException {
        if (!file.exists()) {
            StreamUtil.close(new FileOutputStream(file));
        }
        file.setLastModified(System.currentTimeMillis());
    }

    public static FileUtilParams cloneParams() {
        try {
            return defaultParams.clone();
        }
        catch (CloneNotSupportedException cnsex) {
            return null;
        }
    }

    public static FileUtilParams params() {
        return new FileUtilParams();
    }

    public static void copyFile(String src, String dest) throws IOException {
        FileUtil.copyFile(new File(src), new File(dest), defaultParams);
    }

    public static void copyFile(String src, String dest, FileUtilParams params) throws IOException {
        FileUtil.copyFile(new File(src), new File(dest), params);
    }

    public static void copyFile(File src, File dest) throws IOException {
        FileUtil.copyFile(src, dest, defaultParams);
    }

    public static void copyFile(File src, File dest, FileUtilParams params) throws IOException {
        FileUtil.checkFileCopy(src, dest, params);
        FileUtil.doCopyFile(src, dest, params);
    }

    private static void checkFileCopy(File src, File dest, FileUtilParams params) throws IOException {
        if (!src.exists()) {
            throw new FileNotFoundException("Source '" + src + "' does not exist.");
        }
        if (!src.isFile()) {
            throw new IOException("Source '" + src + "' is not a file.");
        }
        if (FileUtil.equals(src, dest)) {
            throw new IOException("Source '" + src + "' and destination '" + dest + "' are the same.");
        }
        File destParent = dest.getParentFile();
        if (destParent != null && !destParent.exists()) {
            if (!params.createDirs) {
                throw new IOException("Destination directory '" + destParent + "' doesn't exist.");
            }
            if (!destParent.mkdirs()) {
                throw new IOException("Destination directory '" + destParent + "' cannot be created.");
            }
        }
    }

    private static void doCopyFile(File src, File dest, FileUtilParams params) throws IOException {
        if (dest.exists()) {
            if (dest.isDirectory()) {
                throw new IOException("Destination '" + dest + "' is a directory.");
            }
            if (!params.overwrite) {
                throw new IOException("Destination '" + dest + "' already exists.");
            }
        }
        FileUtil.doCopy(src, dest);
        if (src.length() != dest.length()) {
            throw new IOException("Copying of '" + src + "' to '" + dest + "' failed due to different sizes.");
        }
        if (params.preserveDate) {
            dest.setLastModified(src.lastModified());
        }
    }

    protected static void doCopy(String src, String dest) throws IOException {
        FileUtil.doCopy(new File(src), new File(dest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void doCopy(File src, File dest) throws IOException {
        FileInputStream input = new FileInputStream(src);
        try {
            FileOutputStream output = new FileOutputStream(dest);
            try {
                StreamUtil.copy((InputStream)input, (OutputStream)output);
            }
            finally {
                StreamUtil.close(output);
            }
        }
        finally {
            StreamUtil.close(input);
        }
    }

    public static void copyFileToDir(String src, String destDir) throws IOException {
        FileUtil.copyFileToDir(new File(src), new File(destDir), defaultParams);
    }

    public static void copyFileToDir(String src, String destDir, FileUtilParams params) throws IOException {
        FileUtil.copyFileToDir(new File(src), new File(destDir), params);
    }

    public static void copyFileToDir(File src, File destDir) throws IOException {
        FileUtil.copyFileToDir(src, destDir, defaultParams);
    }

    public static void copyFileToDir(File src, File destDir, FileUtilParams params) throws IOException {
        if (destDir.exists() && !destDir.isDirectory()) {
            throw new IOException("Destination '" + destDir + "' is not a directory.");
        }
        FileUtil.copyFile(src, new File(destDir, src.getName()), params);
    }

    public static void copyDir(String srcDir, String destDir) throws IOException {
        FileUtil.copyDir(new File(srcDir), new File(destDir), defaultParams);
    }

    public static void copyDir(String srcDir, String destDir, FileUtilParams params) throws IOException {
        FileUtil.copyDir(new File(srcDir), new File(destDir), params);
    }

    public static void copyDir(File srcDir, File destDir) throws IOException {
        FileUtil.copyDir(srcDir, destDir, defaultParams);
    }

    public static void copyDir(File srcDir, File destDir, FileUtilParams params) throws IOException {
        FileUtil.checkDirCopy(srcDir, destDir);
        FileUtil.doCopyDirectory(srcDir, destDir, params);
    }

    private static void checkDirCopy(File srcDir, File destDir) throws IOException {
        if (!srcDir.exists()) {
            throw new FileNotFoundException("Source '" + srcDir + "' does not exist.");
        }
        if (!srcDir.isDirectory()) {
            throw new IOException("Source '" + srcDir + "' is not a directory.");
        }
        if (FileUtil.equals(srcDir, destDir)) {
            throw new IOException("Source '" + srcDir + "' and destination '" + destDir + "' are the same.");
        }
    }

    private static void doCopyDirectory(File srcDir, File destDir, FileUtilParams params) throws IOException {
        File[] files;
        if (destDir.exists()) {
            if (!destDir.isDirectory()) {
                throw new IOException("Destination '" + destDir + "' is not a directory.");
            }
        } else {
            if (!params.createDirs) {
                throw new IOException("Destination '" + destDir + "' doesn't exists.");
            }
            if (!destDir.mkdirs()) {
                throw new IOException("Destination '" + destDir + "' directory cannot be created.");
            }
            if (params.preserveDate) {
                destDir.setLastModified(srcDir.lastModified());
            }
        }
        if ((files = srcDir.listFiles()) == null) {
            throw new IOException("Failed to list contents of '" + srcDir + '\'');
        }
        IOException exception = null;
        for (File file : files) {
            File destFile = new File(destDir, file.getName());
            try {
                if (file.isDirectory()) {
                    if (!params.recursive) continue;
                    FileUtil.doCopyDirectory(file, destFile, params);
                    continue;
                }
                FileUtil.doCopyFile(file, destFile, params);
            }
            catch (IOException ioex) {
                if (params.continueOnError) {
                    exception = ioex;
                    continue;
                }
                throw ioex;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public static void moveFile(String src, String dest) throws IOException {
        FileUtil.moveFile(new File(src), new File(dest), defaultParams);
    }

    public static void moveFile(String src, String dest, FileUtilParams params) throws IOException {
        FileUtil.moveFile(new File(src), new File(dest), params);
    }

    public static void moveFile(File src, File dest) throws IOException {
        FileUtil.moveFile(src, dest, defaultParams);
    }

    public static void moveFile(File src, File dest, FileUtilParams params) throws IOException {
        FileUtil.checkFileCopy(src, dest, params);
        FileUtil.doMoveFile(src, dest, params);
    }

    private static void doMoveFile(File src, File dest, FileUtilParams params) throws IOException {
        if (dest.exists()) {
            if (!dest.isFile()) {
                throw new IOException("Destination '" + dest + "' is not a file.");
            }
            if (!params.overwrite) {
                throw new IOException("Destination '" + dest + "' already exists.");
            }
            dest.delete();
        }
        if (!src.renameTo(dest)) {
            throw new IOException("Moving of '" + src + "' to '" + dest + "' failed.");
        }
    }

    public static void moveFileToDir(String src, String destDir) throws IOException {
        FileUtil.moveFileToDir(new File(src), new File(destDir), defaultParams);
    }

    public static void moveFileToDir(String src, String destDir, FileUtilParams params) throws IOException {
        FileUtil.moveFileToDir(new File(src), new File(destDir), params);
    }

    public static void moveFileToDir(File src, File destDir) throws IOException {
        FileUtil.moveFileToDir(src, destDir, defaultParams);
    }

    public static void moveFileToDir(File src, File destDir, FileUtilParams params) throws IOException {
        if (destDir.exists() && !destDir.isDirectory()) {
            throw new IOException("Destination '" + destDir + "' is not a directory.");
        }
        FileUtil.moveFile(src, new File(destDir, src.getName()), params);
    }

    public static void moveDir(String srcDir, String destDir) throws IOException {
        FileUtil.moveDir(new File(srcDir), new File(destDir));
    }

    public static void moveDir(File srcDir, File destDir) throws IOException {
        FileUtil.checkDirCopy(srcDir, destDir);
        FileUtil.doMoveDirectory(srcDir, destDir);
    }

    private static void doMoveDirectory(File src, File dest) throws IOException {
        if (dest.exists()) {
            if (!dest.isDirectory()) {
                throw new IOException("Destination '" + dest + "' is not a directory.");
            }
            dest = new File(dest, dest.getName());
            dest.mkdir();
        }
        if (!src.renameTo(dest)) {
            throw new IOException("Moving of '" + src + "' to '" + dest + "' failed.");
        }
    }

    public static void deleteFile(String dest) throws IOException {
        FileUtil.deleteFile(new File(dest));
    }

    public static void deleteFile(File dest) throws IOException {
        if (!dest.exists()) {
            throw new FileNotFoundException("Destination '" + dest + "' doesn't exist");
        }
        if (!dest.isFile()) {
            throw new IOException("Destination '" + dest + "' is not a file.");
        }
        if (!dest.delete()) {
            throw new IOException("Unable to delete '" + dest + "'.");
        }
    }

    public static void deleteDir(String dest) throws IOException {
        FileUtil.deleteDir(new File(dest), defaultParams);
    }

    public static void deleteDir(String dest, FileUtilParams params) throws IOException {
        FileUtil.deleteDir(new File(dest), params);
    }

    public static void deleteDir(File dest) throws IOException {
        FileUtil.deleteDir(dest, defaultParams);
    }

    public static void deleteDir(File dest, FileUtilParams params) throws IOException {
        FileUtil.cleanDir(dest, params);
        if (!dest.delete()) {
            throw new IOException("Unable to delete '" + dest + "'.");
        }
    }

    public static void cleanDir(String dest) throws IOException {
        FileUtil.cleanDir(new File(dest), defaultParams);
    }

    public static void cleanDir(String dest, FileUtilParams params) throws IOException {
        FileUtil.cleanDir(new File(dest), params);
    }

    public static void cleanDir(File dest) throws IOException {
        FileUtil.cleanDir(dest, defaultParams);
    }

    public static void cleanDir(File dest, FileUtilParams params) throws IOException {
        if (!dest.exists()) {
            throw new FileNotFoundException("Destination '" + dest + "' doesn't exists.");
        }
        if (!dest.isDirectory()) {
            throw new IOException("Destination '" + dest + "' is not a directory.");
        }
        File[] files = dest.listFiles();
        if (files == null) {
            throw new IOException("Failed to list contents of '" + dest + "'.");
        }
        IOException exception = null;
        for (File file : files) {
            try {
                if (file.isDirectory()) {
                    if (!params.recursive) continue;
                    FileUtil.deleteDir(file, params);
                    continue;
                }
                file.delete();
            }
            catch (IOException ioex) {
                if (params.continueOnError) {
                    exception = ioex;
                    continue;
                }
                throw ioex;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public static String readString(String source) throws IOException {
        return FileUtil.readString(new File(source), FileUtil.defaultParams.encoding);
    }

    public static String readString(String source, String encoding) throws IOException {
        return FileUtil.readString(new File(source), encoding);
    }

    public static String readString(File source) throws IOException {
        return FileUtil.readString(source, FileUtil.defaultParams.encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readString(File source, String encoding) throws IOException {
        String string;
        if (!source.exists()) {
            throw new FileNotFoundException("Source '" + source + "' doesn't exist.");
        }
        if (!source.isFile()) {
            throw new IOException("Source '" + source + "' is not a file.");
        }
        long len = source.length();
        if (len >= Integer.MAX_VALUE) {
            len = Integer.MAX_VALUE;
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(source);
            StringWriter sw = new StringWriter((int)len);
            StreamUtil.copy((InputStream)in, (Writer)sw, encoding);
            string = sw.toString();
        }
        catch (Throwable throwable) {
            StreamUtil.close(in);
            throw throwable;
        }
        StreamUtil.close(in);
        return string;
    }

    public static void writeString(String dest, String data) throws IOException {
        FileUtil.outString(new File(dest), data, FileUtil.defaultParams.encoding, false);
    }

    public static void writeString(String dest, String data, String encoding) throws IOException {
        FileUtil.outString(new File(dest), data, encoding, false);
    }

    public static void writeString(File dest, String data) throws IOException {
        FileUtil.outString(dest, data, FileUtil.defaultParams.encoding, false);
    }

    public static void writeString(File dest, String data, String encoding) throws IOException {
        FileUtil.outString(dest, data, encoding, false);
    }

    public static void appendString(String dest, String data) throws IOException {
        FileUtil.outString(new File(dest), data, FileUtil.defaultParams.encoding, true);
    }

    public static void appendString(String dest, String data, String encoding) throws IOException {
        FileUtil.outString(new File(dest), data, encoding, true);
    }

    public static void appendString(File dest, String data) throws IOException {
        FileUtil.outString(dest, data, FileUtil.defaultParams.encoding, true);
    }

    public static void appendString(File dest, String data, String encoding) throws IOException {
        FileUtil.outString(dest, data, encoding, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void outString(File dest, String data, String encoding, boolean append) throws IOException {
        if (dest.exists() && !dest.isFile()) {
            throw new IOException("Destination '" + dest + "' exist, but it is not a file.");
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(dest, append);
            out.write(data.getBytes(encoding));
        }
        catch (Throwable throwable) {
            StreamUtil.close(out);
            throw throwable;
        }
        StreamUtil.close(out);
    }

    public static String[] readLines(String source) throws IOException {
        return FileUtil.readLines(new File(source), FileUtil.defaultParams.encoding);
    }

    public static String[] readLines(String source, String encoding) throws IOException {
        return FileUtil.readLines(new File(source), encoding);
    }

    public static String[] readLines(File source) throws IOException {
        return FileUtil.readLines(source, FileUtil.defaultParams.encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] readLines(File source, String encoding) throws IOException {
        if (!source.exists()) {
            throw new FileNotFoundException("Source '" + source + "' doesn't exist.");
        }
        if (!source.isFile()) {
            throw new IOException("Source '" + source + "' is not a file.");
        }
        ArrayList<String> list = new ArrayList<String>();
        FileInputStream in = null;
        try {
            String strLine;
            in = new FileInputStream(source);
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, encoding));
            while ((strLine = br.readLine()) != null) {
                list.add(strLine);
            }
        }
        catch (Throwable throwable) {
            StreamUtil.close(in);
            throw throwable;
        }
        StreamUtil.close(in);
        return list.toArray(new String[list.size()]);
    }

    public static byte[] readBytes(String file) throws IOException {
        return FileUtil.readBytes(new File(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBytes(File source) throws IOException {
        byte[] byArray;
        if (!source.exists()) {
            throw new FileNotFoundException("Source '" + source + "' doesn't exist.");
        }
        if (!source.isFile()) {
            throw new IOException("Source '" + source + "' exists, but it is not a file.");
        }
        long len = source.length();
        if (len >= Integer.MAX_VALUE) {
            throw new IOException("Source size is greater then max array size.");
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(source);
            byArray = StreamUtil.readBytes(in);
        }
        catch (Throwable throwable) {
            StreamUtil.close(in);
            throw throwable;
        }
        StreamUtil.close(in);
        return byArray;
    }

    public static void writeBytes(String dest, byte[] data) throws IOException {
        FileUtil.outBytes(new File(dest), data, 0, data.length, false);
    }

    public static void writeBytes(String dest, byte[] data, int off, int len) throws IOException {
        FileUtil.outBytes(new File(dest), data, off, len, false);
    }

    public static void writeBytes(File dest, byte[] data) throws IOException {
        FileUtil.outBytes(dest, data, 0, data.length, false);
    }

    public static void writeBytes(File dest, byte[] data, int off, int len) throws IOException {
        FileUtil.outBytes(dest, data, off, len, false);
    }

    public static void appendBytes(String dest, byte[] data) throws IOException {
        FileUtil.outBytes(new File(dest), data, 0, data.length, true);
    }

    public static void appendBytes(String dest, byte[] data, int off, int len) throws IOException {
        FileUtil.outBytes(new File(dest), data, off, len, true);
    }

    public static void appendBytes(File dest, byte[] data) throws IOException {
        FileUtil.outBytes(dest, data, 0, data.length, true);
    }

    public static void appendBytes(File dest, byte[] data, int off, int len) throws IOException {
        FileUtil.outBytes(dest, data, off, len, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void outBytes(File dest, byte[] data, int off, int len, boolean append) throws IOException {
        if (dest.exists() && !dest.isFile()) {
            throw new IOException("Destination '" + dest + "' exist but it is not a file.");
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(dest, append);
            out.write(data, off, len);
        }
        catch (Throwable throwable) {
            StreamUtil.close(out);
            throw throwable;
        }
        StreamUtil.close(out);
    }

    public static boolean compare(String file1, String file2) throws IOException {
        return FileUtil.compare(new File(file1), new File(file2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean compare(File file1, File file2) throws IOException {
        boolean bl;
        boolean file1Exists = file1.exists();
        if (file1Exists != file2.exists()) {
            return false;
        }
        if (!file1Exists) {
            return true;
        }
        if (!file1.isFile() || !file2.isFile()) {
            throw new IOException("Only files can be compared.");
        }
        if (file1.length() != file2.length()) {
            return false;
        }
        if (FileUtil.equals(file1, file1)) {
            return true;
        }
        FileInputStream input1 = null;
        FileInputStream input2 = null;
        try {
            input1 = new FileInputStream(file1);
            input2 = new FileInputStream(file2);
            bl = StreamUtil.compare(input1, input2);
        }
        catch (Throwable throwable) {
            StreamUtil.close(input1);
            StreamUtil.close(input2);
            throw throwable;
        }
        StreamUtil.close(input1);
        StreamUtil.close(input2);
        return bl;
    }

    public static boolean isNewer(String file, String reference) {
        return FileUtil.isNewer(new File(file), new File(reference));
    }

    public static boolean isNewer(File file, File reference) {
        if (!reference.exists()) {
            throw new IllegalArgumentException("The reference file '" + file + "' doesn't exist");
        }
        return FileUtil.isNewer(file, reference.lastModified());
    }

    public static boolean isOlder(String file, String reference) {
        return FileUtil.isOlder(new File(file), new File(reference));
    }

    public static boolean isOlder(File file, File reference) {
        if (!reference.exists()) {
            throw new IllegalArgumentException("The reference file '" + file + "' doesn't exist");
        }
        return FileUtil.isOlder(file, reference.lastModified());
    }

    public static boolean isNewer(File file, long timeMillis) {
        if (!file.exists()) {
            return false;
        }
        return file.lastModified() > timeMillis;
    }

    public static boolean isNewer(String file, long timeMillis) {
        return FileUtil.isNewer(new File(file), timeMillis);
    }

    public static boolean isOlder(File file, long timeMillis) {
        if (!file.exists()) {
            return false;
        }
        return file.lastModified() < timeMillis;
    }

    public static boolean isOlder(String file, long timeMillis) {
        return FileUtil.isOlder(new File(file), timeMillis);
    }

    public static void copy(String src, String dest) throws IOException {
        FileUtil.copy(new File(src), new File(dest), defaultParams);
    }

    public static void copy(String src, String dest, FileUtilParams params) throws IOException {
        FileUtil.copy(new File(src), new File(dest), params);
    }

    public static void copy(File src, File dest) throws IOException {
        FileUtil.copy(src, dest, defaultParams);
    }

    public static void copy(File src, File dest, FileUtilParams params) throws IOException {
        if (src.isDirectory()) {
            FileUtil.copyDir(src, dest, params);
            return;
        }
        if (dest.isDirectory()) {
            FileUtil.copyFileToDir(src, dest, params);
            return;
        }
        FileUtil.copyFile(src, dest, params);
    }

    public static void move(String src, String dest) throws IOException {
        FileUtil.move(new File(src), new File(dest), defaultParams);
    }

    public static void move(String src, String dest, FileUtilParams params) throws IOException {
        FileUtil.move(new File(src), new File(dest), params);
    }

    public static void move(File src, File dest) throws IOException {
        FileUtil.move(src, dest, defaultParams);
    }

    public static void move(File src, File dest, FileUtilParams params) throws IOException {
        if (src.isDirectory()) {
            FileUtil.moveDir(src, dest);
            return;
        }
        if (dest.isDirectory()) {
            FileUtil.moveFileToDir(src, dest, params);
            return;
        }
        FileUtil.moveFile(src, dest, params);
    }

    public static void delete(String dest) throws IOException {
        FileUtil.delete(new File(dest), defaultParams);
    }

    public static void delete(String dest, FileUtilParams params) throws IOException {
        FileUtil.delete(new File(dest), params);
    }

    public static void delete(File dest) throws IOException {
        FileUtil.delete(dest, defaultParams);
    }

    public static void delete(File dest, FileUtilParams params) throws IOException {
        if (dest.isDirectory()) {
            FileUtil.deleteDir(dest, params);
            return;
        }
        FileUtil.deleteFile(dest);
    }

    public static boolean isAncestor(File ancestor, File file, boolean strict) {
        File parent;
        File file2 = parent = strict ? FileUtil.getParentFile(file) : file;
        while (parent != null) {
            if (parent.equals(ancestor)) {
                return true;
            }
            parent = FileUtil.getParentFile(parent);
        }
        return false;
    }

    public static File getParentFile(File file) {
        int skipCount = 0;
        File parentFile = file;
        while (true) {
            if ((parentFile = parentFile.getParentFile()) == null) {
                return null;
            }
            if (".".equals(parentFile.getName())) continue;
            if ("..".equals(parentFile.getName())) {
                ++skipCount;
                continue;
            }
            if (skipCount <= 0) break;
            --skipCount;
        }
        return parentFile;
    }

    public static boolean isFilePathAcceptable(File file, FileFilter fileFilter) {
        do {
            if (fileFilter == null || fileFilter.accept(file)) continue;
            return false;
        } while ((file = file.getParentFile()) != null);
        return true;
    }

    public static File createTempDirectory(String prefix, String suffix) throws IOException {
        File file = FileUtil.doCreateTempFile(prefix, suffix, null);
        file.delete();
        file.mkdir();
        return file;
    }

    public static File createTempFile(File dir, String prefix, String suffix, boolean create) throws IOException {
        File file = FileUtil.doCreateTempFile(prefix, suffix, dir);
        file.delete();
        if (create) {
            file.createNewFile();
        }
        return file;
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        File file = FileUtil.doCreateTempFile(prefix, suffix, null);
        file.delete();
        file.createNewFile();
        return file;
    }

    private static File doCreateTempFile(String prefix, String suffix, File dir) throws IOException {
        if (prefix.length() < 3) {
            prefix = (prefix + "___").substring(0, 3);
        }
        int exceptionsCount = 0;
        while (true) {
            try {
                return File.createTempFile(prefix, suffix, dir).getCanonicalFile();
            }
            catch (IOException ioex) {
                if (++exceptionsCount < 100) continue;
                throw ioex;
            }
            break;
        }
    }
}

