/*
 * Decompiled with CFR 0.152.
 */
package jodd.cache;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import jodd.cache.AbstractCacheMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LRUCache<K, V>
extends AbstractCacheMap<K, V> {
    public LRUCache(int cacheSize) {
        this(cacheSize, 0L);
    }

    public LRUCache(int cacheSize, long timeout) {
        this.cacheSize = cacheSize;
        this.timeout = timeout;
        this.cacheMap = new LinkedHashMap<K, AbstractCacheMap.CacheObject>(cacheSize + 1, 1.0f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry eldest) {
                return this.size() > LRUCache.this.cacheSize;
            }
        };
    }

    @Override
    public int prune() {
        if (!this.isPruneExpiredActive()) {
            return 0;
        }
        int count = 0;
        Iterator values = this.cacheMap.values().iterator();
        while (values.hasNext()) {
            AbstractCacheMap.CacheObject co = (AbstractCacheMap.CacheObject)values.next();
            if (!co.isExpired()) continue;
            values.remove();
            ++count;
        }
        return count;
    }
}

