/*
 * Decompiled with CFR 0.152.
 */
package jodd.bean.loader;

import java.util.Enumeration;
import javax.servlet.ServletContext;
import jodd.bean.BeanUtil;
import jodd.bean.loader.BeanLoader;

public class ServletContextBeanLoader
implements BeanLoader {
    String prefix;

    public ServletContextBeanLoader() {
    }

    public ServletContextBeanLoader(String prefix) {
        this.prefix = prefix;
    }

    public static void loadBean(Object bean, Object context, String prefix) {
        if (context instanceof ServletContext) {
            Enumeration attribNames = ((ServletContext)context).getAttributeNames();
            while (attribNames.hasMoreElements()) {
                String attribName = (String)attribNames.nextElement();
                Object value = ((ServletContext)context).getAttribute(attribName);
                if (value == null) continue;
                if (prefix != null) {
                    attribName = prefix + Character.toUpperCase(attribName.charAt(0)) + attribName.substring(1);
                }
                try {
                    BeanUtil.setPropertyForcedSilent(bean, attribName, value);
                }
                catch (Exception ex) {}
            }
        }
    }

    public void load(Object bean, Object context) {
        ServletContextBeanLoader.loadBean(bean, context, this.prefix);
    }
}

