/*
 * Decompiled with CFR 0.152.
 */
package jodd.bean;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jodd.bean.BeanException;
import jodd.bean.BeanProperty;
import jodd.bean.BeanUtilUtil;
import jodd.util.ReflectUtil;
import jodd.util.StringUtil;

public class BeanUtil
extends BeanUtilUtil {
    public static final String THIS_REF = "*this";
    private static char[] indexChars = new char[]{'.', '['};

    protected static void resolveNestedProperties(BeanProperty bp) {
        int dotNdx;
        String name = bp.name;
        while ((dotNdx = BeanUtil.indexOfDot(name)) != -1) {
            bp.last = false;
            bp.name = name.substring(0, dotNdx);
            bp.setBean(BeanUtil.getIndexProperty(bp, true));
            name = name.substring(dotNdx + 1);
        }
        bp.last = true;
        bp.name = name;
    }

    protected static boolean resolveExistingNestedProperties(BeanProperty bp) {
        int dotNdx;
        String name = bp.name;
        while ((dotNdx = BeanUtil.indexOfDot(name)) != -1) {
            bp.last = false;
            String temp = bp.name = name.substring(0, dotNdx);
            if (!BeanUtil.hasIndexProperty(bp, true)) {
                return false;
            }
            bp.name = temp;
            bp.setBean(BeanUtil.getIndexProperty(bp, true));
            name = name.substring(dotNdx + 1);
        }
        bp.last = true;
        bp.name = name;
        return true;
    }

    public static boolean hasSimpleProperty(Object bean, String property, boolean suppressSecurity) {
        return BeanUtil.hasSimpleProperty(new BeanProperty(bean, property, false), suppressSecurity);
    }

    protected static boolean hasSimpleProperty(BeanProperty bp, boolean suppressSecurity) {
        Map map;
        if (bp.bean == null) {
            return false;
        }
        bp.field = null;
        bp.method = bp.cd.getBeanGetter(bp.name, suppressSecurity);
        if (bp.method != null) {
            return true;
        }
        bp.field = bp.cd.getField(bp.name, suppressSecurity);
        if (bp.field != null) {
            return true;
        }
        return bp.cd.isMap() && (map = (Map)bp.bean).containsKey(bp.name);
    }

    public static Object getSimpleProperty(Object bean, String property, boolean suppressSecurity) {
        return BeanUtil.getSimpleProperty(new BeanProperty(bean, property, false), suppressSecurity);
    }

    public static Object getSimplePropertyForced(Object bean, String property, boolean suppressSecurity) {
        return BeanUtil.getSimpleProperty(new BeanProperty(bean, property, true), suppressSecurity);
    }

    protected static Object getSimpleProperty(BeanProperty bp, boolean suppressSecurity) {
        if (bp.name.length() == 5 && bp.name.equals(THIS_REF)) {
            return bp.bean;
        }
        bp.field = null;
        bp.method = bp.cd.getBeanGetter(bp.name, suppressSecurity);
        if (bp.method != null) {
            Object result = BeanUtil.invokeGetter(bp.bean, bp.method);
            if (result == null && bp.forced) {
                result = BeanUtil.createBeanProperty(bp);
            }
            return result;
        }
        bp.field = bp.cd.getField(bp.name, suppressSecurity);
        if (bp.field != null) {
            Object result = BeanUtil.getField(bp.bean, bp.field);
            if (result == null && bp.forced) {
                result = BeanUtil.createBeanProperty(bp);
            }
            return result;
        }
        if (bp.cd.isMap()) {
            Map map = (Map)bp.bean;
            if (!map.containsKey(bp.name)) {
                if (!bp.forced) {
                    throw new BeanException("Map key '" + bp.name + "' not found.", bp);
                }
                HashMap value = new HashMap();
                map.put(bp.name, value);
                return value;
            }
            return map.get(bp.name);
        }
        throw new BeanException("Simple property '" + bp.name + "' not found.", bp);
    }

    public static void setSimpleProperty(Object bean, String property, Object value, boolean suppressSecurity) {
        BeanUtil.setSimpleProperty(new BeanProperty(bean, property, false), value, suppressSecurity);
    }

    protected static void setSimpleProperty(BeanProperty bp, Object value, boolean suppressSecurity) {
        Method method = bp.cd.getBeanSetter(bp.name, suppressSecurity);
        if (method != null) {
            BeanUtil.invokeSetter(bp.bean, method, value);
            return;
        }
        Field field = bp.cd.getField(bp.name, suppressSecurity);
        if (field != null) {
            BeanUtil.setField(bp.bean, field, value);
            return;
        }
        if (bp.cd.isMap()) {
            ((Map)bp.bean).put(bp.name, value);
            return;
        }
        throw new BeanException("Simple property '" + bp.name + "' not found.", bp);
    }

    public static boolean hasIndexProperty(Object bean, String property, boolean suppressSecurity) {
        return BeanUtil.hasIndexProperty(new BeanProperty(bean, property, false), suppressSecurity);
    }

    protected static boolean hasIndexProperty(BeanProperty bp, boolean suppressSecurity) {
        if (bp.bean == null) {
            return false;
        }
        String indexString = BeanUtil.extractIndex(bp);
        if (indexString == null) {
            return BeanUtil.hasSimpleProperty(bp, suppressSecurity);
        }
        Object resultBean = BeanUtil.getSimpleProperty(bp, suppressSecurity);
        if (resultBean == null) {
            return false;
        }
        if (resultBean.getClass().isArray()) {
            int index = BeanUtil.parseInt(indexString, bp);
            return index >= 0 && index < Array.getLength(resultBean);
        }
        if (resultBean instanceof List) {
            int index = BeanUtil.parseInt(indexString, bp);
            return index >= 0 && index < ((List)resultBean).size();
        }
        if (resultBean instanceof Map) {
            return ((Map)resultBean).containsKey(indexString);
        }
        return false;
    }

    public static Object getIndexProperty(Object bean, String property, boolean suppressSecurity, boolean forced) {
        return BeanUtil.getIndexProperty(new BeanProperty(bean, property, forced), suppressSecurity);
    }

    protected static Object getIndexProperty(BeanProperty bp, boolean suppressSecurity) {
        String indexString = BeanUtil.extractIndex(bp);
        Object resultBean = BeanUtil.getSimpleProperty(bp, suppressSecurity);
        if (indexString == null) {
            return resultBean;
        }
        if (resultBean == null) {
            throw new BeanException("Index property '" + bp.name + "' is null.", bp);
        }
        if (resultBean.getClass().isArray()) {
            int index = BeanUtil.parseInt(indexString, bp);
            if (bp.forced) {
                return BeanUtil.arrayForcedGet(bp, resultBean, index);
            }
            return Array.get(resultBean, index);
        }
        if (resultBean instanceof List) {
            Object value;
            int index = BeanUtil.parseInt(indexString, bp);
            List list = (List)resultBean;
            if (!bp.forced) {
                return list.get(index);
            }
            if (!bp.last) {
                BeanUtil.ensureListSize(list, index);
            }
            if ((value = list.get(index)) == null) {
                Class<Map> listType = BeanUtil.extracticGenericType(bp, 0);
                if (listType == null) {
                    listType = Map.class;
                }
                try {
                    value = ReflectUtil.newInstance(listType);
                }
                catch (Exception ex) {
                    throw new BeanException("Unable to instatiate list element '" + bp.name + '[' + index + "]'.", bp, ex);
                }
                list.set(index, value);
            }
            return value;
        }
        if (resultBean instanceof Map) {
            Map map = (Map)resultBean;
            if (!bp.forced) {
                return map.get(indexString);
            }
            Object value = map.get(indexString);
            if (!bp.last && value == null) {
                Class<Map> mapType = BeanUtil.extracticGenericType(bp, 1);
                if (mapType == null) {
                    mapType = Map.class;
                }
                try {
                    value = ReflectUtil.newInstance(mapType);
                }
                catch (Exception ex) {
                    throw new BeanException("Unable to instatiate map element '" + bp.name + '[' + indexString + "]'.", bp, ex);
                }
                map.put(indexString, value);
            }
            return value;
        }
        throw new BeanException("Index property '" + bp.name + "' is neither an array, a list or a map.", bp);
    }

    public static void setIndexProperty(Object bean, String property, Object value, boolean suppressSecurity, boolean forced) {
        BeanUtil.setIndexProperty(new BeanProperty(bean, property, forced), value, suppressSecurity);
    }

    protected static void setIndexProperty(BeanProperty bp, Object value, boolean suppressSecurity) {
        String indexString = BeanUtil.extractIndex(bp);
        if (indexString == null) {
            BeanUtil.setSimpleProperty(bp, value, suppressSecurity);
            return;
        }
        Object nextBean = BeanUtil.getSimpleProperty(bp, suppressSecurity);
        if (nextBean.getClass().isArray()) {
            int index = BeanUtil.parseInt(indexString, bp);
            if (bp.forced) {
                BeanUtil.arrayForcedSet(bp, nextBean, index, value);
            } else {
                Array.set(nextBean, index, value);
            }
            return;
        }
        if (nextBean instanceof List) {
            int index = BeanUtil.parseInt(indexString, bp);
            Class listType = BeanUtil.extracticGenericType(bp, 0);
            if (listType != null) {
                value = ReflectUtil.castType(value, listType);
            }
            List list = (List)nextBean;
            if (bp.forced) {
                BeanUtil.ensureListSize(list, index);
            }
            list.set(index, value);
            return;
        }
        if (nextBean instanceof Map) {
            Map map = (Map)nextBean;
            Class mapType = BeanUtil.extracticGenericType(bp, 1);
            if (mapType != null) {
                value = ReflectUtil.castType(value, mapType);
            }
            map.put(indexString, value);
            return;
        }
        throw new BeanException("Index property '" + bp.name + "' is neither an array, a list or a map.", bp);
    }

    public static void setProperty(Object bean, String name, Object value) {
        BeanProperty beanProperty = new BeanProperty(bean, name, false);
        BeanUtil.resolveNestedProperties(beanProperty);
        BeanUtil.setIndexProperty(beanProperty, value, false);
    }

    public static boolean setPropertySilent(Object bean, String name, Object value) {
        BeanProperty beanProperty = new BeanProperty(bean, name, false);
        try {
            BeanUtil.resolveNestedProperties(beanProperty);
            BeanUtil.setIndexProperty(beanProperty, value, false);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static void setPropertyForced(Object bean, String name, Object value) {
        BeanProperty beanProperty = new BeanProperty(bean, name, true);
        BeanUtil.resolveNestedProperties(beanProperty);
        BeanUtil.setIndexProperty(beanProperty, value, false);
    }

    public static boolean setPropertyForcedSilent(Object bean, String name, Object value) {
        BeanProperty beanProperty = new BeanProperty(bean, name, true);
        try {
            BeanUtil.resolveNestedProperties(beanProperty);
            BeanUtil.setIndexProperty(beanProperty, value, false);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static void setDeclaredProperty(Object bean, String name, Object value) {
        BeanProperty beanProperty = new BeanProperty(bean, name, false);
        BeanUtil.resolveNestedProperties(beanProperty);
        BeanUtil.setIndexProperty(beanProperty, value, true);
    }

    public static boolean setDeclaredPropertySilent(Object bean, String name, Object value) {
        BeanProperty beanProperty = new BeanProperty(bean, name, false);
        try {
            BeanUtil.resolveNestedProperties(beanProperty);
            BeanUtil.setIndexProperty(beanProperty, value, true);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static void setDeclaredPropertyForced(Object bean, String name, Object value) {
        BeanProperty beanProperty = new BeanProperty(bean, name, true);
        BeanUtil.resolveNestedProperties(beanProperty);
        BeanUtil.setIndexProperty(beanProperty, value, true);
    }

    public static boolean setDeclaredPropertyForcedSilent(Object bean, String name, Object value) {
        BeanProperty beanProperty = new BeanProperty(bean, name, true);
        try {
            BeanUtil.resolveNestedProperties(beanProperty);
            BeanUtil.setIndexProperty(beanProperty, value, true);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static Object getProperty(Object bean, String name) {
        BeanProperty beanProperty = new BeanProperty(bean, name, false);
        BeanUtil.resolveNestedProperties(beanProperty);
        return BeanUtil.getIndexProperty(beanProperty, false);
    }

    public static Object getPropertySilently(Object bean, String name) {
        BeanProperty beanProperty = new BeanProperty(bean, name, false);
        try {
            BeanUtil.resolveNestedProperties(beanProperty);
            return BeanUtil.getIndexProperty(beanProperty, false);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Object getDeclaredProperty(Object bean, String name) {
        BeanProperty beanProperty = new BeanProperty(bean, name, false);
        BeanUtil.resolveNestedProperties(beanProperty);
        return BeanUtil.getIndexProperty(beanProperty, true);
    }

    public static Object getDeclaredPropertySilently(Object bean, String name) {
        BeanProperty beanProperty = new BeanProperty(bean, name, false);
        try {
            BeanUtil.resolveNestedProperties(beanProperty);
            return BeanUtil.getIndexProperty(beanProperty, true);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static boolean hasProperty(Object bean, String name) {
        BeanProperty beanProperty = new BeanProperty(bean, name, false);
        if (!BeanUtil.resolveExistingNestedProperties(beanProperty)) {
            return false;
        }
        return BeanUtil.hasIndexProperty(beanProperty, false);
    }

    public static boolean hasDeclaredProperty(Object bean, String name) {
        BeanProperty beanProperty = new BeanProperty(bean, name, false);
        if (!BeanUtil.resolveExistingNestedProperties(beanProperty)) {
            return false;
        }
        return BeanUtil.hasIndexProperty(beanProperty, true);
    }

    public static Class getPropertyType(Object bean, String name) {
        BeanProperty beanProperty = new BeanProperty(bean, name, false);
        if (!BeanUtil.resolveExistingNestedProperties(beanProperty)) {
            return null;
        }
        BeanUtil.hasIndexProperty(beanProperty, false);
        return BeanUtil.extractType(beanProperty);
    }

    public static Class getDeclaredPropertyType(Object bean, String name) {
        BeanProperty beanProperty = new BeanProperty(bean, name, false);
        if (!BeanUtil.resolveExistingNestedProperties(beanProperty)) {
            return null;
        }
        BeanUtil.hasIndexProperty(beanProperty, true);
        return BeanUtil.extractType(beanProperty);
    }

    public static String extractThisReference(String propertyName) {
        int ndx = StringUtil.indexOfChars(propertyName, indexChars);
        if (ndx == -1) {
            return propertyName;
        }
        return propertyName.substring(0, ndx);
    }
}

