/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.server.adapters.jcr;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.activation.MimeType;
import javax.jcr.Credentials;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.Workspace;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.i18n.text.Sanitizer;
import org.apache.abdera.model.Content;
import org.apache.abdera.model.Person;
import org.apache.abdera.model.Text;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.ResponseContext;
import org.apache.abdera.protocol.server.adapters.jcr.SessionPoolManager;
import org.apache.abdera.protocol.server.context.EmptyResponseContext;
import org.apache.abdera.protocol.server.context.ResponseContextException;
import org.apache.abdera.protocol.server.impl.AbstractEntityCollectionAdapter;
import org.apache.abdera.protocol.util.PoolManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jackrabbit.api.JackrabbitNodeTypeManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrCollectionAdapter
extends AbstractEntityCollectionAdapter<Node> {
    private static final Log log = LogFactory.getLog(JcrCollectionAdapter.class);
    private static final String TITLE = "title";
    private static final String SUMMARY = "summary";
    private static final String UPDATED = "updated";
    private static final String AUTHOR = "author";
    private static final String AUTHOR_EMAIL = "author.email";
    private static final String AUTHOR_LANGUAGE = "author.language";
    private static final String AUTHOR_NAME = "author.name";
    private static final String CONTENT = "content";
    private static final String SESSION_KEY = "jcrSession";
    private static final String MEDIA = "media";
    private static final String CONTENT_TYPE = "contentType";
    private static final String NAMESPACE = "http://abdera.apache.org";
    private String collectionNodePath;
    private String id;
    private String title;
    private String author;
    private String collectionNodeId;
    private Repository repository;
    private Credentials credentials;
    private int maxActiveSessions = 100;
    private PoolManager<Session> sessionPool;

    public void setCollectionNodePath(String collectionNodePath) {
        this.collectionNodePath = collectionNodePath;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws Exception {
        Session session = this.repository.login(this.credentials);
        Node collectionNode = null;
        try {
            collectionNode = session.getRootNode().getNode(this.collectionNodePath);
        }
        catch (PathNotFoundException e) {
            collectionNode = session.getRootNode().addNode(this.collectionNodePath);
            collectionNode.addMixin("mix:referenceable");
            session.save();
        }
        this.collectionNodeId = collectionNode.getUUID();
        this.id = "urn:" + this.collectionNodeId;
        Workspace workspace = session.getWorkspace();
        JackrabbitNodeTypeManager jntmgr = (JackrabbitNodeTypeManager)workspace.getNodeTypeManager();
        if (!jntmgr.hasNodeType("abdera:entry")) {
            InputStream in = this.getClass().getResourceAsStream("/org/apache/abdera/jcr/nodeTypes.xml");
            try {
                jntmgr.registerNodeTypes(in, "text/xml");
            }
            finally {
                in.close();
            }
        }
        session.logout();
        this.sessionPool = new SessionPoolManager(this.maxActiveSessions, this.repository, this.credentials);
    }

    @Override
    public void start(RequestContext request) throws ResponseContextException {
        try {
            Session session = (Session)this.sessionPool.get(request);
            request.setAttribute(RequestContext.Scope.REQUEST, SESSION_KEY, session);
        }
        catch (Exception e) {
            throw new ResponseContextException(500, (Throwable)e);
        }
    }

    @Override
    public void end(RequestContext request, ResponseContext response) {
        Session session = this.getSession(request);
        if (session != null) {
            try {
                this.sessionPool.release(session);
            }
            catch (Exception e) {
                log.warn((Object)"Could not return Session to pool!", (Throwable)e);
            }
        }
    }

    @Override
    public String getContentType(Node entry) {
        try {
            return JcrCollectionAdapter.getStringOrNull(entry, CONTENT_TYPE);
        }
        catch (ResponseContextException e) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public boolean isMediaEntry(Node entry) throws ResponseContextException {
        try {
            return entry.hasProperty(MEDIA);
        }
        catch (RepositoryException e) {
            throw new ResponseContextException(500, (Throwable)e);
        }
    }

    @Override
    public Node postMedia(MimeType mimeType, String slug, InputStream inputStream, RequestContext request) throws ResponseContextException {
        if (slug == null) {
            throw new ResponseContextException("A slug header must be supplied.", 500);
        }
        Node n = this.postEntry(slug, null, null, new Date(), null, null, request);
        try {
            n.setProperty(MEDIA, inputStream);
            n.setProperty(CONTENT_TYPE, mimeType.toString());
            String summary = this.postSummaryForEntry(n);
            if (summary != null) {
                n.setProperty(SUMMARY, summary);
            }
            this.getSession(request).save();
            return n;
        }
        catch (RepositoryException e) {
            try {
                this.getSession(request).refresh(false);
            }
            catch (Throwable t) {
                log.warn((Object)t);
            }
            throw new ResponseContextException(500, (Throwable)e);
        }
    }

    protected String postSummaryForEntry(Node n) {
        return null;
    }

    @Override
    public Node postEntry(String title, IRI id, String summary, Date updated, List<Person> authors, Content content, RequestContext request) throws ResponseContextException {
        Session session = this.getSession(request);
        try {
            Node collectionNode = session.getNodeByUUID(this.collectionNodeId);
            String resourceName = Sanitizer.sanitize(title, "-");
            return this.postEntry(title, summary, updated, authors, content, session, collectionNode, resourceName, 0);
        }
        catch (RepositoryException e) {
            try {
                session.refresh(false);
            }
            catch (Throwable t) {
                log.warn((Object)t);
            }
            throw new ResponseContextException(500, (Throwable)e);
        }
    }

    protected Node postEntry(String title, String summary, Date updated, List<Person> authors, Content content, Session session, Node collectionNode, String resourceName, int num) throws ResponseContextException, RepositoryException {
        try {
            String name = resourceName;
            if (num > 0) {
                name = name + "_" + num;
            }
            Node entry = collectionNode.addNode(name, "abdera:entry");
            entry.addMixin("mix:referenceable");
            this.mapEntryToNode(entry, title, summary, updated, authors, content, session);
            session.save();
            return entry;
        }
        catch (ItemExistsException e) {
            return this.postEntry(title, summary, updated, authors, content, session, collectionNode, resourceName, ++num);
        }
    }

    private Node mapEntryToNode(Node entry, String title, String summary, Date updated, List<Person> authors, Content content, Session session) throws ResponseContextException, RepositoryException {
        if (title == null) {
            EmptyResponseContext ctx = new EmptyResponseContext(500);
            ctx.setStatusText("Entry title cannot be empty.");
            throw new ResponseContextException(ctx);
        }
        entry.setProperty(TITLE, title);
        if (summary != null) {
            entry.setProperty(SUMMARY, summary);
        }
        Calendar upCal = Calendar.getInstance();
        upCal.setTime(updated);
        entry.setProperty(UPDATED, upCal);
        if (authors != null) {
            for (Person p : authors) {
                Node addNode = entry.addNode(AUTHOR);
                addNode.setProperty(AUTHOR_EMAIL, p.getEmail());
                addNode.setProperty(AUTHOR_LANGUAGE, p.getLanguage());
                addNode.setProperty(AUTHOR_NAME, p.getName());
            }
        }
        if (content != null) {
            entry.setProperty(CONTENT, content.getText());
        }
        if (summary != null) {
            entry.setProperty(SUMMARY, summary);
        }
        return entry;
    }

    private Session getSession(RequestContext request) {
        return (Session)request.getAttribute(RequestContext.Scope.REQUEST, SESSION_KEY);
    }

    @Override
    public void deleteEntry(String resourceName, RequestContext request) throws ResponseContextException {
        Session session = this.getSession(request);
        try {
            this.getNode(session, resourceName).remove();
            session.save();
        }
        catch (RepositoryException e) {
            try {
                session.refresh(false);
            }
            catch (Throwable t) {
                log.warn((Object)t);
            }
            throw new ResponseContextException(500, (Throwable)e);
        }
    }

    private Node getNode(Session session, String resourceName) throws ResponseContextException, RepositoryException {
        try {
            return session.getNodeByUUID(this.collectionNodeId).getNode(resourceName);
        }
        catch (PathNotFoundException e) {
            throw new ResponseContextException(404);
        }
    }

    public static void dump(Node node) throws RepositoryException {
        System.out.println(node.getPath());
        if (node.getName().equals("jcr:system")) {
            return;
        }
        PropertyIterator properties = node.getProperties();
        while (properties.hasNext()) {
            Property property = properties.nextProperty();
            if (property.getDefinition().isMultiple()) {
                Value[] values = property.getValues();
                for (int i = 0; i < values.length; ++i) {
                    System.out.println(property.getPath() + " = " + values[i].getString());
                }
                continue;
            }
            System.out.println(property.getPath() + " = " + property.getString());
        }
        NodeIterator nodes = node.getNodes();
        while (nodes.hasNext()) {
            JcrCollectionAdapter.dump(nodes.nextNode());
        }
    }

    @Override
    public String getAuthor(RequestContext request) throws ResponseContextException {
        return this.author;
    }

    @Override
    public List<Person> getAuthors(Node entry, RequestContext request) throws ResponseContextException {
        try {
            ArrayList<Person> authors = new ArrayList<Person>();
            NodeIterator nodes = entry.getNodes();
            while (nodes.hasNext()) {
                Node n = nodes.nextNode();
                if (!n.getName().equals(AUTHOR)) continue;
                Person author = request.getAbdera().getFactory().newAuthor();
                author.setName(JcrCollectionAdapter.getStringOrNull(entry, AUTHOR_NAME));
                author.setEmail(JcrCollectionAdapter.getStringOrNull(entry, AUTHOR_EMAIL));
                author.setLanguage(JcrCollectionAdapter.getStringOrNull(entry, AUTHOR_LANGUAGE));
                authors.add(author);
            }
            return authors;
        }
        catch (RepositoryException e) {
            throw new ResponseContextException(500, (Throwable)e);
        }
    }

    @Override
    public Object getContent(Node entry, RequestContext request) throws ResponseContextException {
        return JcrCollectionAdapter.getStringOrNull(entry, CONTENT);
    }

    @Override
    public Iterable<Node> getEntries(RequestContext request) throws ResponseContextException {
        ArrayList<Node> entries = new ArrayList<Node>();
        Session session = this.getSession(request);
        try {
            Node n = session.getNodeByUUID(this.collectionNodeId);
            NodeIterator nodes = n.getNodes();
            while (nodes.hasNext()) {
                entries.add(nodes.nextNode());
            }
        }
        catch (RepositoryException e) {
            throw new ResponseContextException(500, (Throwable)e);
        }
        return entries;
    }

    @Override
    public Node getEntry(String resourceName, RequestContext request) throws ResponseContextException {
        try {
            return this.getNode(this.getSession(request), resourceName);
        }
        catch (RepositoryException e) {
            throw new ResponseContextException(500, (Throwable)e);
        }
    }

    @Override
    public String getId(RequestContext request) {
        return this.id;
    }

    @Override
    public String getId(Node entry) throws ResponseContextException {
        try {
            return "urn:" + entry.getUUID();
        }
        catch (RepositoryException e) {
            throw new ResponseContextException(500, (Throwable)e);
        }
    }

    @Override
    public String getMediaName(Node entry) throws ResponseContextException {
        return this.getName(entry);
    }

    @Override
    public InputStream getMediaStream(Node entry) throws ResponseContextException {
        try {
            Value value = JcrCollectionAdapter.getValueOrNull(entry, MEDIA);
            return value != null ? value.getStream() : null;
        }
        catch (RepositoryException e) {
            throw new ResponseContextException(500, (Throwable)e);
        }
    }

    @Override
    public String getName(Node entry) throws ResponseContextException {
        try {
            return entry.getName();
        }
        catch (RepositoryException e) {
            throw new ResponseContextException(500, (Throwable)e);
        }
    }

    @Override
    public Text getSummary(Node entry, RequestContext request) throws ResponseContextException {
        Text summary = request.getAbdera().getFactory().newSummary();
        summary.setText(JcrCollectionAdapter.getStringOrNull(entry, SUMMARY));
        return summary;
    }

    @Override
    public String getTitle(RequestContext request) {
        return this.title;
    }

    @Override
    public String getTitle(Node entry) throws ResponseContextException {
        return JcrCollectionAdapter.getStringOrNull(entry, TITLE);
    }

    @Override
    public Date getUpdated(Node entry) throws ResponseContextException {
        Calendar updated = JcrCollectionAdapter.getDateOrNull(entry, UPDATED);
        return updated != null ? updated.getTime() : null;
    }

    @Override
    public void putEntry(Node entry, String title, Date updated, List<Person> authors, String summary, Content content, RequestContext request) throws ResponseContextException {
        Session session = this.getSession(request);
        try {
            this.mapEntryToNode(entry, title, summary, updated, authors, content, session);
        }
        catch (RepositoryException e) {
            throw new ResponseContextException(500, (Throwable)e);
        }
    }

    public static String getStringOrNull(Node node, String propName) throws ResponseContextException {
        try {
            Value v = JcrCollectionAdapter.getValueOrNull(node, propName);
            return v != null ? v.getString() : null;
        }
        catch (RepositoryException e) {
            throw new ResponseContextException(500, (Throwable)e);
        }
    }

    @Override
    public ResponseContext getCategories(RequestContext request) {
        return null;
    }

    public static Calendar getDateOrNull(Node node, String propName) throws ResponseContextException {
        try {
            Value v = JcrCollectionAdapter.getValueOrNull(node, propName);
            return v != null ? v.getDate() : null;
        }
        catch (RepositoryException e) {
            throw new ResponseContextException(500, (Throwable)e);
        }
    }

    public static Value getValueOrNull(Node node, String propName) throws RepositoryException {
        return node.hasProperty(propName) ? node.getProperty(propName).getValue() : null;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    public void setMaxActiveSessions(int maxActiveSessions) {
        this.maxActiveSessions = maxActiveSessions;
    }
}

