/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.commons;

import org.objectweb.asm.Label;
import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

public class LocalVariablesSorter
extends MethodAdapter {
    private static final Type OBJECT_TYPE = Type.getObjectType("java/lang/Object");
    private int[] mapping = new int[40];
    private Object[] newLocals = new Object[20];
    protected final int firstLocal;
    protected int nextLocal;
    private boolean changed;

    public LocalVariablesSorter(int n, String string2, MethodVisitor methodVisitor) {
        super(methodVisitor);
        Type[] typeArray = Type.getArgumentTypes(string2);
        this.nextLocal = (8 & n) == 0 ? 1 : 0;
        for (int i = 0; i < typeArray.length; ++i) {
            this.nextLocal += typeArray[i].getSize();
        }
        this.firstLocal = this.nextLocal;
    }

    public void visitVarInsn(int n, int n2) {
        Type type2;
        switch (n) {
            case 22: 
            case 55: {
                type2 = Type.LONG_TYPE;
                break;
            }
            case 24: 
            case 57: {
                type2 = Type.DOUBLE_TYPE;
                break;
            }
            case 23: 
            case 56: {
                type2 = Type.FLOAT_TYPE;
                break;
            }
            case 21: 
            case 54: {
                type2 = Type.INT_TYPE;
                break;
            }
            case 25: 
            case 58: {
                type2 = OBJECT_TYPE;
                break;
            }
            default: {
                type2 = Type.VOID_TYPE;
            }
        }
        this.mv.visitVarInsn(n, this.remap(n2, type2));
    }

    public void visitIincInsn(int n, int n2) {
        this.mv.visitIincInsn(this.remap(n, Type.INT_TYPE), n2);
    }

    public void visitMaxs(int n, int n2) {
        this.mv.visitMaxs(n, this.nextLocal);
    }

    public void visitLocalVariable(String string2, String string3, String string4, Label label, Label label2, int n) {
        int n2 = this.remap(n, Type.getType(string3));
        this.mv.visitLocalVariable(string2, string3, string4, label, label2, n2);
    }

    public void visitFrame(int n, int n2, Object[] objectArray, int n3, Object[] objectArray2) {
        int n4;
        if (n != -1) {
            throw new IllegalStateException("ClassReader.accept() should be called with EXPAND_FRAMES flag");
        }
        if (!this.changed) {
            this.mv.visitFrame(n, n2, objectArray, n3, objectArray2);
            return;
        }
        Object[] objectArray3 = new Object[this.newLocals.length];
        System.arraycopy(this.newLocals, 0, objectArray3, 0, objectArray3.length);
        int n5 = 0;
        for (n4 = 0; n4 < n2; ++n4) {
            int n6;
            Object object = objectArray[n4];
            int n7 = n6 = object == Opcodes.LONG || object == Opcodes.DOUBLE ? 2 : 1;
            if (object != Opcodes.TOP) {
                this.setFrameLocal(this.remap(n5, n6), object);
            }
            n5 += n6;
        }
        n5 = 0;
        n4 = 0;
        int n8 = 0;
        while (n5 < this.newLocals.length) {
            Object object;
            if ((object = this.newLocals[n5++]) != null && object != Opcodes.TOP) {
                this.newLocals[n8] = object;
                n4 = n8 + 1;
                if (object == Opcodes.LONG || object == Opcodes.DOUBLE) {
                    ++n5;
                }
            } else {
                this.newLocals[n8] = Opcodes.TOP;
            }
            ++n8;
        }
        this.mv.visitFrame(n, n4, this.newLocals, n3, objectArray2);
        this.newLocals = objectArray3;
    }

    public int newLocal(Type type2) {
        Object object;
        switch (type2.getSort()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                object = Opcodes.INTEGER;
                break;
            }
            case 6: {
                object = Opcodes.FLOAT;
                break;
            }
            case 7: {
                object = Opcodes.LONG;
                break;
            }
            case 8: {
                object = Opcodes.DOUBLE;
                break;
            }
            case 9: {
                object = type2.getDescriptor();
                break;
            }
            default: {
                object = type2.getInternalName();
            }
        }
        int n = this.nextLocal;
        this.nextLocal += type2.getSize();
        this.setLocalType(n, type2);
        this.setFrameLocal(n, object);
        return n;
    }

    protected void setLocalType(int n, Type type2) {
    }

    private void setFrameLocal(int n, Object object) {
        int n2 = this.newLocals.length;
        if (n >= n2) {
            Object[] objectArray = new Object[Math.max(2 * n2, n + 1)];
            System.arraycopy(this.newLocals, 0, objectArray, 0, n2);
            this.newLocals = objectArray;
        }
        this.newLocals[n] = object;
    }

    private int remap(int n, Type type2) {
        int n2;
        int n3;
        if (n < this.firstLocal) {
            return n;
        }
        int n4 = 2 * n + type2.getSize() - 1;
        if (n4 >= (n3 = this.mapping.length)) {
            int[] nArray = new int[Math.max(2 * n3, n4 + 1)];
            System.arraycopy(this.mapping, 0, nArray, 0, n3);
            this.mapping = nArray;
        }
        if ((n2 = this.mapping[n4]) == 0) {
            n2 = this.newLocalMapping(type2);
            this.setLocalType(n2, type2);
            this.mapping[n4] = n2 + 1;
        } else {
            --n2;
        }
        if (n2 != n) {
            this.changed = true;
        }
        return n2;
    }

    protected int newLocalMapping(Type type2) {
        int n = this.nextLocal;
        this.nextLocal += type2.getSize();
        return n;
    }

    private int remap(int n, int n2) {
        int n3;
        if (n < this.firstLocal || !this.changed) {
            return n;
        }
        int n4 = 2 * n + n2 - 1;
        int n5 = n3 = n4 < this.mapping.length ? this.mapping[n4] : 0;
        if (n3 == 0) {
            throw new IllegalStateException("Unknown local variable " + n);
        }
        return n3 - 1;
    }
}

