/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import java.util.TreeSet;
import org.jruby.compiler.ir.IR_Closure;
import org.jruby.compiler.ir.IR_Loop;
import org.jruby.compiler.ir.IR_Scope;
import org.jruby.compiler.ir.IR_ScopeImpl;
import org.jruby.compiler.ir.instructions.CallInstruction;
import org.jruby.compiler.ir.instructions.IR_Instr;
import org.jruby.compiler.ir.instructions.RECV_CLOSURE_Instr;
import org.jruby.compiler.ir.instructions.RUBY_INTERNALS_CALL_Instr;
import org.jruby.compiler.ir.operands.MethAddr;
import org.jruby.compiler.ir.operands.Operand;
import org.jruby.compiler.ir.operands.Variable;
import org.jruby.compiler.ir.representations.CFG;
import org.jruby.runtime.Frame;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IR_ExecutionScope
extends IR_ScopeImpl {
    private Frame _frame;
    private List<IR_Instr> _instrs;
    private CFG _cfg;
    private List<IR_Closure> _closures;
    private boolean _canCaptureCallersFrame;
    private boolean _canModifyCode;
    private boolean _requiresFrame;
    private Stack<IR_Loop> _loopStack;

    private void init() {
        this._instrs = new ArrayList<IR_Instr>();
        this._closures = new ArrayList<IR_Closure>();
        this._loopStack = new Stack();
        this._canModifyCode = true;
        this._canCaptureCallersFrame = true;
        this._requiresFrame = true;
    }

    public IR_ExecutionScope(IR_Scope lexicalParent, Operand container) {
        super(lexicalParent, container);
        this.init();
    }

    public void addClosure(IR_Closure c) {
        this._closures.add(c);
    }

    @Override
    public void addInstr(IR_Instr i) {
        this._instrs.add(i);
    }

    public void startLoop(IR_Loop l) {
        this._loopStack.push(l);
    }

    public void endLoop(IR_Loop l) {
        this._loopStack.pop();
    }

    public IR_Loop getCurrentLoop() {
        return this._loopStack.isEmpty() ? null : this._loopStack.peek();
    }

    public List<IR_Closure> getClosures() {
        return this._closures;
    }

    @Override
    public List<IR_Instr> getInstrs() {
        return this._instrs;
    }

    public void setCodeModificationFlag(boolean f) {
        this._canModifyCode = f;
    }

    public boolean modifiesCode() {
        return this._canModifyCode;
    }

    public boolean requiresFrame() {
        return this._requiresFrame;
    }

    public boolean canCaptureCallersFrame() {
        return this._canCaptureCallersFrame;
    }

    public CFG buildCFG() {
        this._cfg = new CFG(this);
        this._cfg.build(this._instrs);
        return this._cfg;
    }

    public CFG getCFG() {
        return this._cfg;
    }

    public void computeExecutionScopeFlags() {
        this._canModifyCode = true;
        this._canCaptureCallersFrame = false;
        this._requiresFrame = false;
        boolean receivesClosureArg = false;
        for (IR_Instr i : this.getInstrs()) {
            if (i instanceof RECV_CLOSURE_Instr) {
                receivesClosureArg = true;
            }
            if (i instanceof RUBY_INTERNALS_CALL_Instr && ((CallInstruction)i).getMethodAddr() == MethAddr.ZSUPER) {
                this._canCaptureCallersFrame = true;
            }
            if (!(i instanceof CallInstruction)) continue;
            CallInstruction call2 = (CallInstruction)i;
            if (call2.requiresFrame()) {
                this._requiresFrame = true;
            }
            if (!receivesClosureArg || !call2.canBeEval() || call2.getNumArgs() <= 1) continue;
            this._canCaptureCallersFrame = true;
        }
    }

    @Override
    public String toStringInstrs() {
        StringBuilder b = new StringBuilder();
        int i = 0;
        for (IR_Instr instr : this._instrs) {
            if (i > 0) {
                b.append("\n");
            }
            b.append("  ").append(i).append('\t');
            if (instr.isDead()) {
                b.append("[DEAD]");
            }
            b.append(instr);
            ++i;
        }
        if (!this._closures.isEmpty()) {
            b.append("\n\n------ Closures encountered in this scope ------\n");
            for (IR_Closure c : this._closures) {
                b.append(c.toStringBody());
            }
            b.append("------------------------------------------------\n");
        }
        return b.toString();
    }

    @Override
    public String toStringVariables() {
        int i;
        StringBuilder sb = new StringBuilder();
        HashMap<Variable, Integer> ends = new HashMap<Variable, Integer>();
        HashMap<Variable, Integer> starts = new HashMap<Variable, Integer>();
        TreeSet<Variable> variables = new TreeSet<Variable>();
        for (i = this._instrs.size() - 1; i >= 0; --i) {
            IR_Instr instr = this._instrs.get(i);
            Variable var = instr._result;
            if (var != null) {
                variables.add(var);
                starts.put(var, i);
            }
            for (Operand operand : instr.getOperands()) {
                if (operand == null || !(operand instanceof Variable) || ends.get((Variable)operand) != null) continue;
                ends.put((Variable)operand, i);
                variables.add((Variable)operand);
            }
        }
        i = 0;
        for (Variable var : variables) {
            Integer end2 = (Integer)ends.get(var);
            if (end2 == null) continue;
            if (i > 0) {
                sb.append("\n");
            }
            ++i;
            sb.append("    " + var + ": " + starts.get(var) + "-" + end2);
        }
        return sb.toString();
    }
}

