/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.apache.poi.POIXMLDocument;
import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.POIXMLException;
import org.apache.poi.POIXMLProperties;
import org.apache.poi.hssf.record.formula.SheetNameFormatter;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackagePartName;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.openxml4j.opc.PackagingURIHelper;
import org.apache.poi.openxml4j.opc.TargetMode;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;
import org.apache.poi.util.PackageHelper;
import org.apache.poi.xssf.model.CalculationChain;
import org.apache.poi.xssf.model.MapInfo;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFCreationHelper;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFDialogsheet;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFFactory;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFMap;
import org.apache.poi.xssf.usermodel.XSSFName;
import org.apache.poi.xssf.usermodel.XSSFPictureData;
import org.apache.poi.xssf.usermodel.XSSFPrintSetup;
import org.apache.poi.xssf.usermodel.XSSFRelation;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.openxmlformats.schemas.officeDocument.x2006.relationships.STRelationshipId;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTBookView;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTBookViews;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTDefinedName;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTDefinedNames;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTDialogsheet;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSheet;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSheets;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorkbook;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorkbookPr;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorkbookProtection;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorksheet;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STSheetState;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.WorkbookDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSSFWorkbook
extends POIXMLDocument
implements Workbook,
Iterable<XSSFSheet> {
    private static final Pattern COMMA_PATTERN = Pattern.compile(",");
    public static final float DEFAULT_CHARACTER_WIDTH = 7.0017f;
    private CTWorkbook workbook;
    private List<XSSFSheet> sheets;
    private List<XSSFName> namedRanges;
    private SharedStringsTable sharedStringSource;
    private StylesTable stylesSource;
    private CalculationChain calcChain;
    private MapInfo mapInfo;
    private XSSFDataFormat formatter;
    private Row.MissingCellPolicy _missingCellPolicy = Row.RETURN_NULL_AND_BLANK;
    private List<XSSFPictureData> pictures;
    private static POILogger logger = POILogFactory.getLogger(XSSFWorkbook.class);
    private XSSFCreationHelper _creationHelper;

    public XSSFWorkbook() {
        super(XSSFWorkbook.newPackage());
        this.onWorkbookCreate();
    }

    public XSSFWorkbook(OPCPackage pkg) throws IOException {
        super(XSSFWorkbook.ensureWriteAccess(pkg));
        this.load(XSSFFactory.getInstance());
    }

    public XSSFWorkbook(InputStream is) throws IOException {
        super(PackageHelper.open(is));
        this.load(XSSFFactory.getInstance());
    }

    public XSSFWorkbook(String path) throws IOException {
        this(XSSFWorkbook.openPackage(path));
    }

    @Override
    protected void onDocumentRead() throws IOException {
        try {
            WorkbookDocument doc = WorkbookDocument.Factory.parse((InputStream)this.getPackagePart().getInputStream());
            this.workbook = doc.getWorkbook();
            HashMap<String, XSSFSheet> shIdMap = new HashMap<String, XSSFSheet>();
            for (POIXMLDocumentPart p : this.getRelations()) {
                if (p instanceof SharedStringsTable) {
                    this.sharedStringSource = (SharedStringsTable)p;
                    continue;
                }
                if (p instanceof StylesTable) {
                    this.stylesSource = (StylesTable)p;
                    continue;
                }
                if (p instanceof CalculationChain) {
                    this.calcChain = (CalculationChain)p;
                    continue;
                }
                if (p instanceof MapInfo) {
                    this.mapInfo = (MapInfo)p;
                    continue;
                }
                if (!(p instanceof XSSFSheet)) continue;
                shIdMap.put(p.getPackageRelationship().getId(), (XSSFSheet)p);
            }
            if (this.sharedStringSource == null) {
                this.sharedStringSource = (SharedStringsTable)this.createRelationship(XSSFRelation.SHARED_STRINGS, XSSFFactory.getInstance());
            }
            this.sheets = new ArrayList<XSSFSheet>(shIdMap.size());
            for (CTSheet cTSheet : this.workbook.getSheets().getSheetArray()) {
                XSSFSheet sh = (XSSFSheet)shIdMap.get(cTSheet.getId());
                if (sh == null) {
                    logger.log(POILogger.WARN, (Object)("Sheet with name " + cTSheet.getName() + " and r:id " + cTSheet.getId() + " was defined, but didn't exist in package, skipping"));
                    continue;
                }
                sh.sheet = cTSheet;
                sh.onDocumentRead();
                this.sheets.add(sh);
            }
            this.namedRanges = new ArrayList<XSSFName>();
            if (this.workbook.isSetDefinedNames()) {
                for (CTSheet cTSheet : this.workbook.getDefinedNames().getDefinedNameArray()) {
                    this.namedRanges.add(new XSSFName((CTDefinedName)cTSheet, this));
                }
            }
        }
        catch (XmlException e) {
            throw new POIXMLException(e);
        }
    }

    private void onWorkbookCreate() {
        this.workbook = CTWorkbook.Factory.newInstance();
        CTWorkbookPr workbookPr = this.workbook.addNewWorkbookPr();
        workbookPr.setDate1904(false);
        CTBookViews bvs = this.workbook.addNewBookViews();
        CTBookView bv = bvs.addNewWorkbookView();
        bv.setActiveTab(0L);
        this.workbook.addNewSheets();
        POIXMLProperties.ExtendedProperties expProps = this.getProperties().getExtendedProperties();
        expProps.getUnderlyingProperties().setApplication("Apache POI");
        this.sharedStringSource = (SharedStringsTable)this.createRelationship(XSSFRelation.SHARED_STRINGS, XSSFFactory.getInstance());
        this.stylesSource = (StylesTable)this.createRelationship(XSSFRelation.STYLES, XSSFFactory.getInstance());
        this.namedRanges = new ArrayList<XSSFName>();
        this.sheets = new ArrayList<XSSFSheet>();
    }

    protected static OPCPackage newPackage() {
        try {
            OPCPackage pkg = OPCPackage.create(PackageHelper.createTempFile());
            PackagePartName corePartName = PackagingURIHelper.createPartName(XSSFRelation.WORKBOOK.getDefaultFileName());
            pkg.addRelationship(corePartName, TargetMode.INTERNAL, "http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument");
            pkg.createPart(corePartName, XSSFRelation.WORKBOOK.getContentType());
            pkg.getPackageProperties().setCreatorProperty("Apache POI");
            return pkg;
        }
        catch (Exception e) {
            throw new POIXMLException(e);
        }
    }

    public CTWorkbook getCTWorkbook() {
        return this.workbook;
    }

    public int addPicture(byte[] pictureData, int format) {
        int imageNumber = this.getAllPictures().size() + 1;
        XSSFPictureData img = (XSSFPictureData)this.createRelationship(XSSFPictureData.RELATIONS[format], XSSFFactory.getInstance(), imageNumber, true);
        try {
            OutputStream out = img.getPackagePart().getOutputStream();
            out.write(pictureData);
            out.close();
        }
        catch (IOException e) {
            throw new POIXMLException(e);
        }
        this.pictures.add(img);
        return imageNumber - 1;
    }

    public int addPicture(InputStream is, int format) throws IOException {
        int imageNumber = this.getAllPictures().size() + 1;
        XSSFPictureData img = (XSSFPictureData)this.createRelationship(XSSFPictureData.RELATIONS[format], XSSFFactory.getInstance(), imageNumber, true);
        OutputStream out = img.getPackagePart().getOutputStream();
        IOUtils.copy((InputStream)is, (OutputStream)out);
        out.close();
        this.pictures.add(img);
        return imageNumber - 1;
    }

    public XSSFSheet cloneSheet(int sheetNum) {
        this.validateSheetIndex(sheetNum);
        XSSFSheet srcSheet = this.sheets.get(sheetNum);
        String srcName = srcSheet.getSheetName();
        String clonedName = this.getUniqueSheetName(srcName);
        XSSFSheet clonedSheet = this.createSheet(clonedName);
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            srcSheet.write(out);
            clonedSheet.read(new ByteArrayInputStream(out.toByteArray()));
        }
        catch (IOException e) {
            throw new POIXMLException("Failed to clone sheet", e);
        }
        CTWorksheet ct = clonedSheet.getCTWorksheet();
        if (ct.isSetDrawing()) {
            logger.log(POILogger.WARN, (Object)"Cloning sheets with drawings is not yet supported.");
            ct.unsetDrawing();
        }
        if (ct.isSetLegacyDrawing()) {
            logger.log(POILogger.WARN, (Object)"Cloning sheets with comments is not yet supported.");
            ct.unsetLegacyDrawing();
        }
        clonedSheet.setSelected(false);
        return clonedSheet;
    }

    private String getUniqueSheetName(String srcName) {
        String index;
        String name;
        int uniqueIndex = 2;
        String baseName = srcName;
        int bracketPos = srcName.lastIndexOf(40);
        if (bracketPos > 0 && srcName.endsWith(")")) {
            String suffix = srcName.substring(bracketPos + 1, srcName.length() - ")".length());
            try {
                uniqueIndex = Integer.parseInt(suffix.trim());
                baseName = srcName.substring(0, bracketPos).trim();
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        do {
            int n = ++uniqueIndex;
            ++uniqueIndex;
            index = Integer.toString(n);
        } while (this.getSheetIndex(name = baseName.length() + index.length() + 2 < 31 ? baseName + " (" + index + ")" : baseName.substring(0, 31 - index.length() - 2) + "(" + index + ")") != -1);
        return name;
    }

    public XSSFCellStyle createCellStyle() {
        return this.stylesSource.createCellStyle();
    }

    public XSSFDataFormat createDataFormat() {
        if (this.formatter == null) {
            this.formatter = new XSSFDataFormat(this.stylesSource);
        }
        return this.formatter;
    }

    public XSSFFont createFont() {
        XSSFFont font = new XSSFFont();
        font.putFont(this.stylesSource);
        return font;
    }

    public XSSFName createName() {
        XSSFName name = new XSSFName(CTDefinedName.Factory.newInstance(), this);
        this.namedRanges.add(name);
        return name;
    }

    public XSSFSheet createSheet() {
        String sheetname = "Sheet" + this.sheets.size();
        int idx = 0;
        while (this.getSheet(sheetname) != null) {
            sheetname = "Sheet" + idx;
            ++idx;
        }
        return this.createSheet(sheetname);
    }

    public XSSFSheet createSheet(String sheetname) {
        if (this.containsSheet(sheetname, this.sheets.size())) {
            throw new IllegalArgumentException("The workbook already contains a sheet of this name");
        }
        CTSheet sheet = this.addSheet(sheetname);
        int sheetNumber = 1;
        for (XSSFSheet sh : this.sheets) {
            sheetNumber = (int)Math.max(sh.sheet.getSheetId() + 1L, (long)sheetNumber);
        }
        XSSFSheet wrapper = (XSSFSheet)this.createRelationship(XSSFRelation.WORKSHEET, XSSFFactory.getInstance(), sheetNumber);
        wrapper.sheet = sheet;
        sheet.setId(wrapper.getPackageRelationship().getId());
        sheet.setSheetId((long)sheetNumber);
        if (this.sheets.size() == 0) {
            wrapper.setSelected(true);
        }
        this.sheets.add(wrapper);
        return wrapper;
    }

    protected XSSFDialogsheet createDialogsheet(String sheetname, CTDialogsheet dialogsheet) {
        XSSFSheet sheet = this.createSheet(sheetname);
        return new XSSFDialogsheet(sheet);
    }

    private CTSheet addSheet(String sheetname) {
        XSSFWorkbook.validateSheetName(sheetname);
        CTSheet sheet = this.workbook.getSheets().addNewSheet();
        sheet.setName(sheetname);
        return sheet;
    }

    public XSSFFont findFont(short boldWeight, short color, short fontHeight, String name, boolean italic, boolean strikeout, short typeOffset, byte underline) {
        return this.stylesSource.findFont(boldWeight, color, fontHeight, name, italic, strikeout, typeOffset, underline);
    }

    public int getActiveSheetIndex() {
        return (int)this.workbook.getBookViews().getWorkbookViewArray(0).getActiveTab();
    }

    public List<XSSFPictureData> getAllPictures() {
        if (this.pictures == null) {
            this.pictures = new ArrayList<XSSFPictureData>();
            for (XSSFSheet sh : this.sheets) {
                for (POIXMLDocumentPart dr : sh.getRelations()) {
                    if (!(dr instanceof XSSFDrawing)) continue;
                    for (POIXMLDocumentPart img : dr.getRelations()) {
                        if (!(img instanceof XSSFPictureData)) continue;
                        this.pictures.add((XSSFPictureData)img);
                    }
                }
            }
        }
        return this.pictures;
    }

    public XSSFCellStyle getCellStyleAt(short idx) {
        return this.stylesSource.getStyleAt(idx);
    }

    public XSSFFont getFontAt(short idx) {
        return this.stylesSource.getFontAt(idx);
    }

    public XSSFName getName(String name) {
        int nameIndex = this.getNameIndex(name);
        if (nameIndex < 0) {
            return null;
        }
        return this.namedRanges.get(nameIndex);
    }

    public XSSFName getNameAt(int nameIndex) {
        int nNames = this.namedRanges.size();
        if (nNames < 1) {
            throw new IllegalStateException("There are no defined names in this workbook");
        }
        if (nameIndex < 0 || nameIndex > nNames) {
            throw new IllegalArgumentException("Specified name index " + nameIndex + " is outside the allowable range (0.." + (nNames - 1) + ").");
        }
        return this.namedRanges.get(nameIndex);
    }

    public int getNameIndex(String name) {
        int i = 0;
        for (XSSFName nr : this.namedRanges) {
            if (nr.getNameName().equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public short getNumCellStyles() {
        return (short)this.stylesSource.getNumCellStyles();
    }

    public short getNumberOfFonts() {
        return (short)this.stylesSource.getFonts().size();
    }

    public int getNumberOfNames() {
        return this.namedRanges.size();
    }

    public int getNumberOfSheets() {
        return this.sheets.size();
    }

    public String getPrintArea(int sheetIndex) {
        XSSFName name = this.getBuiltInName("_xlnm.Print_Area", sheetIndex);
        if (name == null) {
            return null;
        }
        return name.getRefersToFormula();
    }

    public XSSFSheet getSheet(String name) {
        for (XSSFSheet sheet : this.sheets) {
            if (!name.equalsIgnoreCase(sheet.getSheetName())) continue;
            return sheet;
        }
        return null;
    }

    public XSSFSheet getSheetAt(int index) {
        this.validateSheetIndex(index);
        return this.sheets.get(index);
    }

    public int getSheetIndex(String name) {
        for (int i = 0; i < this.sheets.size(); ++i) {
            XSSFSheet sheet = this.sheets.get(i);
            if (!name.equalsIgnoreCase(sheet.getSheetName())) continue;
            return i;
        }
        return -1;
    }

    public int getSheetIndex(Sheet sheet) {
        int idx = 0;
        for (XSSFSheet sh : this.sheets) {
            if (sh == sheet) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    public String getSheetName(int sheetIx) {
        this.validateSheetIndex(sheetIx);
        return this.sheets.get(sheetIx).getSheetName();
    }

    @Override
    public Iterator<XSSFSheet> iterator() {
        return this.sheets.iterator();
    }

    public boolean isMacroEnabled() {
        return this.getPackagePart().getContentType().equals(XSSFRelation.MACROS_WORKBOOK.getContentType());
    }

    public void removeName(int nameIndex) {
        this.namedRanges.remove(nameIndex);
    }

    public void removeName(String name) {
        for (int i = 0; i < this.namedRanges.size(); ++i) {
            XSSFName nm = this.namedRanges.get(i);
            if (!nm.getNameName().equalsIgnoreCase(name)) continue;
            this.removeName(i);
            return;
        }
        throw new IllegalArgumentException("Named range was not found: " + name);
    }

    public void removePrintArea(int sheetIndex) {
        int cont = 0;
        for (XSSFName name : this.namedRanges) {
            if (name.getNameName().equals("_xlnm.Print_Area") && name.getSheetIndex() == sheetIndex) {
                this.namedRanges.remove(cont);
                break;
            }
            ++cont;
        }
    }

    public void removeSheetAt(int index) {
        this.validateSheetIndex(index);
        this.onSheetDelete(index);
        XSSFSheet sheet = this.getSheetAt(index);
        this.removeRelation(sheet);
        this.sheets.remove(index);
    }

    private void onSheetDelete(int index) {
        this.workbook.getSheets().removeSheet(index);
        if (this.calcChain != null) {
            this.removeRelation(this.calcChain);
            this.calcChain = null;
        }
        Iterator<XSSFName> it = this.namedRanges.iterator();
        while (it.hasNext()) {
            XSSFName nm = it.next();
            CTDefinedName ct = nm.getCTName();
            if (!ct.isSetLocalSheetId()) continue;
            if (ct.getLocalSheetId() == (long)index) {
                it.remove();
                continue;
            }
            if (ct.getLocalSheetId() <= (long)index) continue;
            ct.setLocalSheetId(ct.getLocalSheetId() - 1L);
        }
    }

    public Row.MissingCellPolicy getMissingCellPolicy() {
        return this._missingCellPolicy;
    }

    public void setMissingCellPolicy(Row.MissingCellPolicy missingCellPolicy) {
        this._missingCellPolicy = missingCellPolicy;
    }

    public void setActiveSheet(int index) {
        this.validateSheetIndex(index);
        CTBookView[] arrayBook = this.workbook.getBookViews().getWorkbookViewArray();
        for (int i = 0; i < arrayBook.length; ++i) {
            this.workbook.getBookViews().getWorkbookViewArray(i).setActiveTab((long)index);
        }
    }

    private void validateSheetIndex(int index) {
        int lastSheetIx = this.sheets.size() - 1;
        if (index < 0 || index > lastSheetIx) {
            throw new IllegalArgumentException("Sheet index (" + index + ") is out of range (0.." + lastSheetIx + ")");
        }
    }

    public int getFirstVisibleTab() {
        CTBookViews bookViews = this.workbook.getBookViews();
        CTBookView bookView = bookViews.getWorkbookViewArray(0);
        return (short)bookView.getActiveTab();
    }

    public void setFirstVisibleTab(int index) {
        CTBookViews bookViews = this.workbook.getBookViews();
        CTBookView bookView = bookViews.getWorkbookViewArray(0);
        bookView.setActiveTab((long)index);
    }

    public void setPrintArea(int sheetIndex, String reference) {
        XSSFName name = this.getBuiltInName("_xlnm.Print_Area", sheetIndex);
        if (name == null) {
            name = this.createBuiltInName("_xlnm.Print_Area", sheetIndex);
            this.namedRanges.add(name);
        }
        String[] parts = COMMA_PATTERN.split(reference);
        StringBuffer sb = new StringBuffer(32);
        for (int i = 0; i < parts.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            SheetNameFormatter.appendFormat((StringBuffer)sb, (String)this.getSheetName(sheetIndex));
            sb.append("!");
            sb.append(parts[i]);
        }
        name.setRefersToFormula(sb.toString());
    }

    public void setPrintArea(int sheetIndex, int startColumn, int endColumn, int startRow, int endRow) {
        String reference = XSSFWorkbook.getReferencePrintArea(this.getSheetName(sheetIndex), startColumn, endColumn, startRow, endRow);
        this.setPrintArea(sheetIndex, reference);
    }

    public void setRepeatingRowsAndColumns(int sheetIndex, int startColumn, int endColumn, int startRow, int endRow) {
        if (startColumn == -1 && endColumn != -1 || startColumn < -1 || endColumn < -1 || startColumn > endColumn) {
            throw new IllegalArgumentException("Invalid column range specification");
        }
        if (startRow == -1 && endRow != -1 || startRow < -1 || endRow < -1 || startRow > endRow) {
            throw new IllegalArgumentException("Invalid row range specification");
        }
        XSSFSheet sheet = this.getSheetAt(sheetIndex);
        boolean removingRange = startColumn == -1 && endColumn == -1 && startRow == -1 && endRow == -1;
        XSSFName name = this.getBuiltInName("_xlnm.Print_Titles", sheetIndex);
        if (removingRange) {
            if (name != null) {
                this.namedRanges.remove(name);
            }
            return;
        }
        if (name == null) {
            name = this.createBuiltInName("_xlnm.Print_Titles", sheetIndex);
            this.namedRanges.add(name);
        }
        String reference = XSSFWorkbook.getReferenceBuiltInRecord(name.getSheetName(), startColumn, endColumn, startRow, endRow);
        name.setRefersToFormula(reference);
        XSSFPrintSetup printSetup = sheet.getPrintSetup();
        printSetup.setValidSettings(false);
    }

    private static String getReferenceBuiltInRecord(String sheetName, int startC, int endC, int startR, int endR) {
        CellReference colRef = new CellReference(sheetName, 0, startC, true, true);
        CellReference colRef2 = new CellReference(sheetName, 0, endC, true, true);
        String escapedName = SheetNameFormatter.format((String)sheetName);
        String c = startC == -1 && endC == -1 ? "" : escapedName + "!$" + colRef.getCellRefParts()[2] + ":$" + colRef2.getCellRefParts()[2];
        CellReference rowRef = new CellReference(sheetName, startR, 0, true, true);
        CellReference rowRef2 = new CellReference(sheetName, endR, 0, true, true);
        String r = "";
        if (startR == -1 && endR == -1) {
            r = "";
        } else if (!rowRef.getCellRefParts()[1].equals("0") && !rowRef2.getCellRefParts()[1].equals("0")) {
            r = escapedName + "!$" + rowRef.getCellRefParts()[1] + ":$" + rowRef2.getCellRefParts()[1];
        }
        StringBuffer rng = new StringBuffer();
        rng.append(c);
        if (rng.length() > 0 && r.length() > 0) {
            rng.append(',');
        }
        rng.append(r);
        return rng.toString();
    }

    private static String getReferencePrintArea(String sheetName, int startC, int endC, int startR, int endR) {
        CellReference colRef = new CellReference(sheetName, startR, startC, true, true);
        CellReference colRef2 = new CellReference(sheetName, endR, endC, true, true);
        return "$" + colRef.getCellRefParts()[2] + "$" + colRef.getCellRefParts()[1] + ":$" + colRef2.getCellRefParts()[2] + "$" + colRef2.getCellRefParts()[1];
    }

    private XSSFName getBuiltInName(String builtInCode, int sheetNumber) {
        for (XSSFName name : this.namedRanges) {
            if (!name.getNameName().equalsIgnoreCase(builtInCode) || name.getSheetIndex() != sheetNumber) continue;
            return name;
        }
        return null;
    }

    private XSSFName createBuiltInName(String builtInName, int sheetNumber) {
        this.validateSheetIndex(sheetNumber);
        CTDefinedNames names = this.workbook.getDefinedNames() == null ? this.workbook.addNewDefinedNames() : this.workbook.getDefinedNames();
        CTDefinedName nameRecord = names.addNewDefinedName();
        nameRecord.setName(builtInName);
        nameRecord.setLocalSheetId((long)sheetNumber);
        XSSFName name = new XSSFName(nameRecord, this);
        for (XSSFName nr : this.namedRanges) {
            if (!nr.equals(name)) continue;
            throw new POIXMLException("Builtin (" + builtInName + ") already exists for sheet (" + sheetNumber + ")");
        }
        return name;
    }

    public void setSelectedTab(int index) {
        for (int i = 0; i < this.sheets.size(); ++i) {
            XSSFSheet sheet = this.sheets.get(i);
            sheet.setSelected(i == index);
        }
    }

    public void setSheetName(int sheet, String name) {
        this.validateSheetIndex(sheet);
        XSSFWorkbook.validateSheetName(name);
        if (this.containsSheet(name, sheet)) {
            throw new IllegalArgumentException("The workbook already contains a sheet of this name");
        }
        this.workbook.getSheets().getSheetArray(sheet).setName(name);
    }

    public void setSheetOrder(String sheetname, int pos) {
        int idx = this.getSheetIndex(sheetname);
        this.sheets.add(pos, this.sheets.remove(idx));
        CTSheets ct = this.workbook.getSheets();
        XmlObject cts = ct.getSheetArray(idx).copy();
        this.workbook.getSheets().removeSheet(idx);
        CTSheet newcts = ct.insertNewSheet(pos);
        newcts.set(cts);
        for (int i = 0; i < this.sheets.size(); ++i) {
            this.sheets.get((int)i).sheet = ct.getSheetArray(i);
        }
    }

    private void saveNamedRanges() {
        if (this.namedRanges.size() > 0) {
            CTDefinedNames names = CTDefinedNames.Factory.newInstance();
            CTDefinedName[] nr = new CTDefinedName[this.namedRanges.size()];
            int i = 0;
            for (XSSFName name : this.namedRanges) {
                nr[i] = name.getCTName();
                ++i;
            }
            names.setDefinedNameArray(nr);
            this.workbook.setDefinedNames(names);
        } else if (this.workbook.isSetDefinedNames()) {
            this.workbook.unsetDefinedNames();
        }
    }

    private void saveCalculationChain() {
        int count;
        if (this.calcChain != null && (count = this.calcChain.getCTCalcChain().getCArray().length) == 0) {
            this.removeRelation(this.calcChain);
            this.calcChain = null;
        }
    }

    @Override
    protected void commit() throws IOException {
        this.saveNamedRanges();
        this.saveCalculationChain();
        XmlOptions xmlOptions = new XmlOptions(DEFAULT_XML_OPTIONS);
        xmlOptions.setSaveSyntheticDocumentElement(new QName(CTWorkbook.type.getName().getNamespaceURI(), "workbook"));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(STRelationshipId.type.getName().getNamespaceURI(), "r");
        xmlOptions.setSaveSuggestedPrefixes(map);
        PackagePart part = this.getPackagePart();
        OutputStream out = part.getOutputStream();
        this.workbook.save(out, xmlOptions);
        out.close();
    }

    public SharedStringsTable getSharedStringSource() {
        return this.sharedStringSource;
    }

    public StylesTable getStylesSource() {
        return this.stylesSource;
    }

    public XSSFCreationHelper getCreationHelper() {
        if (this._creationHelper == null) {
            this._creationHelper = new XSSFCreationHelper(this);
        }
        return this._creationHelper;
    }

    private boolean containsSheet(String name, int excludeSheetIdx) {
        CTSheet[] ctSheetArray = this.workbook.getSheets().getSheetArray();
        for (int i = 0; i < ctSheetArray.length; ++i) {
            if (excludeSheetIdx == i || !name.equalsIgnoreCase(ctSheetArray[i].getName())) continue;
            return true;
        }
        return false;
    }

    private static void validateSheetName(String sheetName) {
        if (sheetName == null) {
            throw new IllegalArgumentException("sheetName must not be null");
        }
        int len = sheetName.length();
        if (len < 1 || len > 31) {
            throw new IllegalArgumentException("sheetName '" + sheetName + "' is invalid - must be 1-30 characters long");
        }
        block3: for (int i = 0; i < len; ++i) {
            char ch = sheetName.charAt(i);
            switch (ch) {
                case '*': 
                case '/': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': {
                    break;
                }
                default: {
                    continue block3;
                }
            }
            throw new IllegalArgumentException("Invalid char (" + ch + ") found at index (" + i + ") in sheet name '" + sheetName + "'");
        }
    }

    protected boolean isDate1904() {
        CTWorkbookPr workbookPr = this.workbook.getWorkbookPr();
        return workbookPr != null && workbookPr.getDate1904();
    }

    @Override
    public List<PackagePart> getAllEmbedds() throws OpenXML4JException {
        LinkedList<PackagePart> embedds = new LinkedList<PackagePart>();
        for (XSSFSheet sheet : this.sheets) {
            for (PackageRelationship rel : sheet.getPackagePart().getRelationshipsByType(XSSFRelation.OLEEMBEDDINGS.getRelation())) {
                embedds.add(this.getTargetPart(rel));
            }
            for (PackageRelationship rel : sheet.getPackagePart().getRelationshipsByType(XSSFRelation.PACKEMBEDDINGS.getRelation())) {
                embedds.add(this.getTargetPart(rel));
            }
        }
        return embedds;
    }

    public boolean isHidden() {
        throw new RuntimeException("Not implemented yet");
    }

    public void setHidden(boolean hiddenFlag) {
        throw new RuntimeException("Not implemented yet");
    }

    public boolean isSheetHidden(int sheetIx) {
        this.validateSheetIndex(sheetIx);
        CTSheet ctSheet = this.sheets.get((int)sheetIx).sheet;
        return ctSheet.getState() == STSheetState.HIDDEN;
    }

    public boolean isSheetVeryHidden(int sheetIx) {
        this.validateSheetIndex(sheetIx);
        CTSheet ctSheet = this.sheets.get((int)sheetIx).sheet;
        return ctSheet.getState() == STSheetState.VERY_HIDDEN;
    }

    public void setSheetHidden(int sheetIx, boolean hidden) {
        this.validateSheetIndex(sheetIx);
        CTSheet ctSheet = this.sheets.get((int)sheetIx).sheet;
        ctSheet.setState(hidden ? STSheetState.HIDDEN : STSheetState.VISIBLE);
    }

    public void setSheetHidden(int sheetIx, int hidden) {
        this.validateSheetIndex(sheetIx);
        CTSheet ctSheet = this.sheets.get((int)sheetIx).sheet;
        ctSheet.setState(STSheetState.Enum.forInt((int)hidden));
    }

    protected void onDeleteFormula(XSSFCell cell) {
        if (this.calcChain != null) {
            int sheetId = (int)cell.getSheet().sheet.getSheetId();
            this.calcChain.removeItem(sheetId, cell.getReference());
        }
    }

    public CalculationChain getCalculationChain() {
        return this.calcChain;
    }

    public Collection<XSSFMap> getCustomXMLMappings() {
        return this.mapInfo == null ? new ArrayList() : this.mapInfo.getAllXSSFMaps();
    }

    public MapInfo getMapInfo() {
        return this.mapInfo;
    }

    public boolean isStructureLocked() {
        return this.workbookProtectionPresent() && this.workbook.getWorkbookProtection().getLockStructure();
    }

    public boolean isWindowsLocked() {
        return this.workbookProtectionPresent() && this.workbook.getWorkbookProtection().getLockWindows();
    }

    public boolean isRevisionLocked() {
        return this.workbookProtectionPresent() && this.workbook.getWorkbookProtection().getLockRevision();
    }

    public void lockStructure() {
        this.createProtectionFieldIfNotPresent();
        this.workbook.getWorkbookProtection().setLockStructure(true);
    }

    public void unLockStructure() {
        this.createProtectionFieldIfNotPresent();
        this.workbook.getWorkbookProtection().setLockStructure(false);
    }

    public void lockWindows() {
        this.createProtectionFieldIfNotPresent();
        this.workbook.getWorkbookProtection().setLockWindows(true);
    }

    public void unLockWindows() {
        this.createProtectionFieldIfNotPresent();
        this.workbook.getWorkbookProtection().setLockWindows(false);
    }

    public void lockRevision() {
        this.createProtectionFieldIfNotPresent();
        this.workbook.getWorkbookProtection().setLockRevision(true);
    }

    public void unLockRevision() {
        this.createProtectionFieldIfNotPresent();
        this.workbook.getWorkbookProtection().setLockRevision(false);
    }

    private boolean workbookProtectionPresent() {
        return this.workbook.getWorkbookProtection() != null;
    }

    private void createProtectionFieldIfNotPresent() {
        if (this.workbook.getWorkbookProtection() == null) {
            this.workbook.setWorkbookProtection(CTWorkbookProtection.Factory.newInstance());
        }
    }
}

