/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.util;

import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.util.DiffHtmlUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.InstancePool;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.ContentUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.wiki.PageContentException;
import com.liferay.portlet.wiki.WikiFormatException;
import com.liferay.portlet.wiki.engines.WikiEngine;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.service.WikiNodeLocalServiceUtil;
import com.liferay.portlet.wiki.service.permission.WikiNodePermission;
import com.liferay.portlet.wiki.util.comparator.PageCreateDateComparator;
import com.liferay.portlet.wiki.util.comparator.PageTitleComparator;
import com.liferay.portlet.wiki.util.comparator.PageVersionComparator;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikiUtil {
    public static final String POP_PORTLET_PREFIX = "wiki.";
    private static final String[] _JSP_WIKI_NAME_1 = new String[]{"'", "@", "^", "!", "\u00a1", "\u00bf", "`", "?", "/", "*"};
    private static final String[] _JSP_WIKI_NAME_2 = new String[]{"__APO__", "__AT__", "__CAR__", "__EXM__", "__INE__", "__INQ__", "__GRA__", "__QUE__", "__SLA__", "__STA__"};
    private static WikiUtil _instance = new WikiUtil();
    private static Pattern _editPageURLPattern = Pattern.compile("\\[\\$BEGIN_PAGE_TITLE_EDIT\\$\\](.*?)\\[\\$END_PAGE_TITLE_EDIT\\$\\]");
    private static Pattern _viewPageURLPattern = Pattern.compile("\\[\\$BEGIN_PAGE_TITLE\\$\\](.*?)\\[\\$END_PAGE_TITLE\\$\\]");
    private static Pattern _wikiLinkPattern = Pattern.compile("[\\[]{2,2}(.+?)[\\]]{2,2}");
    private Map<String, WikiEngine> _engines = new HashMap<String, WikiEngine>();

    public static String convert(WikiPage page, PortletURL viewPageURL, PortletURL editPageURL, String attachmentURLPrefix) throws PageContentException, WikiFormatException {
        return _instance._convert(page, viewPageURL, editPageURL, attachmentURLPrefix);
    }

    public static String decodeJSPWikiName(String jspWikiName) {
        return StringUtil.replace((String)jspWikiName, (String[])_JSP_WIKI_NAME_2, (String[])_JSP_WIKI_NAME_1);
    }

    public static String diffHtml(WikiPage sourcePage, WikiPage targetPage, PortletURL viewPageURL, PortletURL editPageURL, String attachmentURLPrefix) throws Exception {
        String sourceContent = "";
        String targetContent = "";
        if (sourcePage != null) {
            sourceContent = WikiUtil.convert(sourcePage, viewPageURL, editPageURL, attachmentURLPrefix);
        }
        if (targetPage != null) {
            targetContent = WikiUtil.convert(targetPage, viewPageURL, editPageURL, attachmentURLPrefix);
        }
        return DiffHtmlUtil.diff((Reader)new UnsyncStringReader(sourceContent), (Reader)new UnsyncStringReader(targetContent));
    }

    public static String encodeJSPWikiContent(String content) {
        String newContent = content;
        Matcher matcher = _wikiLinkPattern.matcher(content);
        while (matcher.find()) {
            String link = matcher.group();
            String linkValues = matcher.group(1);
            int index = linkValues.indexOf(124);
            String name = linkValues;
            String url = linkValues;
            if (index != -1) {
                name = linkValues.substring(index + 1, linkValues.length());
                url = linkValues.substring(0, index);
            }
            String newLink = "[[" + WikiUtil.encodeJSPWikiName(url) + "|" + name + "]]";
            newContent = StringUtil.replace((String)newContent, (String)link, (String)newLink);
        }
        return newContent;
    }

    public static String encodeJSPWikiName(String name) {
        if (name == null) {
            return "";
        }
        return StringUtil.replace((String)name, (String[])_JSP_WIKI_NAME_1, (String[])_JSP_WIKI_NAME_2);
    }

    public static String getEditPage(String format) {
        return _instance._getEditPage(format);
    }

    public static String getEmailFromAddress(PortletPreferences preferences) {
        String emailFromAddress = PropsUtil.get("wiki.email.from.address");
        return preferences.getValue("email-from-address", emailFromAddress);
    }

    public static String getEmailFromName(PortletPreferences preferences) {
        String emailFromName = PropsUtil.get("wiki.email.from.name");
        return preferences.getValue("email-from-name", emailFromName);
    }

    public static boolean getEmailPageAddedEnabled(PortletPreferences preferences) {
        String emailPageAddedEnabled = preferences.getValue("email-page-added-enabled", "");
        if (Validator.isNotNull((String)emailPageAddedEnabled)) {
            return GetterUtil.getBoolean((String)emailPageAddedEnabled);
        }
        return GetterUtil.getBoolean((String)PropsUtil.get("wiki.email.page.added.enabled"));
    }

    public static String getEmailPageAddedBody(PortletPreferences preferences) {
        String emailPageAddedBody = preferences.getValue("email-page-added-body", "");
        if (Validator.isNotNull((String)emailPageAddedBody)) {
            return emailPageAddedBody;
        }
        return ContentUtil.get(PropsUtil.get("wiki.email.page.added.body"));
    }

    public static String getEmailPageAddedSignature(PortletPreferences preferences) {
        String emailPageAddedSignature = preferences.getValue("email-page-added-signature", "");
        if (Validator.isNotNull((String)emailPageAddedSignature)) {
            return emailPageAddedSignature;
        }
        return ContentUtil.get(PropsUtil.get("wiki.email.page.added.signature"));
    }

    public static String getEmailPageAddedSubjectPrefix(PortletPreferences preferences) {
        String emailPageAddedSubjectPrefix = preferences.getValue("email-page-added-subject-prefix", "");
        if (Validator.isNotNull((String)emailPageAddedSubjectPrefix)) {
            return emailPageAddedSubjectPrefix;
        }
        return ContentUtil.get(PropsUtil.get("wiki.email.page.added.subject.prefix"));
    }

    public static boolean getEmailPageUpdatedEnabled(PortletPreferences preferences) {
        String emailPageUpdatedEnabled = preferences.getValue("email-page-updated-enabled", "");
        if (Validator.isNotNull((String)emailPageUpdatedEnabled)) {
            return GetterUtil.getBoolean((String)emailPageUpdatedEnabled);
        }
        return GetterUtil.getBoolean((String)PropsUtil.get("wiki.email.page.updated.enabled"));
    }

    public static String getEmailPageUpdatedBody(PortletPreferences preferences) {
        String emailPageUpdatedBody = preferences.getValue("email-page-updated-body", "");
        if (Validator.isNotNull((String)emailPageUpdatedBody)) {
            return emailPageUpdatedBody;
        }
        return ContentUtil.get(PropsUtil.get("wiki.email.page.updated.body"));
    }

    public static String getEmailPageUpdatedSignature(PortletPreferences preferences) {
        String emailPageUpdatedSignature = preferences.getValue("email-page-updated-signature", "");
        if (Validator.isNotNull((String)emailPageUpdatedSignature)) {
            return emailPageUpdatedSignature;
        }
        return ContentUtil.get(PropsUtil.get("wiki.email.page.updated.signature"));
    }

    public static String getEmailPageUpdatedSubjectPrefix(PortletPreferences preferences) {
        String emailPageUpdatedSubject = preferences.getValue("email-page-updated-subject-prefix", "");
        if (Validator.isNotNull((String)emailPageUpdatedSubject)) {
            return emailPageUpdatedSubject;
        }
        return ContentUtil.get(PropsUtil.get("wiki.email.page.updated.subject.prefix"));
    }

    public static WikiNode getFirstNode(PortletRequest portletRequest) throws PortalException, SystemException {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("THEME_DISPLAY");
        long groupId = themeDisplay.getScopeGroupId();
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        List<WikiNode> nodes = WikiNodeLocalServiceUtil.getNodes((long)groupId);
        PortletPreferences preferences = portletRequest.getPreferences();
        String[] visibleNodeNames = StringUtil.split((String)preferences.getValue("visible-nodes", null));
        nodes = WikiUtil.orderNodes(nodes, visibleNodeNames);
        Object[] hiddenNodes = StringUtil.split((String)preferences.getValue("hidden-nodes", ""));
        Arrays.sort(hiddenNodes);
        for (WikiNode node : nodes) {
            if (Arrays.binarySearch(hiddenNodes, node.getName()) >= 0 || !WikiNodePermission.contains(permissionChecker, node, "VIEW")) continue;
            return node;
        }
        return null;
    }

    public static String getHelpPage(String format) {
        return _instance._getHelpPage(format);
    }

    public static String getHelpURL(String format) {
        return _instance._getHelpURL(format);
    }

    public static Map<String, Boolean> getLinks(WikiPage page) throws PageContentException {
        return _instance._getLinks(page);
    }

    public static String getMailId(String mx, long nodeId, long pageId) {
        StringBundler sb = new StringBundler(10);
        sb.append("<");
        sb.append(POP_PORTLET_PREFIX);
        sb.append(nodeId);
        sb.append(".");
        sb.append(pageId);
        sb.append("@");
        sb.append(PropsValues.POP_SERVER_SUBDOMAIN);
        sb.append(".");
        sb.append(mx);
        sb.append(">");
        return sb.toString();
    }

    public static List<String> getNodeNames(List<WikiNode> nodes) {
        ArrayList<String> nodeNames = new ArrayList<String>(nodes.size());
        for (WikiNode node : nodes) {
            nodeNames.add(node.getName());
        }
        return nodeNames;
    }

    public static List<WikiNode> getNodes(List<WikiNode> nodes, String[] hiddenNodes, PermissionChecker permissionChecker) {
        nodes = ListUtil.copy(nodes);
        Arrays.sort(hiddenNodes);
        Iterator itr = nodes.iterator();
        while (itr.hasNext()) {
            WikiNode node = (WikiNode)itr.next();
            if (Arrays.binarySearch(hiddenNodes, node.getName()) < 0 && WikiNodePermission.contains(permissionChecker, node, "VIEW")) continue;
            itr.remove();
        }
        return nodes;
    }

    public static OrderByComparator getPageOrderByComparator(String orderByCol, String orderByType) {
        boolean orderByAsc = false;
        if (orderByType.equals("asc")) {
            orderByAsc = true;
        }
        PageCreateDateComparator orderByComparator = null;
        if (orderByCol.equals("modifiedDate")) {
            orderByComparator = new PageCreateDateComparator(orderByAsc);
        } else if (orderByCol.equals("title")) {
            orderByComparator = new PageTitleComparator(orderByAsc);
        } else if (orderByCol.equals("version")) {
            orderByComparator = new PageVersionComparator(orderByAsc);
        }
        return orderByComparator;
    }

    public static List<WikiNode> orderNodes(List<WikiNode> nodes, String[] visibleNodeNames) {
        if (visibleNodeNames == null || visibleNodeNames.length == 0) {
            return nodes;
        }
        nodes = ListUtil.copy(nodes);
        ArrayList<WikiNode> orderedNodes = new ArrayList<WikiNode>(nodes.size());
        String[] stringArray = visibleNodeNames;
        int n = visibleNodeNames.length;
        int n2 = 0;
        while (n2 < n) {
            String visibleNodeName = stringArray[n2];
            for (WikiNode node : nodes) {
                if (!node.getName().equals(visibleNodeName)) continue;
                orderedNodes.add(node);
                nodes.remove(node);
                break;
            }
            ++n2;
        }
        orderedNodes.addAll(nodes);
        return orderedNodes;
    }

    public static String processContent(String content) {
        content = content.replaceAll("</p>", "</p>\n");
        content = content.replaceAll("</br>", "</br>\n");
        content = content.replaceAll("</div>", "</div>\n");
        return content;
    }

    public static boolean validate(long nodeId, String content, String format) throws WikiFormatException {
        return _instance._validate(nodeId, content, format);
    }

    private static String _decodeJSPWikiContent(String jspWikiContent) {
        return StringUtil.replace((String)jspWikiContent, (String[])_JSP_WIKI_NAME_2, (String[])_JSP_WIKI_NAME_1);
    }

    private String _convert(WikiPage page, PortletURL viewPageURL, PortletURL editPageURL, String attachmentURLPrefix) throws PageContentException, WikiFormatException {
        LiferayPortletURL liferayViewPageURL = (LiferayPortletURL)viewPageURL;
        LiferayPortletURL liferayEditPageURL = (LiferayPortletURL)editPageURL;
        WikiEngine engine = this._getEngine(page.getFormat());
        String content = engine.convert(page, editPageURL);
        String editPageURLString = "";
        if (editPageURL != null) {
            liferayEditPageURL.setParameter("title", "__REPLACEMENT__", false);
            editPageURLString = editPageURL.toString();
            editPageURLString = StringUtil.replace((String)editPageURLString, (String)"__REPLACEMENT__", (String)"$1");
        }
        Matcher matcher = _editPageURLPattern.matcher(content);
        content = matcher.replaceAll(editPageURLString);
        String viewPageURLString = "";
        if (viewPageURL != null) {
            liferayViewPageURL.setParameter("title", "__REPLACEMENT__", false);
            viewPageURLString = viewPageURL.toString();
            viewPageURLString = StringUtil.replace((String)viewPageURLString, (String)"__REPLACEMENT__", (String)"$1");
        }
        matcher = _viewPageURLPattern.matcher(content);
        content = matcher.replaceAll(viewPageURLString);
        content = this._replaceAttachments(content, page.getTitle(), attachmentURLPrefix);
        content = WikiUtil._decodeJSPWikiContent(content);
        return content;
    }

    private String _getEditPage(String format) {
        return PropsUtil.get("wiki.formats.edit.page", new Filter(format));
    }

    private WikiEngine _getEngine(String format) throws WikiFormatException {
        WikiEngine engine = this._engines.get(format);
        if (engine == null) {
            try {
                String engineClass = PropsUtil.get("wiki.formats.engine", new Filter(format));
                if (engineClass != null) {
                    if (!InstancePool.contains((String)engineClass)) {
                        engine = (WikiEngine)InstancePool.get((String)engineClass);
                        engine.setMainConfiguration(this._readConfigurationFile("wiki.formats.configuration.main", format));
                        engine.setInterWikiConfiguration(this._readConfigurationFile("wiki.formats.configuration.interwiki", format));
                    } else {
                        engine = (WikiEngine)InstancePool.get((String)engineClass);
                    }
                    this._engines.put(format, engine);
                }
            }
            catch (Exception e) {
                throw new WikiFormatException((Throwable)e);
            }
            if (engine == null) {
                throw new WikiFormatException(format);
            }
        }
        return engine;
    }

    private String _getHelpPage(String format) {
        return PropsUtil.get("wiki.formats.help.page", new Filter(format));
    }

    private String _getHelpURL(String format) {
        return PropsUtil.get("wiki.formats.help.url", new Filter(format));
    }

    private Map<String, Boolean> _getLinks(WikiPage page) throws PageContentException {
        try {
            return this._getEngine(page.getFormat()).getOutgoingLinks(page);
        }
        catch (WikiFormatException wikiFormatException) {
            return Collections.EMPTY_MAP;
        }
    }

    private String _readConfigurationFile(String propertyName, String format) throws IOException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        String configurationFile = PropsUtil.get(propertyName, new Filter(format));
        if (Validator.isNotNull((String)configurationFile)) {
            return HttpUtil.URLtoString((URL)classLoader.getResource(configurationFile));
        }
        return "";
    }

    private String _replaceAttachments(String content, String title, String attachmentURLPrefix) {
        content = StringUtil.replace((String)content, (String)"[$WIKI_PAGE_NAME$]", (String)title);
        content = StringUtil.replace((String)content, (String)"[$ATTACHMENT_URL_PREFIX$]", (String)attachmentURLPrefix);
        return content;
    }

    private boolean _validate(long nodeId, String content, String format) throws WikiFormatException {
        return this._getEngine(format).validate(nodeId, content);
    }
}

