/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.lar;

import com.liferay.portal.kernel.lar.BasePortletDataHandler;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataException;
import com.liferay.portal.kernel.lar.PortletDataHandlerBoolean;
import com.liferay.portal.kernel.lar.PortletDataHandlerControl;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portlet.wiki.NoSuchNodeException;
import com.liferay.portlet.wiki.lar.WikiPortletDataHandlerImpl;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.service.persistence.WikiNodeUtil;
import com.liferay.portlet.wiki.util.WikiCacheThreadLocal;
import com.liferay.portlet.wiki.util.WikiCacheUtil;
import java.util.Iterator;
import java.util.Map;
import javax.portlet.PortletPreferences;

public class WikiDisplayPortletDataHandlerImpl
extends BasePortletDataHandler {
    private static final String _NAMESPACE = "wiki";
    private static Log _log = LogFactoryUtil.getLog(WikiDisplayPortletDataHandlerImpl.class);
    private static PortletDataHandlerBoolean _attachments = new PortletDataHandlerBoolean("wiki", "attachments");
    private static PortletDataHandlerBoolean _categories = new PortletDataHandlerBoolean("wiki", "categories");
    private static PortletDataHandlerBoolean _comments = new PortletDataHandlerBoolean("wiki", "comments");
    private static PortletDataHandlerBoolean _nodesAndPages = new PortletDataHandlerBoolean("wiki", "wikis-and-pages", true, true);
    private static PortletDataHandlerBoolean _tags = new PortletDataHandlerBoolean("wiki", "tags");

    public PortletDataHandlerControl[] getExportControls() {
        return new PortletDataHandlerControl[]{_nodesAndPages, _attachments, _categories, _comments, _tags};
    }

    public PortletDataHandlerControl[] getImportControls() {
        return new PortletDataHandlerControl[]{_nodesAndPages, _attachments, _categories, _comments, _tags};
    }

    public PortletPreferences importData(PortletDataContext context, String portletId, PortletPreferences preferences, String data) throws PortletDataException {
        WikiCacheThreadLocal.setClearCache(false);
        try {
            PortletPreferences portletPreferences = super.importData(context, portletId, preferences, data);
            return portletPreferences;
        }
        finally {
            WikiCacheThreadLocal.setClearCache(true);
        }
    }

    protected PortletPreferences doDeleteData(PortletDataContext context, String portletId, PortletPreferences preferences) throws Exception {
        preferences.setValue("title", "");
        preferences.setValue("node-id", "");
        return preferences;
    }

    protected String doExportData(PortletDataContext context, String portletId, PortletPreferences preferences) throws Exception {
        long nodeId = GetterUtil.getLong((String)preferences.getValue("node-id", ""));
        if (nodeId <= 0L) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("No node id found in preferences of portlet " + portletId));
            }
            return "";
        }
        String title = preferences.getValue("title", null);
        if (title == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("No title found in preferences of portlet " + portletId));
            }
            return "";
        }
        WikiNode node = null;
        try {
            node = WikiNodeUtil.findByPrimaryKey((long)nodeId);
            return "";
        }
        catch (NoSuchNodeException nsne) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)nsne, (Throwable)nsne);
            }
            context.addPermissions("com.liferay.portlet.wiki", context.getScopeGroupId());
            Document document = SAXReaderUtil.createDocument();
            Element rootElement = document.addElement("wiki-display-data");
            rootElement.addAttribute("group-id", String.valueOf(context.getScopeGroupId()));
            Element nodesElement = rootElement.addElement("nodes");
            Element pagesElement = rootElement.addElement("pages");
            WikiPortletDataHandlerImpl.exportNode(context, nodesElement, pagesElement, node);
            return document.formattedString();
        }
    }

    protected PortletPreferences doImportData(PortletDataContext context, String portletId, PortletPreferences preferences, String data) throws Exception {
        context.importPermissions("com.liferay.portlet.wiki", context.getSourceGroupId(), context.getScopeGroupId());
        if (Validator.isNull((String)data)) {
            return null;
        }
        Document document = SAXReaderUtil.read((String)data);
        Element rootElement = document.getRootElement();
        Element nodesElement = rootElement.element("nodes");
        for (Element nodeElement : nodesElement.elements("node")) {
            String path = nodeElement.attributeValue("path");
            if (!context.isPathNotProcessed(path)) continue;
            WikiNode node = (WikiNode)context.getZipEntryAsObject(path);
            WikiPortletDataHandlerImpl.importNode(context, node);
        }
        Element pagesElement = rootElement.element("pages");
        for (Element pageElement : pagesElement.elements("page")) {
            String path = pageElement.attributeValue("path");
            if (!context.isPathNotProcessed(path)) continue;
            WikiPage page = (WikiPage)context.getZipEntryAsObject(path);
            WikiPortletDataHandlerImpl.importPage(context, pageElement, page);
        }
        Map nodePKs = context.getNewPrimaryKeysMap(WikiNode.class);
        Iterator iterator = nodePKs.values().iterator();
        while (iterator.hasNext()) {
            long nodeId = (Long)iterator.next();
            WikiCacheUtil.clearCache(nodeId);
        }
        long nodeId = GetterUtil.getLong((String)preferences.getValue("node-id", ""));
        if (nodeId > 0L) {
            nodeId = MapUtil.getLong((Map)nodePKs, (long)nodeId, (long)nodeId);
            preferences.setValue("node-id", String.valueOf(nodeId));
        }
        return preferences;
    }
}

