/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.unitconverter.util;

import com.liferay.portlet.unitconverter.model.Conversion;

public class ConverterUtil {
    public static int TEMPERATURE_CELSIUS = 1;
    public static int TEMPERATURE_FAHRENHEIHT = 2;
    private static final double[] _AREA = new double[]{1.0, 1000000.0, 1.0E10, 1.0E12, 1.076391E7, 1.550003E9, 1195990.0, 0.3861022, 100.0, 247.1054};
    private static final double[] _LENGTH = new double[]{1.0, 1000.0, 100.0, 0.001, 3.28084, 39.37008, 1.093613, 6.21E-4, 2.187227, 4.374453, 13.12336};
    private static final double[] _MASS = new double[]{1.0, 2.204623, 0.0011, 0.02939497, 1.763698, 88.18491, 132.2774, 176.2698, 1763.698};
    private static final double[] _VOLUME = new double[]{1.0, 1000.0, 61.02374, 1.816166, 0.004729599, 0.009459198, 0.04729599, 0.141888, 0.4729599, 0.851328, 0.04402868, 0.2641721, 3.170065};

    public static Conversion getConversion(int type, int fromId, int toId, double fromValue) {
        double toValue = 0.0;
        if (type == 0) {
            toValue = ConverterUtil.convertLength(fromId, toId, fromValue);
        } else if (type == 1) {
            toValue = ConverterUtil.convertArea(fromId, toId, fromValue);
        } else if (type == 2) {
            toValue = ConverterUtil.convertVolume(fromId, toId, fromValue);
        } else if (type == 3) {
            toValue = ConverterUtil.convertMass(fromId, toId, fromValue);
        } else if (type == 4) {
            toValue = ConverterUtil.convertTemperature(fromId, toId, fromValue);
        }
        return new Conversion(type, fromId, toId, fromValue, toValue);
    }

    public static double convertArea(int fromId, int toId, double fromValue) {
        return fromValue / _AREA[fromId] * _AREA[toId];
    }

    public static double convertLength(int fromId, int toId, double fromValue) {
        return fromValue / _LENGTH[fromId] * _LENGTH[toId];
    }

    public static double convertMass(int fromId, int toId, double fromValue) {
        return fromValue / _MASS[fromId] * _MASS[toId];
    }

    public static double convertTemperature(int fromId, int toId, double fromValue) {
        return ConverterUtil._fromTemperature(toId, ConverterUtil._toTemperature(fromId, fromValue));
    }

    public static double convertVolume(int fromId, int toId, double fromValue) {
        return fromValue / _VOLUME[fromId] * _VOLUME[toId];
    }

    private static final double _fromTemperature(int toId, double fromValue) {
        if (toId == 0) {
            return fromValue;
        }
        if (toId == 1) {
            return fromValue - 273.15;
        }
        if (toId == 2) {
            return 1.8 * fromValue - 459.67;
        }
        if (toId == 3) {
            return 1.8 * fromValue;
        }
        if (toId == 4) {
            return 0.8 * (fromValue - 273.15);
        }
        return 0.0;
    }

    private static final double _toTemperature(int fromId, double fromValue) {
        if (fromId == 0) {
            return fromValue;
        }
        if (fromId == 1) {
            return fromValue + 273.15;
        }
        if (fromId == 2) {
            return 0.5555555555 * (fromValue + 459.67);
        }
        if (fromId == 3) {
            return 0.5555555555 * fromValue;
        }
        if (fromId == 4) {
            return 1.25 * fromValue + 273.15;
        }
        return 0.0;
    }
}

