/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.tasks.social;

import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.social.model.BaseSocialActivityInterpreter;
import com.liferay.portlet.social.model.SocialActivity;
import com.liferay.portlet.social.model.SocialActivityFeedEntry;
import com.liferay.portlet.tasks.model.TasksProposal;
import com.liferay.portlet.tasks.service.TasksProposalLocalServiceUtil;
import com.liferay.portlet.tasks.service.permission.TasksProposalPermission;

public class TasksActivityInterpreter
extends BaseSocialActivityInterpreter {
    private static final String[] _CLASS_NAMES = new String[]{TasksProposal.class.getName()};

    public String[] getClassNames() {
        return _CLASS_NAMES;
    }

    protected SocialActivityFeedEntry doInterpret(SocialActivity activity, ThemeDisplay themeDisplay) throws Exception {
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        if (!TasksProposalPermission.contains(permissionChecker, activity.getClassPK(), "VIEW")) {
            return null;
        }
        String creatorUserName = this.getUserName(activity.getUserId(), themeDisplay);
        String receiverUserName = this.getUserName(activity.getReceiverUserId(), themeDisplay);
        int activityType = activity.getType();
        JSONObject extraData = null;
        if (Validator.isNotNull((String)activity.getExtraData())) {
            extraData = JSONFactoryUtil.createJSONObject((String)activity.getExtraData());
        }
        String groupName = "";
        if (activity.getGroupId() != themeDisplay.getScopeGroupId()) {
            Group group = GroupLocalServiceUtil.getGroup((long)activity.getGroupId());
            groupName = group.getDescriptiveName();
        }
        String titlePattern = null;
        Object[] titleArguments = null;
        if (activityType == 1) {
            titlePattern = "activity-tasks-add-proposal";
            if (Validator.isNotNull((String)groupName)) {
                titlePattern = String.valueOf(titlePattern) + "-in";
            }
            titleArguments = new Object[]{creatorUserName, HtmlUtil.escape((String)groupName)};
        } else if (activityType == 2) {
            titlePattern = "activity-tasks-assign-proposal";
            if (Validator.isNotNull((String)groupName)) {
                titlePattern = String.valueOf(titlePattern) + "-in";
            }
            titleArguments = new Object[]{creatorUserName, receiverUserName, HtmlUtil.escape((String)groupName)};
        } else if (activityType == 3) {
            titlePattern = "activity-tasks-review-proposal";
            if (Validator.isNotNull((String)groupName)) {
                titlePattern = String.valueOf(titlePattern) + "-in";
            }
            titleArguments = new Object[]{creatorUserName, receiverUserName, HtmlUtil.escape((String)groupName)};
        }
        String title = themeDisplay.translate(titlePattern, titleArguments);
        TasksProposal proposal = TasksProposalLocalServiceUtil.getProposal((long)activity.getClassPK());
        StringBundler sb = new StringBundler();
        sb.append("<b>");
        sb.append(HtmlUtil.escape((String)proposal.getName()));
        sb.append("</b> (");
        sb.append(themeDisplay.translate("model.resource." + proposal.getClassName()));
        sb.append(")<br />");
        sb.append(themeDisplay.translate("description"));
        sb.append(": ");
        sb.append(HtmlUtil.escape((String)proposal.getDescription()));
        if (activityType != 1) {
            int stage = extraData.getInt("stage");
            boolean completed = extraData.getBoolean("completed");
            boolean rejected = extraData.getBoolean("rejected");
            sb.append("<br />");
            sb.append(themeDisplay.translate("stage"));
            sb.append(": ");
            sb.append(stage);
            sb.append("<br />");
            sb.append(themeDisplay.translate("status"));
            sb.append(": ");
            if (completed && rejected) {
                sb.append(themeDisplay.translate("rejected"));
            } else if (completed && !rejected) {
                sb.append(themeDisplay.translate("approved"));
            } else {
                sb.append(themeDisplay.translate("awaiting-approval"));
            }
        }
        String body = sb.toString();
        return new SocialActivityFeedEntry(title, body);
    }
}

