/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.softwarecatalog.util;

import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.BooleanQueryFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeIndexerUtil;
import com.liferay.portlet.softwarecatalog.model.SCProductEntry;
import com.liferay.portlet.softwarecatalog.model.SCProductVersion;
import com.liferay.portlet.softwarecatalog.service.SCProductEntryLocalServiceUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.portlet.PortletURL;

public class SCIndexer
extends BaseIndexer {
    public static final String[] CLASS_NAMES = new String[]{SCProductEntry.class.getName()};
    public static final String PORTLET_ID = "98";

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public Summary getSummary(Document document, String snippet, PortletURL portletURL) {
        String title = document.get("title");
        String content = snippet;
        if (Validator.isNull((String)snippet)) {
            content = StringUtil.shorten((String)document.get("content"), (int)200);
        }
        String productEntryId = document.get("entryClassPK");
        portletURL.setParameter("struts_action", "/software_catalog/view_product_entry");
        portletURL.setParameter("productEntryId", productEntryId);
        return new Summary(title, content, portletURL);
    }

    protected void doDelete(Object obj) throws Exception {
        SCProductEntry productEntry = (SCProductEntry)obj;
        DocumentImpl document = new DocumentImpl();
        document.addUID(PORTLET_ID, productEntry.getProductEntryId());
        SearchEngineUtil.deleteDocument((long)productEntry.getCompanyId(), (String)document.get("uid"));
    }

    protected Document doGetDocument(Object obj) throws Exception {
        SCProductEntry productEntry = (SCProductEntry)obj;
        long companyId = productEntry.getCompanyId();
        long groupId = this.getParentGroupId(productEntry.getGroupId());
        long scopeGroupId = productEntry.getGroupId();
        long userId = productEntry.getUserId();
        String userName = PortalUtil.getUserName((long)userId, (String)productEntry.getUserName());
        long productEntryId = productEntry.getProductEntryId();
        String name = productEntry.getName();
        Date modifiedDate = productEntry.getModifiedDate();
        String version = "";
        SCProductVersion latestProductVersion = productEntry.getLatestVersion();
        if (latestProductVersion != null) {
            version = latestProductVersion.getVersion();
        }
        String type = productEntry.getType();
        String shortDescription = HtmlUtil.extractText((String)productEntry.getShortDescription());
        String longDescription = HtmlUtil.extractText((String)productEntry.getLongDescription());
        String pageURL = productEntry.getPageURL();
        String repoGroupId = productEntry.getRepoGroupId();
        String repoArtifactId = productEntry.getRepoArtifactId();
        ExpandoBridge expandoBridge = productEntry.getExpandoBridge();
        StringBundler sb = new StringBundler(15);
        sb.append(userId);
        sb.append(" ");
        sb.append(userName);
        sb.append(" ");
        sb.append(type);
        sb.append(" ");
        sb.append(shortDescription);
        sb.append(" ");
        sb.append(longDescription);
        sb.append(" ");
        sb.append(pageURL);
        sb.append(" ");
        sb.append(repoGroupId);
        sb.append(" ");
        sb.append(repoArtifactId);
        String content = sb.toString();
        DocumentImpl document = new DocumentImpl();
        document.addUID(PORTLET_ID, productEntryId);
        document.addModifiedDate(modifiedDate);
        document.addKeyword("companyId", companyId);
        document.addKeyword("portletId", PORTLET_ID);
        document.addKeyword("groupId", groupId);
        document.addKeyword("scopeGroupId", scopeGroupId);
        document.addKeyword("userId", userId);
        document.addText("userName", userName);
        document.addText("title", name);
        document.addText("content", content);
        document.addKeyword("entryClassName", SCProductEntry.class.getName());
        document.addKeyword("entryClassPK", productEntryId);
        document.addKeyword("version", version);
        document.addKeyword("type", type);
        document.addText("shortDescription", shortDescription);
        document.addText("longDescription", longDescription);
        document.addText("pageURL", pageURL);
        document.addKeyword("repoGroupId", repoGroupId);
        document.addKeyword("repoArtifactId", repoArtifactId);
        ExpandoBridgeIndexerUtil.addAttributes((Document)document, (ExpandoBridge)expandoBridge);
        return document;
    }

    protected void doReindex(Object obj) throws Exception {
        SCProductEntry productEntry = (SCProductEntry)obj;
        Document document = this.getDocument(productEntry);
        SearchEngineUtil.updateDocument((long)productEntry.getCompanyId(), (Document)document);
    }

    protected void doReindex(String className, long classPK) throws Exception {
        SCProductEntry productEntry = SCProductEntryLocalServiceUtil.getProductEntry((long)classPK);
        this.doReindex(productEntry);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexProductEntries(companyId);
    }

    protected String getPortletId(SearchContext searchContext) {
        return PORTLET_ID;
    }

    protected void postProcessFullQuery(BooleanQuery fullQuery, SearchContext searchContext) throws Exception {
        String type = (String)((Object)searchContext.getAttribute("type"));
        if (Validator.isNotNull((String)type)) {
            BooleanQuery searchQuery = BooleanQueryFactoryUtil.create();
            searchQuery.addRequiredTerm("type", type);
            fullQuery.add((Query)searchQuery, BooleanClauseOccur.MUST);
        }
    }

    protected void reindexProductEntries(long companyId) throws Exception {
        int count = SCProductEntryLocalServiceUtil.getCompanyProductEntriesCount((long)companyId);
        int pages = count / 1000;
        int i = 0;
        while (i <= pages) {
            int start = i * 1000;
            int end = start + 1000;
            this.reindexProductEntries(companyId, start, end);
            ++i;
        }
    }

    protected void reindexProductEntries(long companyId, int start, int end) throws Exception {
        List productEntries = SCProductEntryLocalServiceUtil.getCompanyProductEntries((long)companyId, (int)start, (int)end);
        if (productEntries.isEmpty()) {
            return;
        }
        ArrayList<Document> documents = new ArrayList<Document>();
        for (SCProductEntry productEntry : productEntries) {
            Document document = this.getDocument(productEntry);
            documents.add(document);
        }
        SearchEngineUtil.updateDocuments((long)companyId, documents);
    }
}

