/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.softwarecatalog.action;

import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portlet.softwarecatalog.LicenseNameException;
import com.liferay.portlet.softwarecatalog.NoSuchLicenseException;
import com.liferay.portlet.softwarecatalog.action.ActionUtil;
import com.liferay.portlet.softwarecatalog.service.SCLicenseServiceUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditLicenseAction
extends PortletAction {
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                this.updateLicense(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteLicense(actionRequest);
            }
            this.sendRedirect(actionRequest, actionResponse);
        }
        catch (Exception e) {
            if (e instanceof NoSuchLicenseException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
                this.setForward((PortletRequest)actionRequest, "portlet.software_catalog.error");
            }
            if (e instanceof LicenseNameException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
            }
            throw e;
        }
    }

    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getLicense((PortletRequest)renderRequest);
        }
        catch (Exception e) {
            if (e instanceof NoSuchLicenseException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, (String)e.getClass().getName());
                return mapping.findForward("portlet.software_catalog.error");
            }
            throw e;
        }
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.software_catalog.edit_license"));
    }

    protected void deleteLicense(ActionRequest actionRequest) throws Exception {
        long licenseId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"licenseId");
        SCLicenseServiceUtil.deleteLicense((long)licenseId);
    }

    protected void updateLicense(ActionRequest actionRequest) throws Exception {
        long licenseId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"licenseId");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        String url = ParamUtil.getString((PortletRequest)actionRequest, (String)"url");
        boolean openSource = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"openSource");
        boolean active = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"active");
        boolean recommended = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"recommended");
        if (licenseId <= 0L) {
            SCLicenseServiceUtil.addLicense((String)name, (String)url, (boolean)openSource, (boolean)active, (boolean)recommended);
        } else {
            SCLicenseServiceUtil.updateLicense((long)licenseId, (String)name, (String)url, (boolean)openSource, (boolean)active, (boolean)recommended);
        }
    }
}

