/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.social.service.impl;

import com.liferay.ibm.icu.util.GregorianCalendar;
import com.liferay.portal.NoSuchUserException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.increment.BufferedIncrement;
import com.liferay.portal.kernel.increment.SocialEquityIncrement;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.User;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.asset.NoSuchEntryException;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.social.NoSuchEquityAssetEntryException;
import com.liferay.portlet.social.model.SocialEquityAssetEntry;
import com.liferay.portlet.social.model.SocialEquityLog;
import com.liferay.portlet.social.model.SocialEquitySetting;
import com.liferay.portlet.social.model.SocialEquityValue;
import com.liferay.portlet.social.service.base.SocialEquityLogLocalServiceBaseImpl;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;

public class SocialEquityLogLocalServiceImpl
extends SocialEquityLogLocalServiceBaseImpl {
    private static final String _ADD_SOCIAL_EQUITY_ASSET_ENTRY = String.valueOf(SocialEquityLogLocalServiceImpl.class.getName()) + ".addSocialEquityAssetEntry";
    private static final String _ADD_SOCIAL_EQUITY_USER = String.valueOf(SocialEquityLogLocalServiceImpl.class.getName()) + ".addSocialEquityUser";
    private static final String _CHECK_SOCIAL_EQUITY_ASSET_ENTRY_IQ = String.valueOf(SocialEquityLogLocalServiceImpl.class.getName()) + ".checkSocialEquityAssetEntry_IQ";
    private static final String _CHECK_SOCIAL_EQUITY_LOGS = String.valueOf(SocialEquityLogLocalServiceImpl.class.getName()) + ".checkSocialEquityLogs";
    private static final String _CHECK_SOCIAL_EQUITY_USER = String.valueOf(SocialEquityLogLocalServiceImpl.class.getName()) + ".checkSocialEquityUser";
    private static final String _CHECK_SOCIAL_EQUITY_USER_CQ = String.valueOf(SocialEquityLogLocalServiceImpl.class.getName()) + ".checkSocialEquityUser_CQ";
    private static final String _CHECK_SOCIAL_EQUITY_USER_PQ = String.valueOf(SocialEquityLogLocalServiceImpl.class.getName()) + ".checkSocialEquityUser_PQ";
    private static final String _FIND_SOCIAL_EQUITY_USER = String.valueOf(SocialEquityLogLocalServiceImpl.class.getName()) + ".findSocialEquityUser";
    private static final String _FIND_SOCIAL_EQUITY_USER_BY_GROUP = String.valueOf(SocialEquityLogLocalServiceImpl.class.getName()) + ".findSocialEquityUserByGroup";
    private static final String _UPDATE_SOCIAL_EQUITY_ASSET_ENTRY_IQ = String.valueOf(SocialEquityLogLocalServiceImpl.class.getName()) + ".updateSocialEquityAssetEntry_IQ";
    private static final String _UPDATE_SOCIAL_EQUITY_USER_CQ = String.valueOf(SocialEquityLogLocalServiceImpl.class.getName()) + ".updateSocialEquityUser_CQ";
    private static final String _UPDATE_SOCIAL_EQUITY_USER_PQ = String.valueOf(SocialEquityLogLocalServiceImpl.class.getName()) + ".updateSocialEquityUser_PQ";
    private static final String _UPDATE_SOCIAL_EQUITY_USER_RANK = String.valueOf(SocialEquityLogLocalServiceImpl.class.getName()) + ".updateSocialEquityUserRank";

    public void addEquityLogs(long userId, long assetEntryId, String actionId) throws PortalException, SystemException {
        if (!PropsValues.SOCIAL_EQUITY_EQUITY_LOG_ENABLED) {
            return;
        }
        User user = this.userPersistence.findByPrimaryKey(userId);
        AssetEntry assetEntry = this.assetEntryPersistence.findByPrimaryKey(assetEntryId);
        User assetEntryUser = null;
        try {
            assetEntryUser = this.userPersistence.findByPrimaryKey(assetEntry.getUserId());
        }
        catch (NoSuchUserException noSuchUserException) {}
        List equitySettings = this.socialEquitySettingLocalService.getEquitySettings(assetEntry.getGroupId(), assetEntry.getClassNameId(), actionId);
        for (SocialEquitySetting equitySetting : equitySettings) {
            if (!this.isSocialEquityEnabled(assetEntry.getGroupId(), assetEntry.getClassName(), equitySetting.getType())) continue;
            this.addEquityLog(user, assetEntry, assetEntryUser, equitySetting);
        }
    }

    public void addEquityLogs(long userId, String className, long classPK, String actionId) throws PortalException, SystemException {
        if (!PropsValues.SOCIAL_EQUITY_EQUITY_LOG_ENABLED) {
            return;
        }
        AssetEntry assetEntry = null;
        try {
            assetEntry = this.assetEntryLocalService.getEntry(className, classPK);
        }
        catch (NoSuchEntryException noSuchEntryException) {
            return;
        }
        this.addEquityLogs(userId, assetEntry.getEntryId(), actionId);
    }

    public void checkEquityLogs() throws SystemException {
        int validity = this.getEquityDate();
        if (!PropsValues.SOCIAL_EQUITY_EQUITY_LOG_ENABLED) {
            return;
        }
        this.runCheckSQL(_CHECK_SOCIAL_EQUITY_ASSET_ENTRY_IQ, validity);
        this.assetEntryPersistence.clearCache();
        this.runCheckSQL(_CHECK_SOCIAL_EQUITY_USER, validity);
        this.runCheckSQL(_CHECK_SOCIAL_EQUITY_USER_CQ, validity);
        this.runCheckSQL(_CHECK_SOCIAL_EQUITY_USER_PQ, validity);
        this.userPersistence.clearCache();
        this.runCheckSQL(_CHECK_SOCIAL_EQUITY_LOGS, validity);
        this.socialEquityLogPersistence.clearCache();
        this.updateRanks();
    }

    public void deactivateEquityLogs(long assetEntryId) throws PortalException, SystemException {
        if (!PropsValues.SOCIAL_EQUITY_EQUITY_LOG_ENABLED) {
            return;
        }
        SocialEquityAssetEntry equityAssetEntry = null;
        try {
            equityAssetEntry = this.socialEquityAssetEntryPersistence.findByAssetEntryId(assetEntryId);
            this.socialEquityAssetEntryPersistence.removeByAssetEntryId(assetEntryId);
        }
        catch (NoSuchEquityAssetEntryException noSuchEquityAssetEntryException) {
            return;
        }
        User user = null;
        try {
            user = this.userPersistence.findByPrimaryKey(equityAssetEntry.getUserId());
            if (!user.isDefaultUser()) {
                SocialEquityValue socialEquityValue = new SocialEquityValue(-equityAssetEntry.getInformationK(), -equityAssetEntry.getInformationB());
                this.incrementSocialEquityUser_CQ(equityAssetEntry.getGroupId(), user.getUserId(), socialEquityValue);
            }
        }
        catch (NoSuchUserException noSuchUserException) {}
        List equityLogs = this.socialEquityLogPersistence.findByAEI_T_A(assetEntryId, 1, true);
        for (SocialEquityLog equityLog : equityLogs) {
            equityLog.setActive(false);
            this.socialEquityLogPersistence.update((BaseModel)equityLog, false);
        }
    }

    public void deactivateEquityLogs(long userId, long assetEntryId, String actionId) throws PortalException, SystemException {
        double b;
        double k;
        SocialEquityValue socialEquityValue;
        List equityLogs;
        if (!PropsValues.SOCIAL_EQUITY_EQUITY_LOG_ENABLED) {
            return;
        }
        User user = this.userPersistence.findByPrimaryKey(userId);
        AssetEntry assetEntry = this.assetEntryPersistence.findByPrimaryKey(assetEntryId);
        if (this.isSocialEquityEnabled(assetEntry.getGroupId(), assetEntry.getClassName(), 1)) {
            equityLogs = this.socialEquityLogPersistence.findByAEI_AID_A_T(assetEntryId, actionId, true, 1);
            socialEquityValue = new SocialEquityValue(0.0, 0.0);
            for (SocialEquityLog equityLog : equityLogs) {
                k = this.calculateK(equityLog.getValue(), equityLog.getLifespan());
                b = this.calculateB(equityLog.getActionDate(), equityLog.getValue(), equityLog.getLifespan());
                socialEquityValue.subtract(new SocialEquityValue(k, b));
                this.socialEquityLogPersistence.remove((BaseModel)equityLog);
            }
            this.socialEquityLogLocalService.incrementSocialEquityAssetEntry_IQ(assetEntryId, socialEquityValue);
            this.socialEquityLogLocalService.incrementSocialEquityUser_CQ(assetEntry.getGroupId(), assetEntry.getUserId(), socialEquityValue);
        }
        if (this.isSocialEquityEnabled(assetEntry.getGroupId(), assetEntry.getClassName(), 2)) {
            equityLogs = this.socialEquityLogPersistence.findByU_AID_A_T(userId, actionId, true, 2);
            socialEquityValue = new SocialEquityValue(0.0, 0.0);
            for (SocialEquityLog equityLog : equityLogs) {
                k = this.calculateK(equityLog.getValue(), equityLog.getLifespan());
                b = this.calculateB(equityLog.getActionDate(), equityLog.getValue(), equityLog.getLifespan());
                socialEquityValue.subtract(new SocialEquityValue(k, b));
                this.socialEquityLogPersistence.remove((BaseModel)equityLog);
            }
            this.socialEquityLogLocalService.incrementSocialEquityUser_PQ(user.getGroup().getGroupId(), userId, socialEquityValue);
        }
    }

    public void deactivateEquityLogs(long userId, String className, long classPK, String actionId) throws PortalException, SystemException {
        if (!PropsValues.SOCIAL_EQUITY_EQUITY_LOG_ENABLED) {
            return;
        }
        AssetEntry assetEntry = null;
        try {
            assetEntry = this.assetEntryLocalService.getEntry(className, classPK);
        }
        catch (NoSuchEntryException noSuchEntryException) {
            return;
        }
        this.deactivateEquityLogs(userId, assetEntry.getEntryId(), actionId);
    }

    @BufferedIncrement(incrementClass=SocialEquityIncrement.class)
    public void incrementSocialEquityAssetEntry_IQ(long assetEntryId, SocialEquityValue socialEquityValue) throws SystemException {
        AssetEntry assetEntry = this.assetEntryPersistence.fetchByPrimaryKey(assetEntryId);
        assetEntry.updateSocialInformationEquity(socialEquityValue.getValue());
        int count = this.socialEquityAssetEntryPersistence.countByAssetEntryId(assetEntryId);
        if (count == 0) {
            this.addSocialEquityAssetEntry(assetEntry);
        }
        String sql = CustomSQLUtil.get((String)_UPDATE_SOCIAL_EQUITY_ASSET_ENTRY_IQ);
        sql = StringUtil.replace((String)sql, (String[])new String[]{"[$ASSET_ENTRY_ID$]", "[$INFORMATION_B$]", "[$INFORMATION_K$]"}, (String[])new String[]{String.valueOf(assetEntryId), String.valueOf(socialEquityValue.getB()), String.valueOf(socialEquityValue.getK())});
        this.runSQL(sql);
    }

    @BufferedIncrement(incrementClass=SocialEquityIncrement.class)
    public void incrementSocialEquityUser_CQ(long groupId, long userId, SocialEquityValue socialEquityValue) throws PortalException, SystemException {
        User user = this.userLocalService.getUser(userId);
        int count = this.socialEquityUserPersistence.countByG_U(groupId, userId);
        if (count == 0) {
            this.addSocialEquityUser(groupId, user);
        }
        user.updateSocialContributionEquity(socialEquityValue.getValue());
        String sql = CustomSQLUtil.get((String)_UPDATE_SOCIAL_EQUITY_USER_CQ);
        sql = StringUtil.replace((String)sql, (String[])new String[]{"[$CONTRIBUTION_B$]", "[$CONTRIBUTION_K$]", "[$GROUP_ID$]", "[$USER_ID$]"}, (String[])new String[]{String.valueOf(socialEquityValue.getB()), String.valueOf(socialEquityValue.getK()), String.valueOf(groupId), String.valueOf(userId)});
        this.runSQL(sql);
    }

    @BufferedIncrement(incrementClass=SocialEquityIncrement.class)
    public void incrementSocialEquityUser_PQ(long groupId, long userId, SocialEquityValue socialEquityValue) throws PortalException, SystemException {
        User user = this.userLocalService.getUser(userId);
        int count = this.socialEquityUserPersistence.countByG_U(groupId, userId);
        if (count == 0) {
            this.addSocialEquityUser(groupId, user);
        }
        user.updateSocialParticipationEquity(socialEquityValue.getValue());
        String sql = CustomSQLUtil.get((String)_UPDATE_SOCIAL_EQUITY_USER_PQ);
        sql = StringUtil.replace((String)sql, (String[])new String[]{"[$GROUP_ID$]", "[$PARTICIPATION_B$]", "[$PARTICIPATION_K$]", "[$USER_ID$]"}, (String[])new String[]{String.valueOf(groupId), String.valueOf(socialEquityValue.getB()), String.valueOf(socialEquityValue.getK()), String.valueOf(userId)});
        this.runSQL(sql);
    }

    public void updateRanks() {
        DataSource dataSource = this.socialEquityLogPersistence.getDataSource();
        JdbcTemplate jdbcTemplate = new JdbcTemplate(dataSource);
        UpdateRanksHandler updateRanksHandler = new UpdateRanksHandler(jdbcTemplate);
        String sql = CustomSQLUtil.get((String)_FIND_SOCIAL_EQUITY_USER);
        sql = StringUtil.replace((String)sql, (String)"[$ACTION_DATE$]", (String)String.valueOf(this.getEquityDate()));
        jdbcTemplate.query(sql, (RowCallbackHandler)updateRanksHandler);
        updateRanksHandler.flush();
    }

    public void updateRanks(long groupId) {
        DataSource dataSource = this.socialEquityLogPersistence.getDataSource();
        JdbcTemplate jdbcTemplate = new JdbcTemplate(dataSource);
        UpdateRanksHandler updateRanksHandler = new UpdateRanksHandler(jdbcTemplate);
        String sql = CustomSQLUtil.get((String)_FIND_SOCIAL_EQUITY_USER_BY_GROUP);
        sql = StringUtil.replace((String)sql, (String[])new String[]{"[$ACTION_DATE$]", "[$GROUP_ID$]"}, (String[])new String[]{String.valueOf(this.getEquityDate()), String.valueOf(groupId)});
        jdbcTemplate.query(sql, (RowCallbackHandler)updateRanksHandler);
        updateRanksHandler.flush();
    }

    protected void addEquityLog(User user, AssetEntry assetEntry, User assetEntryUser, SocialEquitySetting equitySetting) throws PortalException, SystemException {
        if (!this.isAddEquityLog(user.getUserId(), assetEntry.getEntryId(), equitySetting)) {
            return;
        }
        int actionDate = this.getEquityDate();
        double k = this.calculateK(equitySetting.getValue(), equitySetting.getLifespan());
        double b = this.calculateB(actionDate, equitySetting.getValue(), equitySetting.getLifespan());
        SocialEquityValue socialEquity = new SocialEquityValue(k, b);
        if (equitySetting.getType() == 1) {
            this.socialEquityLogLocalService.incrementSocialEquityAssetEntry_IQ(assetEntry.getEntryId(), socialEquity);
            if (assetEntryUser != null && !assetEntryUser.isDefaultUser()) {
                this.socialEquityLogLocalService.incrementSocialEquityUser_CQ(assetEntry.getGroupId(), assetEntryUser.getUserId(), socialEquity);
            }
        } else if (equitySetting.getType() == 2 && !user.isDefaultUser()) {
            this.socialEquityLogLocalService.incrementSocialEquityUser_PQ(assetEntry.getGroupId(), user.getUserId(), socialEquity);
        }
        long equityLogId = this.counterLocalService.increment();
        SocialEquityLog equityLog = this.socialEquityLogPersistence.create(equityLogId);
        equityLog.setGroupId(assetEntry.getGroupId());
        equityLog.setCompanyId(user.getCompanyId());
        equityLog.setUserId(user.getUserId());
        equityLog.setAssetEntryId(assetEntry.getEntryId());
        equityLog.setActionId(equitySetting.getActionId());
        equityLog.setActionDate(actionDate);
        equityLog.setType(equitySetting.getType());
        equityLog.setValue(equitySetting.getValue());
        equityLog.setExpiration(actionDate + equitySetting.getLifespan());
        equityLog.setActive(true);
        this.socialEquityLogPersistence.update((BaseModel)equityLog, false);
    }

    protected void addSocialEquityAssetEntry(AssetEntry assetEntry) throws SystemException {
        String sql = CustomSQLUtil.get((String)_ADD_SOCIAL_EQUITY_ASSET_ENTRY);
        sql = StringUtil.replace((String)sql, (String[])new String[]{"[$ASSET_ENTRY_ID$]", "[$COMPANY_ID$]", "[$EQUITY_ASSET_ENTRY_ID$]", "[$GROUP_ID$]", "[$USER_ID$]"}, (String[])new String[]{String.valueOf(assetEntry.getEntryId()), String.valueOf(assetEntry.getCompanyId()), String.valueOf(this.counterLocalService.increment()), String.valueOf(assetEntry.getGroupId()), String.valueOf(assetEntry.getUserId())});
        this.runSQL(sql);
    }

    protected void addSocialEquityUser(long groupId, User user) throws SystemException {
        String sql = CustomSQLUtil.get((String)_ADD_SOCIAL_EQUITY_USER);
        sql = StringUtil.replace((String)sql, (String[])new String[]{"[$COMPANY_ID$]", "[$EQUITY_USER_ID$]", "[$GROUP_ID$]", "[$USER_ID$]"}, (String[])new String[]{String.valueOf(user.getCompanyId()), String.valueOf(this.counterLocalService.increment()), String.valueOf(groupId), String.valueOf(user.getUserId())});
        this.runSQL(sql);
    }

    protected double calculateB(int actionDate, int value, int lifespan) {
        return this.calculateK(value, lifespan) * (double)(actionDate + lifespan) * -1.0;
    }

    protected double calculateEquity(int actionDate, double k, double b) {
        return k * (double)actionDate + b;
    }

    protected double calculateK(int value, int lifespan) {
        if (lifespan == 0) {
            return 0.0;
        }
        return (double)value / (double)lifespan * -1.0;
    }

    protected int getEquityDate() {
        return this.getEquityDate(new Date());
    }

    protected int getEquityDate(Date date) {
        GregorianCalendar calendar = new GregorianCalendar(2010, 0, 1);
        return calendar.fieldDifference(date, 5);
    }

    protected boolean isAddEquityLog(long userId, long assetEntryId, SocialEquitySetting equitySetting) throws SystemException {
        int count;
        int type;
        int actionDate;
        if (equitySetting.getDailyLimit() < 0) {
            return false;
        }
        String actionId = equitySetting.getActionId();
        if (this.socialEquityLogPersistence.countByU_AEI_AID_AD_A_T(userId, assetEntryId, actionId, actionDate = this.getEquityDate(), true, type = equitySetting.getType()) > 0) {
            return false;
        }
        if (equitySetting.isUniqueEntry()) {
            count = 0;
            count = type == 1 ? this.socialEquityLogPersistence.countByAEI_AID_A_T(assetEntryId, actionId, true, type) : this.socialEquityLogPersistence.countByU_AID_A_T(userId, actionId, true, type);
            if (count > 0) {
                return false;
            }
        }
        if (equitySetting.getDailyLimit() == 0) {
            return true;
        }
        count = 0;
        count = type == 1 ? this.socialEquityLogPersistence.countByAEI_AID_AD_A_T(assetEntryId, actionId, actionDate, true, type) : this.socialEquityLogPersistence.countByU_AID_AD_A_T(userId, actionId, actionDate, true, type);
        return count < equitySetting.getDailyLimit();
    }

    protected boolean isSocialEquityEnabled(long groupId, String className, int type) throws SystemException {
        if (!this.socialEquityGroupSettingLocalService.isEnabled(groupId, Group.class.getName(), type)) {
            return false;
        }
        return this.socialEquityGroupSettingLocalService.isEnabled(groupId, className, type);
    }

    protected void runCheckSQL(String sqlId, int validity) throws SystemException {
        String sql = CustomSQLUtil.get((String)sqlId);
        sql = StringUtil.replace((String)sql, (String[])new String[]{"[$TYPE_INFORMATION$]", "[$TYPE_PARTICIPATION$]", "[$EXPIRATION$]"}, (String[])new String[]{String.valueOf(1), String.valueOf(2), String.valueOf(validity)});
        this.runSQL(sql);
    }

    static /* synthetic */ String access$0() {
        return _UPDATE_SOCIAL_EQUITY_USER_RANK;
    }

    private class UpdateRanksHandler
    implements RowCallbackHandler {
        private double _equityValue;
        private long _groupId;
        private long _rank;
        private long _ties;
        private UpdateRanksSetter _updateRanksSetter;

        public UpdateRanksHandler(JdbcTemplate jdbcTemplate) {
            this._updateRanksSetter = new UpdateRanksSetter(jdbcTemplate);
        }

        public void flush() {
            this._updateRanksSetter.flush();
        }

        public void processRow(ResultSet rs) throws SQLException {
            long equityUserId = rs.getLong("equityUserId");
            long groupId = rs.getLong("groupId");
            double equityValue = rs.getDouble("equityValue");
            if (groupId == this._groupId) {
                if (equityValue == this._equityValue) {
                    ++this._ties;
                } else {
                    this._equityValue = equityValue;
                    this._rank = this._rank + this._ties + 1L;
                    this._ties = 0L;
                }
            } else {
                this._groupId = groupId;
                this._rank = 1L;
                this._ties = 0L;
            }
            this._updateRanksSetter.add(equityUserId, this._rank);
        }
    }

    private class UpdateRanksSetter
    implements BatchPreparedStatementSetter {
        private JdbcTemplate _jdbcTemplate;
        private String _sql = CustomSQLUtil.get((String)SocialEquityLogLocalServiceImpl.access$0());
        private List<Long[]> _sqlParams = new ArrayList<Long[]>();

        public UpdateRanksSetter(JdbcTemplate jdbcTemplate) {
            this._jdbcTemplate = jdbcTemplate;
        }

        public void add(long equityUserId, long rank) {
            this._sqlParams.add(new Long[]{equityUserId, rank});
            if (this._sqlParams.size() >= 100) {
                this.flush();
            }
        }

        public int getBatchSize() {
            return this._sqlParams.size();
        }

        public void flush() {
            try {
                this._jdbcTemplate.batchUpdate(this._sql, (BatchPreparedStatementSetter)this);
            }
            finally {
                this._sqlParams.clear();
            }
        }

        public void setValues(PreparedStatement ps, int index) throws SQLException {
            Long[] sqlParams = this._sqlParams.get(index);
            long equityUserId = sqlParams[0];
            long rank = sqlParams[1];
            ps.setLong(1, rank);
            ps.setLong(2, equityUserId);
            ps.setLong(3, rank);
        }
    }
}

