/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.shopping.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.shopping.model.ShoppingItem;
import com.liferay.portlet.shopping.model.ShoppingItemField;
import com.liferay.portlet.shopping.model.ShoppingItemPrice;
import com.liferay.portlet.shopping.service.base.ShoppingItemServiceBaseImpl;
import com.liferay.portlet.shopping.service.permission.ShoppingCategoryPermission;
import com.liferay.portlet.shopping.service.permission.ShoppingItemPermission;
import java.io.File;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShoppingItemServiceImpl
extends ShoppingItemServiceBaseImpl {
    public void addBookItems(long groupId, long categoryId, String[] isbns) throws PortalException, SystemException {
        ShoppingCategoryPermission.check(this.getPermissionChecker(), groupId, categoryId, "ADD_ITEM");
        this.shoppingItemLocalService.addBookItems(this.getUserId(), groupId, categoryId, isbns);
    }

    public ShoppingItem addItem(long groupId, long categoryId, String sku, String name, String description, String properties, String fieldsQuantities, boolean requiresShipping, int stockQuantity, boolean featured, Boolean sale, boolean smallImage, String smallImageURL, File smallFile, boolean mediumImage, String mediumImageURL, File mediumFile, boolean largeImage, String largeImageURL, File largeFile, List<ShoppingItemField> itemFields, List<ShoppingItemPrice> itemPrices, ServiceContext serviceContext) throws PortalException, SystemException {
        ShoppingCategoryPermission.check(this.getPermissionChecker(), groupId, categoryId, "ADD_ITEM");
        return this.shoppingItemLocalService.addItem(this.getUserId(), groupId, categoryId, sku, name, description, properties, fieldsQuantities, requiresShipping, stockQuantity, featured, sale, smallImage, smallImageURL, smallFile, mediumImage, mediumImageURL, mediumFile, largeImage, largeImageURL, largeFile, itemFields, itemPrices, serviceContext);
    }

    public void deleteItem(long itemId) throws PortalException, SystemException {
        ShoppingItemPermission.check(this.getPermissionChecker(), itemId, "DELETE");
        this.shoppingItemLocalService.deleteItem(itemId);
    }

    public ShoppingItem getItem(long itemId) throws PortalException, SystemException {
        ShoppingItemPermission.check(this.getPermissionChecker(), itemId, "VIEW");
        return this.shoppingItemLocalService.getItem(itemId);
    }

    public ShoppingItem updateItem(long itemId, long groupId, long categoryId, String sku, String name, String description, String properties, String fieldsQuantities, boolean requiresShipping, int stockQuantity, boolean featured, Boolean sale, boolean smallImage, String smallImageURL, File smallFile, boolean mediumImage, String mediumImageURL, File mediumFile, boolean largeImage, String largeImageURL, File largeFile, List<ShoppingItemField> itemFields, List<ShoppingItemPrice> itemPrices, ServiceContext serviceContext) throws PortalException, SystemException {
        ShoppingItemPermission.check(this.getPermissionChecker(), itemId, "UPDATE");
        return this.shoppingItemLocalService.updateItem(this.getUserId(), itemId, groupId, categoryId, sku, name, description, properties, fieldsQuantities, requiresShipping, stockQuantity, featured, sale, smallImage, smallImageURL, smallFile, mediumImage, mediumImageURL, mediumFile, largeImage, largeImageURL, largeFile, itemFields, itemPrices, serviceContext);
    }
}

