/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.polls.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portlet.polls.model.PollsQuestion;
import com.liferay.portlet.polls.service.PollsQuestionLocalServiceUtil;

public class PollsQuestionPermission {
    public static void check(PermissionChecker permissionChecker, long questionId, String actionId) throws PortalException, SystemException {
        if (!PollsQuestionPermission.contains(permissionChecker, questionId, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, PollsQuestion question, String actionId) throws PortalException {
        if (!PollsQuestionPermission.contains(permissionChecker, question, actionId)) {
            throw new PrincipalException();
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, long questionId, String actionId) throws PortalException, SystemException {
        PollsQuestion question = PollsQuestionLocalServiceUtil.getQuestion((long)questionId);
        return PollsQuestionPermission.contains(permissionChecker, question, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, PollsQuestion question, String actionId) {
        if (permissionChecker.hasOwnerPermission(question.getCompanyId(), PollsQuestion.class.getName(), question.getQuestionId(), question.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(question.getGroupId(), PollsQuestion.class.getName(), question.getQuestionId(), actionId);
    }
}

