/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.lar;

import com.liferay.documentlibrary.service.DLServiceUtil;
import com.liferay.portal.kernel.lar.BasePortletDataHandler;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataHandlerBoolean;
import com.liferay.portal.kernel.lar.PortletDataHandlerControl;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.persistence.UserUtil;
import com.liferay.portlet.messageboards.model.MBBan;
import com.liferay.portlet.messageboards.model.MBCategory;
import com.liferay.portlet.messageboards.model.MBCategoryConstants;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.model.MBMessageFlag;
import com.liferay.portlet.messageboards.model.MBThread;
import com.liferay.portlet.messageboards.service.MBBanLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBCategoryLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBMessageFlagLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBMessageLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBThreadLocalServiceUtil;
import com.liferay.portlet.messageboards.service.persistence.MBBanUtil;
import com.liferay.portlet.messageboards.service.persistence.MBCategoryUtil;
import com.liferay.portlet.messageboards.service.persistence.MBMessageFlagUtil;
import com.liferay.portlet.messageboards.service.persistence.MBMessageUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;

public class MBPortletDataHandlerImpl
extends BasePortletDataHandler {
    private static final String _NAMESPACE = "message_board";
    private static Log _log = LogFactoryUtil.getLog(MBPortletDataHandlerImpl.class);
    private static PortletDataHandlerBoolean _attachments = new PortletDataHandlerBoolean("message_board", "attachments");
    private static PortletDataHandlerBoolean _categoriesAndMessages = new PortletDataHandlerBoolean("message_board", "categories-and-messages", true, true);
    private static PortletDataHandlerBoolean _messageFlags = new PortletDataHandlerBoolean("message_board", "message-flags");
    private static PortletDataHandlerBoolean _ratings = new PortletDataHandlerBoolean("message_board", "ratings");
    private static PortletDataHandlerBoolean _tags = new PortletDataHandlerBoolean("message_board", "tags");
    private static PortletDataHandlerBoolean _userBans = new PortletDataHandlerBoolean("message_board", "user-bans");

    public PortletDataHandlerControl[] getExportControls() {
        return new PortletDataHandlerControl[]{_categoriesAndMessages, _attachments, _messageFlags, _userBans, _ratings, _tags};
    }

    public PortletDataHandlerControl[] getImportControls() {
        return new PortletDataHandlerControl[]{_categoriesAndMessages, _attachments, _messageFlags, _userBans, _ratings, _tags};
    }

    protected PortletPreferences doDeleteData(PortletDataContext context, String portletId, PortletPreferences preferences) throws Exception {
        if (!context.addPrimaryKey(MBPortletDataHandlerImpl.class, "deleteData")) {
            MBCategoryLocalServiceUtil.deleteCategories((long)context.getScopeGroupId());
            MBThreadLocalServiceUtil.deleteThreads((long)context.getScopeGroupId(), (long)MBCategoryConstants.DEFAULT_PARENT_CATEGORY_ID);
        }
        return null;
    }

    protected String doExportData(PortletDataContext context, String portletId, PortletPreferences preferences) throws Exception {
        context.addPermissions("com.liferay.portlet.messageboards", context.getScopeGroupId());
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("message-boards-data");
        rootElement.addAttribute("group-id", String.valueOf(context.getScopeGroupId()));
        Element categoriesElement = rootElement.addElement("categories");
        Element messagesElement = rootElement.addElement("messages");
        Element messageFlagsElement = rootElement.addElement("message-flags");
        Element userBansElement = rootElement.addElement("user-bans");
        List categories = MBCategoryUtil.findByGroupId((long)context.getScopeGroupId());
        for (MBCategory category : categories) {
            this.exportCategory(context, categoriesElement, messagesElement, messageFlagsElement, category);
        }
        List messages = MBMessageUtil.findByG_C((long)context.getScopeGroupId(), (long)MBCategoryConstants.DEFAULT_PARENT_CATEGORY_ID);
        for (MBMessage message : messages) {
            this.exportMessage(context, categoriesElement, messagesElement, messageFlagsElement, message);
        }
        if (context.getBooleanParameter(_NAMESPACE, "user-bans")) {
            List bans = MBBanUtil.findByGroupId((long)context.getScopeGroupId());
            for (MBBan ban : bans) {
                this.exportBan(context, userBansElement, ban);
            }
        }
        return document.formattedString();
    }

    protected PortletPreferences doImportData(PortletDataContext context, String portletId, PortletPreferences preferences, String data) throws Exception {
        String path;
        context.importPermissions("com.liferay.portlet.messageboards", context.getSourceGroupId(), context.getScopeGroupId());
        Document document = SAXReaderUtil.read((String)data);
        Element rootElement = document.getRootElement();
        Element categoriesElement = rootElement.element("categories");
        for (Element categoryElement : categoriesElement.elements("category")) {
            String path2 = categoryElement.attributeValue("path");
            if (!context.isPathNotProcessed(path2)) continue;
            MBCategory category = (MBCategory)context.getZipEntryAsObject(path2);
            this.importCategory(context, category);
        }
        Element messagesElement = rootElement.element("messages");
        for (Element messageElement : messagesElement.elements("message")) {
            String path3 = messageElement.attributeValue("path");
            if (!context.isPathNotProcessed(path3)) continue;
            MBMessage message = (MBMessage)context.getZipEntryAsObject(path3);
            this.importMessage(context, messageElement, message);
        }
        if (context.getBooleanParameter(_NAMESPACE, "message-flags")) {
            Element messageFlagsElement = rootElement.element("message-flags");
            for (Element messageFlagElement : messageFlagsElement.elements("message-flag")) {
                path = messageFlagElement.attributeValue("path");
                if (!context.isPathNotProcessed(path)) continue;
                MBMessageFlag flag = (MBMessageFlag)context.getZipEntryAsObject(path);
                this.importMessageFlag(context, flag);
            }
        }
        if (context.getBooleanParameter(_NAMESPACE, "user-bans")) {
            Element userBansElement = rootElement.element("user-bans");
            for (Element userBanElement : userBansElement.elements("user-ban")) {
                path = userBanElement.attributeValue("path");
                if (!context.isPathNotProcessed(path)) continue;
                MBBan ban = (MBBan)context.getZipEntryAsObject(path);
                this.importBan(context, ban);
            }
        }
        return null;
    }

    protected void exportBan(PortletDataContext context, Element userBansElement, MBBan ban) throws Exception {
        if (!context.isWithinDateRange(ban.getModifiedDate())) {
            return;
        }
        String path = this.getUserBanPath(context, ban);
        if (!context.isPathNotProcessed(path)) {
            return;
        }
        Element userBanElement = userBansElement.addElement("user-ban");
        userBanElement.addAttribute("path", path);
        ban.setBanUserUuid(ban.getBanUserUuid());
        ban.setUserUuid(ban.getUserUuid());
        context.addZipEntry(path, (Object)ban);
    }

    protected void exportCategory(PortletDataContext context, Element categoriesElement, Element messagesElement, Element messageFlagsElement, MBCategory category) throws Exception {
        if (context.isWithinDateRange(category.getModifiedDate())) {
            this.exportParentCategory(context, categoriesElement, category.getParentCategoryId());
            String path = this.getCategoryPath(context, category);
            if (context.isPathNotProcessed(path)) {
                Element categoryElement = categoriesElement.addElement("category");
                categoryElement.addAttribute("path", path);
                category.setUserUuid(category.getUserUuid());
                context.addPermissions(MBCategory.class, category.getCategoryId());
                context.addZipEntry(path, (Object)category);
            }
        }
        List messages = MBMessageUtil.findByG_C((long)category.getGroupId(), (long)category.getCategoryId());
        for (MBMessage message : messages) {
            this.exportMessage(context, categoriesElement, messagesElement, messageFlagsElement, message);
        }
    }

    protected void exportMessage(PortletDataContext context, Element categoriesElement, Element messagesElement, Element messageFlagsElement, MBMessage message) throws Exception {
        if (!context.isWithinDateRange(message.getModifiedDate())) {
            return;
        }
        if (message.getStatus() != 0) {
            return;
        }
        this.exportParentCategory(context, categoriesElement, message.getCategoryId());
        String path = this.getMessagePath(context, message);
        if (context.isPathNotProcessed(path)) {
            Element messageElement = messagesElement.addElement("message");
            messageElement.addAttribute("path", path);
            message.setUserUuid(message.getUserUuid());
            message.setPriority(message.getPriority());
            context.addPermissions(MBMessage.class, message.getMessageId());
            context.addLocks(MBThread.class, String.valueOf(message.getThreadId()));
            if (context.getBooleanParameter(_NAMESPACE, "ratings")) {
                context.addRatingsEntries(MBMessage.class, message.getMessageId());
            }
            if (context.getBooleanParameter(_NAMESPACE, "tags")) {
                context.addAssetTags(MBMessage.class, message.getMessageId());
            }
            if (context.getBooleanParameter(_NAMESPACE, "attachments") && message.isAttachments()) {
                String[] stringArray = message.getAttachmentsFiles();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String attachment = stringArray[n2];
                    int pos = attachment.lastIndexOf(47);
                    String name = attachment.substring(pos + 1);
                    String binPath = this.getMessageAttachementBinPath(context, message, name);
                    Element attachmentElement = messageElement.addElement("attachment");
                    attachmentElement.addAttribute("name", name);
                    attachmentElement.addAttribute("bin-path", binPath);
                    byte[] bytes = DLServiceUtil.getFile((long)context.getCompanyId(), (long)0L, (String)attachment);
                    context.addZipEntry(binPath, bytes);
                    ++n2;
                }
                message.setAttachmentsDir(message.getAttachmentsDir());
            }
            if (context.getBooleanParameter(_NAMESPACE, "message-flags")) {
                List messageFlags = MBMessageFlagUtil.findByMessageId((long)message.getMessageId());
                for (MBMessageFlag messageFlag : messageFlags) {
                    this.exportMessageFlag(context, messageFlagsElement, messageFlag);
                }
            }
            context.addZipEntry(path, (Object)message);
        }
    }

    protected void exportMessageFlag(PortletDataContext context, Element messageFlagsElement, MBMessageFlag messageFlag) throws Exception {
        String path = this.getMessageFlagPath(context, messageFlag);
        if (!context.isPathNotProcessed(path)) {
            return;
        }
        Element messageFlagElement = messageFlagsElement.addElement("message-flag");
        messageFlagElement.addAttribute("path", path);
        messageFlag.setUserUuid(messageFlag.getUserUuid());
        context.addZipEntry(path, (Object)messageFlag);
    }

    protected void exportParentCategory(PortletDataContext context, Element categoriesElement, long categoryId) throws Exception {
        if (!context.hasDateRange() || categoryId == MBCategoryConstants.DEFAULT_PARENT_CATEGORY_ID || categoryId == MBCategoryConstants.DISCUSSION_CATEGORY_ID) {
            return;
        }
        MBCategory category = MBCategoryUtil.findByPrimaryKey((long)categoryId);
        this.exportParentCategory(context, categoriesElement, category.getParentCategoryId());
        String path = this.getCategoryPath(context, category);
        if (context.isPathNotProcessed(path)) {
            Element categoryElement = categoriesElement.addElement("category");
            categoryElement.addAttribute("path", path);
            category.setUserUuid(category.getUserUuid());
            context.addPermissions(MBCategory.class, category.getCategoryId());
            context.addZipEntry(path, (Object)category);
        }
    }

    protected String getCategoryPath(PortletDataContext context, MBCategory category) {
        StringBundler sb = new StringBundler(4);
        sb.append(context.getPortletPath("19"));
        sb.append("/categories/");
        sb.append(category.getCategoryId());
        sb.append(".xml");
        return sb.toString();
    }

    protected String getImportCategoryPath(PortletDataContext context, long categoryId) {
        StringBundler sb = new StringBundler(4);
        sb.append(context.getSourcePortletPath("19"));
        sb.append("/categories/");
        sb.append(categoryId);
        sb.append(".xml");
        return sb.toString();
    }

    protected String getMessageAttachementBinPath(PortletDataContext context, MBMessage message, String attachment) {
        StringBundler sb = new StringBundler(5);
        sb.append(context.getPortletPath("19"));
        sb.append("/bin/");
        sb.append(message.getMessageId());
        sb.append("/");
        sb.append(PortalUUIDUtil.generate());
        return sb.toString();
    }

    protected String getMessageFlagPath(PortletDataContext context, MBMessageFlag messageFlag) {
        StringBundler sb = new StringBundler(4);
        sb.append(context.getPortletPath("19"));
        sb.append("/message-flags/");
        sb.append(messageFlag.getMessageFlagId());
        sb.append(".xml");
        return sb.toString();
    }

    protected String getMessagePath(PortletDataContext context, MBMessage message) {
        StringBundler sb = new StringBundler(4);
        sb.append(context.getPortletPath("19"));
        sb.append("/messages/");
        sb.append(message.getMessageId());
        sb.append(".xml");
        return sb.toString();
    }

    protected String getUserBanPath(PortletDataContext context, MBBan ban) {
        StringBundler sb = new StringBundler(4);
        sb.append(context.getPortletPath("19"));
        sb.append("/user-bans/");
        sb.append(ban.getBanId());
        sb.append(".xml");
        return sb.toString();
    }

    protected void importBan(PortletDataContext context, MBBan ban) throws Exception {
        long userId = context.getUserId(ban.getUserUuid());
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setCreateDate(ban.getCreateDate());
        serviceContext.setModifiedDate(ban.getModifiedDate());
        serviceContext.setScopeGroupId(context.getScopeGroupId());
        List users = UserUtil.findByUuid((String)ban.getBanUserUuid());
        Iterator itr = users.iterator();
        if (itr.hasNext()) {
            User user = (User)itr.next();
            MBBanLocalServiceUtil.addBan((long)userId, (long)user.getUserId(), (ServiceContext)serviceContext);
        } else {
            _log.error((Object)("Could not find banned user with uuid " + ban.getBanUserUuid()));
        }
    }

    protected void importCategory(PortletDataContext context, MBCategory category) throws Exception {
        long userId = context.getUserId(category.getUserUuid());
        Map categoryPKs = context.getNewPrimaryKeysMap(MBCategory.class);
        long parentCategoryId = MapUtil.getLong((Map)categoryPKs, (long)category.getParentCategoryId(), (long)category.getParentCategoryId());
        String emailAddress = null;
        String inProtocol = null;
        String inServerName = null;
        int inServerPort = 0;
        boolean inUseSSL = false;
        String inUserName = null;
        String inPassword = null;
        int inReadInterval = 0;
        String outEmailAddress = null;
        boolean outCustom = false;
        String outServerName = null;
        int outServerPort = 0;
        boolean outUseSSL = false;
        String outUserName = null;
        String outPassword = null;
        boolean mailingListActive = false;
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddCommunityPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setCreateDate(category.getCreateDate());
        serviceContext.setModifiedDate(category.getModifiedDate());
        serviceContext.setScopeGroupId(context.getScopeGroupId());
        if (parentCategoryId != MBCategoryConstants.DEFAULT_PARENT_CATEGORY_ID && parentCategoryId != MBCategoryConstants.DISCUSSION_CATEGORY_ID && parentCategoryId == category.getParentCategoryId()) {
            String path = this.getImportCategoryPath(context, parentCategoryId);
            MBCategory parentCategory = (MBCategory)context.getZipEntryAsObject(path);
            this.importCategory(context, parentCategory);
            parentCategoryId = MapUtil.getLong((Map)categoryPKs, (long)category.getParentCategoryId(), (long)category.getParentCategoryId());
        }
        MBCategory importedCategory = null;
        if (context.isDataStrategyMirror()) {
            MBCategory existingCategory = MBCategoryUtil.fetchByUUID_G((String)category.getUuid(), (long)context.getScopeGroupId());
            if (existingCategory == null) {
                serviceContext.setUuid(category.getUuid());
                importedCategory = MBCategoryLocalServiceUtil.addCategory((long)userId, (long)parentCategoryId, (String)category.getName(), (String)category.getDescription(), emailAddress, inProtocol, inServerName, (int)inServerPort, (boolean)inUseSSL, inUserName, inPassword, (int)inReadInterval, outEmailAddress, (boolean)outCustom, outServerName, (int)outServerPort, (boolean)outUseSSL, outUserName, outPassword, (boolean)mailingListActive, (ServiceContext)serviceContext);
            } else {
                importedCategory = MBCategoryLocalServiceUtil.updateCategory((long)existingCategory.getCategoryId(), (long)parentCategoryId, (String)category.getName(), (String)category.getDescription(), emailAddress, inProtocol, inServerName, (int)inServerPort, (boolean)inUseSSL, inUserName, inPassword, (int)inReadInterval, outEmailAddress, (boolean)outCustom, outServerName, (int)outServerPort, (boolean)outUseSSL, outUserName, outPassword, (boolean)mailingListActive, (boolean)false, (ServiceContext)serviceContext);
            }
        } else {
            importedCategory = MBCategoryLocalServiceUtil.addCategory((long)userId, (long)parentCategoryId, (String)category.getName(), (String)category.getDescription(), emailAddress, inProtocol, inServerName, (int)inServerPort, (boolean)inUseSSL, inUserName, inPassword, (int)inReadInterval, outEmailAddress, (boolean)outCustom, outServerName, (int)outServerPort, (boolean)outUseSSL, outUserName, outPassword, (boolean)mailingListActive, (ServiceContext)serviceContext);
        }
        categoryPKs.put(category.getCategoryId(), importedCategory.getCategoryId());
        context.importPermissions(MBCategory.class, category.getCategoryId(), importedCategory.getCategoryId());
    }

    protected void importMessage(PortletDataContext context, Element messageElement, MBMessage message) throws Exception {
        long userId = context.getUserId(message.getUserUuid());
        String userName = message.getUserName();
        Map categoryPKs = context.getNewPrimaryKeysMap(MBCategory.class);
        long categoryId = MapUtil.getLong((Map)categoryPKs, (long)message.getCategoryId(), (long)message.getCategoryId());
        Map threadPKs = context.getNewPrimaryKeysMap(MBThread.class);
        long threadId = MapUtil.getLong((Map)threadPKs, (long)message.getThreadId(), (long)message.getThreadId());
        Map messagePKs = context.getNewPrimaryKeysMap(MBMessage.class);
        long parentMessageId = MapUtil.getLong((Map)messagePKs, (long)message.getParentMessageId(), (long)message.getParentMessageId());
        ArrayList<ObjectValuePair> files = new ArrayList<ObjectValuePair>();
        ArrayList existingFiles = new ArrayList();
        if (context.getBooleanParameter(_NAMESPACE, "attachments") && message.isAttachments()) {
            List attachmentElements = messageElement.elements("attachment");
            for (Element attachmentElement : attachmentElements) {
                String name = attachmentElement.attributeValue("name");
                String binPath = attachmentElement.attributeValue("bin-path");
                byte[] bytes = context.getZipEntryAsByteArray(binPath);
                files.add(new ObjectValuePair((Object)name, (Object)bytes));
            }
            if (files.size() <= 0) {
                _log.error((Object)("Could not find attachments for message " + message.getMessageId()));
            }
        }
        String[] assetTagNames = null;
        if (context.getBooleanParameter(_NAMESPACE, "tags")) {
            assetTagNames = context.getAssetTagNames(MBMessage.class, message.getMessageId());
        }
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddCommunityPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setAssetTagNames(assetTagNames);
        serviceContext.setCreateDate(message.getCreateDate());
        serviceContext.setModifiedDate(message.getModifiedDate());
        serviceContext.setScopeGroupId(context.getScopeGroupId());
        if (message.getStatus() != 0) {
            serviceContext.setWorkflowAction(2);
        }
        if (categoryId != MBCategoryConstants.DEFAULT_PARENT_CATEGORY_ID && categoryId != MBCategoryConstants.DISCUSSION_CATEGORY_ID && categoryId == message.getCategoryId()) {
            String path = this.getImportCategoryPath(context, categoryId);
            MBCategory category = (MBCategory)context.getZipEntryAsObject(path);
            this.importCategory(context, category);
            categoryId = MapUtil.getLong((Map)categoryPKs, (long)message.getCategoryId(), (long)message.getCategoryId());
        }
        MBMessage importedMessage = null;
        if (context.isDataStrategyMirror()) {
            MBMessage existingMessage = MBMessageUtil.fetchByUUID_G((String)message.getUuid(), (long)context.getScopeGroupId());
            if (existingMessage == null) {
                serviceContext.setUuid(message.getUuid());
                importedMessage = MBMessageLocalServiceUtil.addMessage((long)userId, (String)userName, (long)context.getScopeGroupId(), (long)categoryId, (long)threadId, (long)parentMessageId, (String)message.getSubject(), (String)message.getBody(), files, (boolean)message.getAnonymous(), (double)message.getPriority(), (boolean)message.getAllowPingbacks(), (ServiceContext)serviceContext);
            } else {
                importedMessage = MBMessageLocalServiceUtil.updateMessage((long)userId, (long)existingMessage.getMessageId(), (String)message.getSubject(), (String)message.getBody(), files, existingFiles, (double)message.getPriority(), (boolean)message.getAllowPingbacks(), (ServiceContext)serviceContext);
            }
        } else {
            importedMessage = MBMessageLocalServiceUtil.addMessage((long)userId, (String)userName, (long)context.getScopeGroupId(), (long)categoryId, (long)threadId, (long)parentMessageId, (String)message.getSubject(), (String)message.getBody(), files, (boolean)message.getAnonymous(), (double)message.getPriority(), (boolean)message.getAllowPingbacks(), (ServiceContext)serviceContext);
        }
        threadPKs.put(message.getThreadId(), importedMessage.getThreadId());
        messagePKs.put(message.getMessageId(), importedMessage.getMessageId());
        context.importLocks(MBThread.class, String.valueOf(message.getThreadId()), String.valueOf(importedMessage.getThreadId()));
        context.importPermissions(MBMessage.class, message.getMessageId(), importedMessage.getMessageId());
        if (context.getBooleanParameter(_NAMESPACE, "ratings")) {
            context.importRatingsEntries(MBMessage.class, message.getMessageId(), importedMessage.getMessageId());
        }
    }

    protected void importMessageFlag(PortletDataContext context, MBMessageFlag flag) throws Exception {
        long userId = context.getUserId(flag.getUserUuid());
        Map messagePKs = context.getNewPrimaryKeysMap(MBMessage.class);
        long messageId = MapUtil.getLong((Map)messagePKs, (long)flag.getMessageId(), (long)flag.getMessageId());
        MBMessage message = MBMessageUtil.findByPrimaryKey((long)messageId);
        MBThread thread = message.getThread();
        MBMessageFlagLocalServiceUtil.addReadFlags((long)userId, (MBThread)thread);
    }
}

