/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.login.action;

import com.liferay.portal.NoSuchUserException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.FacebookConnectUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.PortletURLFactoryUtil;
import java.util.Locale;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class FacebookConnectAction
extends PortletAction {
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        long companyId = themeDisplay.getCompanyId();
        if (!FacebookConnectUtil.isEnabled(companyId)) {
            return;
        }
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        if (cmd.equals("add")) {
            this.addUser(actionRequest, actionResponse, themeDisplay);
        } else {
            String redirect = HttpUtil.addParameter((String)FacebookConnectUtil.getAuthURL(companyId), (String)"client_id", (String)FacebookConnectUtil.getAppId(companyId));
            redirect = HttpUtil.addParameter((String)redirect, (String)"redirect_uri", (String)FacebookConnectUtil.getRedirectURL(companyId));
            redirect = HttpUtil.addParameter((String)redirect, (String)"scope", (String)"email");
            actionResponse.sendRedirect(redirect);
        }
    }

    public ActionForward strutsExecute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
        long companyId = themeDisplay.getCompanyId();
        if (!FacebookConnectUtil.isEnabled(companyId)) {
            return null;
        }
        String code = ParamUtil.get((HttpServletRequest)request, (String)"code", (String)"");
        String token = this.getAccessToken(companyId, code);
        if (Validator.isNotNull((String)token)) {
            HttpSession session = request.getSession();
            session.setAttribute("FACEBOOK_ACCESS_TOKEN", (Object)token);
            this.setFacebookCredentials(session, companyId, token);
        }
        String redirect = this.getRedirect(request, themeDisplay);
        response.sendRedirect(redirect);
        return null;
    }

    protected void addUser(ActionRequest actionRequest, ActionResponse actionResponse, ThemeDisplay themeDisplay) throws Exception {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)actionRequest);
        request = PortalUtil.getOriginalServletRequest((HttpServletRequest)request);
        HttpSession session = request.getSession();
        String token = (String)session.getAttribute("FACEBOOK_ACCESS_TOKEN");
        long companyId = themeDisplay.getCompanyId();
        String url = HttpUtil.addParameter((String)(String.valueOf(FacebookConnectUtil.getGraphURL(companyId)) + "/me"), (String)"access_token", (String)token);
        url = HttpUtil.addParameter((String)url, (String)"fields", (String)"email,first_name,last_name,birthday,gender,verified");
        Http.Options options = new Http.Options();
        options.setLocation(url);
        String content = HttpUtil.URLtoString((Http.Options)options);
        if (Validator.isNull((String)content)) {
            return;
        }
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)content);
        if (!jsonObject.getBoolean("verified")) {
            return;
        }
        long creatorUserId = 0L;
        boolean autoPassword = true;
        String password1 = "";
        String password2 = "";
        boolean autoScreenName = true;
        String screenName = "";
        String emailAddress = jsonObject.getString("email");
        long facebookId = jsonObject.getLong("id");
        String openId = "";
        Locale locale = LocaleUtil.getDefault();
        String firstName = jsonObject.getString("first_name");
        String middleName = "";
        String lastName = jsonObject.getString("last_name");
        int prefixId = 0;
        int suffixId = 0;
        boolean male = Validator.equals((Object)jsonObject.getString("gender"), (Object)"male");
        int birthdayMonth = 0;
        int birthdayDay = 1;
        int birthdayYear = 1970;
        String jobTitle = "";
        long[] groupIds = null;
        long[] organizationIds = null;
        long[] roleIds = null;
        long[] userGroupIds = null;
        boolean sendEmail = true;
        ServiceContext serviceContext = new ServiceContext();
        UserLocalServiceUtil.addUser((long)creatorUserId, (long)companyId, (boolean)autoPassword, (String)password1, (String)password2, (boolean)autoScreenName, (String)screenName, (String)emailAddress, (long)facebookId, (String)openId, (Locale)locale, (String)firstName, (String)middleName, (String)lastName, (int)prefixId, (int)suffixId, (boolean)male, (int)birthdayMonth, (int)birthdayDay, (int)birthdayYear, (String)jobTitle, (long[])groupIds, (long[])organizationIds, (long[])roleIds, (long[])userGroupIds, (boolean)sendEmail, (ServiceContext)serviceContext);
        session.setAttribute("FACEBOOK_USER_EMAIL_ADDRESS", (Object)emailAddress);
        String redirect = themeDisplay.getPathContext();
        if (Validator.isNull((String)redirect)) {
            redirect = "/";
        }
        actionResponse.sendRedirect(redirect);
    }

    protected String getAccessToken(long companyId, String code) throws Exception {
        int x;
        String url = HttpUtil.addParameter((String)FacebookConnectUtil.getAccessTokenURL(companyId), (String)"client_id", (String)FacebookConnectUtil.getAppId(companyId));
        url = HttpUtil.addParameter((String)url, (String)"redirect_uri", (String)FacebookConnectUtil.getRedirectURL(companyId));
        url = HttpUtil.addParameter((String)url, (String)"client_secret", (String)FacebookConnectUtil.getAppSecret(companyId));
        url = HttpUtil.addParameter((String)url, (String)"code", (String)code);
        Http.Options options = new Http.Options();
        options.setLocation(url);
        options.setPost(true);
        String content = HttpUtil.URLtoString((Http.Options)options);
        if (Validator.isNotNull((String)content) && (x = content.indexOf("access_token=")) >= 0) {
            int y = content.indexOf(38, x);
            if (y < x) {
                y = content.length();
            }
            return content.substring(x + 13, y);
        }
        return null;
    }

    protected void getFacebookCredentials(HttpSession session, long companyId, String token) throws Exception {
        JSONObject jsonObject = FacebookConnectUtil.getGraphResources(companyId, "/me", token, "id,email,verified");
        if (jsonObject != null && jsonObject.getBoolean("verified")) {
            String emailAddress;
            String facebookId = jsonObject.getString("id");
            if (Validator.isNotNull((String)facebookId)) {
                session.setAttribute("FACEBOOK_USER_ID", (Object)facebookId);
            }
            if (Validator.isNotNull((String)(emailAddress = jsonObject.getString("email")))) {
                try {
                    UserLocalServiceUtil.getUserByEmailAddress((long)companyId, (String)emailAddress);
                    session.setAttribute("FACEBOOK_USER_EMAIL_ADDRESS", (Object)emailAddress);
                }
                catch (NoSuchUserException noSuchUserException) {
                    session.removeAttribute("FACEBOOK_USER_EMAIL_ADDRESS");
                }
            }
        }
    }

    protected String getRedirect(HttpServletRequest request, ThemeDisplay themeDisplay) throws Exception {
        HttpSession session = request.getSession();
        if (session.getAttribute("FACEBOOK_ACCESS_TOKEN") != null && session.getAttribute("FACEBOOK_USER_EMAIL_ADDRESS") != null) {
            return themeDisplay.getPathContext();
        }
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create((HttpServletRequest)request, (String)"58", (long)themeDisplay.getPlid(), (String)"RENDER_PHASE");
        portletURL.setWindowState(WindowState.MAXIMIZED);
        portletURL.setPortletMode(PortletMode.VIEW);
        portletURL.setParameter("struts_action", "/login/facebook_connect_add_user");
        return portletURL.toString();
    }

    protected void setFacebookCredentials(HttpSession session, long companyId, String token) throws Exception {
        String emailAddress;
        String url = HttpUtil.addParameter((String)(String.valueOf(FacebookConnectUtil.getGraphURL(companyId)) + "/me"), (String)"access_token", (String)token);
        url = HttpUtil.addParameter((String)url, (String)"fields", (String)"email,id,verified");
        Http.Options options = new Http.Options();
        options.setLocation(url);
        String content = HttpUtil.URLtoString((Http.Options)options);
        if (Validator.isNull((String)content)) {
            return;
        }
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)content);
        if (!jsonObject.getBoolean("verified")) {
            return;
        }
        String facebookId = jsonObject.getString("id");
        if (Validator.isNotNull((String)facebookId)) {
            session.setAttribute("FACEBOOK_USER_ID", (Object)facebookId);
        }
        if (Validator.isNotNull((String)(emailAddress = jsonObject.getString("email")))) {
            try {
                UserLocalServiceUtil.getUserByEmailAddress((long)companyId, (String)emailAddress);
                session.setAttribute("FACEBOOK_USER_EMAIL_ADDRESS", (Object)emailAddress);
            }
            catch (NoSuchUserException noSuchUserException) {
                session.removeAttribute("FACEBOOK_USER_EMAIL_ADDRESS");
            }
        }
    }
}

