/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.layoutconfiguration.util.velocity;

import com.liferay.portal.model.Portlet;
import com.liferay.portal.util.comparator.PortletRenderWeightComparator;
import com.liferay.portlet.layoutconfiguration.util.velocity.PortletColumnLogic;
import com.liferay.portlet.layoutconfiguration.util.velocity.PortletLogic;
import com.liferay.portlet.layoutconfiguration.util.velocity.RuntimeLogic;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateProcessor {
    private ServletContext _servletContext;
    private HttpServletRequest _request;
    private HttpServletResponse _response;
    private String _portletId;
    private Map<Portlet, Object[]> _portletsMap;

    public TemplateProcessor(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, String portletId) {
        this._servletContext = servletContext;
        this._request = request;
        this._response = response;
        this._portletId = portletId;
        this._portletsMap = new TreeMap<Portlet, Object[]>((Comparator<Portlet>)new PortletRenderWeightComparator());
    }

    public String processColumn(String columnId) throws Exception {
        return this.processColumn(columnId, "");
    }

    public String processColumn(String columnId, String classNames) throws Exception {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("id", columnId);
        attributes.put("classNames", classNames);
        PortletColumnLogic logic = new PortletColumnLogic(this._servletContext, this._request, this._response);
        String content = logic.processContent(attributes);
        this._portletsMap.putAll(logic.getPortletsMap());
        return content;
    }

    public String processMax() throws Exception {
        return this.processMax("");
    }

    public String processMax(String classNames) throws Exception {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("classNames", classNames);
        PortletLogic logic = new PortletLogic(this._servletContext, this._request, this._response, this._portletId);
        return ((RuntimeLogic)logic).processContent(attributes);
    }

    public String processPortlet(String portletId) throws Exception {
        try {
            this._request.setAttribute("RENDER_PORTLET_RESOURCE", (Object)Boolean.TRUE);
            PortletLogic logic = new PortletLogic(this._servletContext, this._request, this._response, portletId);
            String string = ((RuntimeLogic)logic).processContent(new HashMap<String, String>());
            return string;
        }
        finally {
            this._request.removeAttribute("RENDER_PORTLET_RESOURCE");
        }
    }

    public Map<Portlet, Object[]> getPortletsMap() {
        return this._portletsMap;
    }
}

