/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.service.persistence;

import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portlet.journal.model.JournalTemplate;
import com.liferay.portlet.journal.model.impl.JournalTemplateImpl;
import com.liferay.portlet.journal.service.persistence.JournalTemplateFinder;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JournalTemplateFinderImpl
extends BasePersistenceImpl<JournalTemplate>
implements JournalTemplateFinder {
    public static String COUNT_BY_C_G_T_S_N_D = String.valueOf(JournalTemplateFinder.class.getName()) + ".countByC_G_T_S_N_D";
    public static String FIND_BY_C_G_T_S_N_D = String.valueOf(JournalTemplateFinder.class.getName()) + ".findByC_G_T_S_N_D";

    public int countByKeywords(long companyId, long groupId, String keywords, String structureId, String structureIdComparator) throws SystemException {
        String[] templateIds = null;
        String[] names = null;
        String[] descriptions = null;
        boolean andOperator = false;
        if (Validator.isNotNull((String)keywords)) {
            templateIds = CustomSQLUtil.keywords((String)keywords, (boolean)false);
            names = CustomSQLUtil.keywords((String)keywords);
            descriptions = CustomSQLUtil.keywords((String)keywords);
        } else {
            andOperator = true;
        }
        return this.countByC_G_T_S_N_D(companyId, groupId, templateIds, structureId, structureIdComparator, names, descriptions, andOperator);
    }

    public int countByC_G_T_S_N_D(long companyId, long groupId, String templateId, String structureId, String structureIdComparator, String name, String description, boolean andOperator) throws SystemException {
        return this.countByC_G_T_S_N_D(companyId, groupId, new String[]{templateId}, structureId, structureIdComparator, new String[]{name}, new String[]{description}, andOperator);
    }

    public int countByC_G_T_S_N_D(long companyId, long groupId, String[] templateIds, String structureId, String structureIdComparator, String[] names, String[] descriptions, boolean andOperator) throws SystemException {
        templateIds = CustomSQLUtil.keywords((String[])templateIds, (boolean)false);
        names = CustomSQLUtil.keywords((String[])names);
        descriptions = CustomSQLUtil.keywords((String[])descriptions);
        Session session = null;
        try {
            Long count;
            Iterator itr;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_C_G_T_S_N_D);
            if (groupId <= 0L) {
                sql = StringUtil.replace((String)sql, (String)"(groupId = ?) AND", (String)"");
            }
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"templateId", (String)"LIKE", (boolean)false, (String[])templateIds);
            if (structureIdComparator.equals("!=")) {
                sql = this.replaceStructureIdComparator(sql);
            }
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(name)", (String)"LIKE", (boolean)false, (String[])names);
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(description)", (String)"LIKE", (boolean)true, (String[])descriptions);
            sql = CustomSQLUtil.replaceAndOperator((String)sql, (boolean)andOperator);
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(companyId);
            if (groupId > 0L) {
                qPos.add(groupId);
            }
            qPos.add(templateIds, 2);
            if (structureIdComparator.equals("=")) {
                qPos.add(structureId);
                qPos.add(structureId);
            }
            qPos.add(names, 2);
            qPos.add(descriptions, 2);
            if (structureIdComparator.equals("!=") && !CustomSQLUtil.isVendorOracle()) {
                qPos.add(structureId);
            }
            if ((itr = q.list().iterator()).hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            return 0;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<JournalTemplate> findByKeywords(long companyId, long groupId, String keywords, String structureId, String structureIdComparator, int start, int end, OrderByComparator obc) throws SystemException {
        String[] templateIds = null;
        String[] names = null;
        String[] descriptions = null;
        boolean andOperator = false;
        if (Validator.isNotNull((String)keywords)) {
            templateIds = CustomSQLUtil.keywords((String)keywords, (boolean)false);
            names = CustomSQLUtil.keywords((String)keywords);
            descriptions = CustomSQLUtil.keywords((String)keywords);
        } else {
            andOperator = true;
        }
        return this.findByC_G_T_S_N_D(companyId, groupId, templateIds, structureId, structureIdComparator, names, descriptions, andOperator, start, end, obc);
    }

    public List<JournalTemplate> findByC_G_T_S_N_D(long companyId, long groupId, String templateId, String structureId, String structureIdComparator, String name, String description, boolean andOperator, int start, int end, OrderByComparator obc) throws SystemException {
        return this.findByC_G_T_S_N_D(companyId, groupId, new String[]{templateId}, structureId, structureIdComparator, new String[]{name}, new String[]{description}, andOperator, start, end, obc);
    }

    public List<JournalTemplate> findByC_G_T_S_N_D(long companyId, long groupId, String[] templateIds, String structureId, String structureIdComparator, String[] names, String[] descriptions, boolean andOperator, int start, int end, OrderByComparator obc) throws SystemException {
        templateIds = CustomSQLUtil.keywords((String[])templateIds, (boolean)false);
        names = CustomSQLUtil.keywords((String[])names);
        descriptions = CustomSQLUtil.keywords((String[])descriptions);
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_C_G_T_S_N_D);
            if (groupId <= 0L) {
                sql = StringUtil.replace((String)sql, (String)"(groupId = ?) AND", (String)"");
            }
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"templateId", (String)"LIKE", (boolean)false, (String[])templateIds);
            if (structureIdComparator.equals("!=")) {
                sql = this.replaceStructureIdComparator(sql);
            }
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(name)", (String)"LIKE", (boolean)false, (String[])names);
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(description)", (String)"LIKE", (boolean)true, (String[])descriptions);
            sql = CustomSQLUtil.replaceAndOperator((String)sql, (boolean)andOperator);
            sql = CustomSQLUtil.replaceOrderBy((String)sql, (OrderByComparator)obc);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("JournalTemplate", JournalTemplateImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(companyId);
            if (groupId > 0L) {
                qPos.add(groupId);
            }
            qPos.add(templateIds, 2);
            if (structureIdComparator.equals("=")) {
                qPos.add(structureId);
                qPos.add(structureId);
            }
            qPos.add(names, 2);
            qPos.add(descriptions, 2);
            if (structureIdComparator.equals("!=") && !CustomSQLUtil.isVendorOracle()) {
                qPos.add(structureId);
            }
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected String replaceStructureIdComparator(String sql) {
        String insertSQL = "structureId != ? AND structureId IS NOT NULL";
        if (CustomSQLUtil.isVendorOracle()) {
            insertSQL = "structureId IS NOT NULL";
        }
        insertSQL = " AND (" + insertSQL + ") ";
        String removeSQL = "(structureId = ? [$AND_OR_NULL_CHECK$]) [$AND_OR_CONNECTOR$]";
        int pos = (sql = StringUtil.replace((String)sql, (String)removeSQL, (String)"")).indexOf("ORDER BY");
        sql = pos == -1 ? String.valueOf(sql) + insertSQL : StringUtil.insert((String)sql, (String)insertSQL, (int)pos);
        return sql;
    }
}

