/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Image;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.journal.DuplicateTemplateIdException;
import com.liferay.portlet.journal.NoSuchTemplateException;
import com.liferay.portlet.journal.RequiredTemplateException;
import com.liferay.portlet.journal.TemplateDescriptionException;
import com.liferay.portlet.journal.TemplateIdException;
import com.liferay.portlet.journal.TemplateNameException;
import com.liferay.portlet.journal.TemplateSmallImageNameException;
import com.liferay.portlet.journal.TemplateSmallImageSizeException;
import com.liferay.portlet.journal.TemplateXslException;
import com.liferay.portlet.journal.model.JournalTemplate;
import com.liferay.portlet.journal.service.base.JournalTemplateLocalServiceBaseImpl;
import com.liferay.portlet.journal.util.JournalUtil;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JournalTemplateLocalServiceImpl
extends JournalTemplateLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(JournalTemplateLocalServiceImpl.class);

    public JournalTemplate addTemplate(long userId, long groupId, String templateId, boolean autoTemplateId, String structureId, String name, String description, String xsl, boolean formatXsl, String langType, boolean cacheable, boolean smallImage, String smallImageURL, File smallFile, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        templateId = templateId.trim().toUpperCase();
        Date now = new Date();
        try {
            if (formatXsl) {
                xsl = langType.equals("vm") ? JournalUtil.formatVM(xsl) : JournalUtil.formatXML(xsl);
            }
        }
        catch (Exception exception) {
            throw new TemplateXslException();
        }
        byte[] smallBytes = null;
        try {
            smallBytes = FileUtil.getBytes((File)smallFile);
        }
        catch (IOException iOException) {}
        this.validate(groupId, templateId, autoTemplateId, name, description, xsl, smallImage, smallImageURL, smallFile, smallBytes);
        if (autoTemplateId) {
            templateId = String.valueOf(this.counterLocalService.increment());
        }
        long id = this.counterLocalService.increment();
        JournalTemplate template = this.journalTemplatePersistence.create(id);
        template.setUuid(serviceContext.getUuid());
        template.setGroupId(groupId);
        template.setCompanyId(user.getCompanyId());
        template.setUserId(user.getUserId());
        template.setUserName(user.getFullName());
        template.setCreateDate(serviceContext.getCreateDate(now));
        template.setModifiedDate(serviceContext.getModifiedDate(now));
        template.setTemplateId(templateId);
        template.setStructureId(structureId);
        template.setName(name);
        template.setDescription(description);
        template.setXsl(xsl);
        template.setLangType(langType);
        template.setCacheable(cacheable);
        template.setSmallImage(smallImage);
        template.setSmallImageId(this.counterLocalService.increment());
        template.setSmallImageURL(smallImageURL);
        this.journalTemplatePersistence.update((BaseModel)template, false);
        if (serviceContext.getAddCommunityPermissions() || serviceContext.getAddGuestPermissions()) {
            this.addTemplateResources(template, serviceContext.getAddCommunityPermissions(), serviceContext.getAddGuestPermissions());
        } else {
            this.addTemplateResources(template, serviceContext.getCommunityPermissions(), serviceContext.getGuestPermissions());
        }
        ExpandoBridge expandoBridge = template.getExpandoBridge();
        expandoBridge.setAttributes(serviceContext);
        this.saveImages(smallImage, template.getSmallImageId(), smallFile, smallBytes);
        return template;
    }

    public void addTemplateResources(long groupId, String templateId, boolean addCommunityPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        JournalTemplate template = this.journalTemplatePersistence.findByG_T(groupId, templateId);
        this.addTemplateResources(template, addCommunityPermissions, addGuestPermissions);
    }

    public void addTemplateResources(JournalTemplate template, boolean addCommunityPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addResources(template.getCompanyId(), template.getGroupId(), template.getUserId(), JournalTemplate.class.getName(), template.getId(), false, addCommunityPermissions, addGuestPermissions);
    }

    public void addTemplateResources(long groupId, String templateId, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        JournalTemplate template = this.journalTemplatePersistence.findByG_T(groupId, templateId);
        this.addTemplateResources(template, communityPermissions, guestPermissions);
    }

    public void addTemplateResources(JournalTemplate template, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addModelResources(template.getCompanyId(), template.getGroupId(), template.getUserId(), JournalTemplate.class.getName(), template.getId(), communityPermissions, guestPermissions);
    }

    public void checkNewLine(long groupId, String templateId) throws PortalException, SystemException {
        JournalTemplate template = this.journalTemplatePersistence.findByG_T(groupId, templateId);
        String xsl = template.getXsl();
        if (xsl != null && xsl.indexOf("\\n") != -1) {
            xsl = StringUtil.replace((String)xsl, (String[])new String[]{"\\n", "\\r"}, (String[])new String[]{"\n", "\r"});
            template.setXsl(xsl);
            this.journalTemplatePersistence.update((BaseModel)template, false);
        }
    }

    public JournalTemplate copyTemplate(long userId, long groupId, String oldTemplateId, String newTemplateId, boolean autoTemplateId) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        oldTemplateId = oldTemplateId.trim().toUpperCase();
        newTemplateId = newTemplateId.trim().toUpperCase();
        Date now = new Date();
        JournalTemplate oldTemplate = this.journalTemplatePersistence.findByG_T(groupId, oldTemplateId);
        if (autoTemplateId) {
            newTemplateId = String.valueOf(this.counterLocalService.increment());
        } else {
            this.validate(newTemplateId);
            JournalTemplate newTemplate = this.journalTemplatePersistence.fetchByG_T(groupId, newTemplateId);
            if (newTemplate != null) {
                throw new DuplicateTemplateIdException();
            }
        }
        long id = this.counterLocalService.increment();
        JournalTemplate newTemplate = this.journalTemplatePersistence.create(id);
        newTemplate.setGroupId(groupId);
        newTemplate.setCompanyId(user.getCompanyId());
        newTemplate.setUserId(user.getUserId());
        newTemplate.setUserName(user.getFullName());
        newTemplate.setCreateDate(now);
        newTemplate.setModifiedDate(now);
        newTemplate.setTemplateId(newTemplateId);
        newTemplate.setStructureId(oldTemplate.getStructureId());
        newTemplate.setName(oldTemplate.getName());
        newTemplate.setDescription(oldTemplate.getDescription());
        newTemplate.setXsl(oldTemplate.getXsl());
        newTemplate.setLangType(oldTemplate.getLangType());
        newTemplate.setCacheable(oldTemplate.isCacheable());
        newTemplate.setSmallImage(oldTemplate.isSmallImage());
        newTemplate.setSmallImageId(this.counterLocalService.increment());
        newTemplate.setSmallImageURL(oldTemplate.getSmallImageURL());
        this.journalTemplatePersistence.update((BaseModel)newTemplate, false);
        if (oldTemplate.getSmallImage()) {
            Image image = this.imageLocalService.getImage(oldTemplate.getSmallImageId());
            byte[] smallBytes = image.getTextObj();
            this.imageLocalService.updateImage(newTemplate.getSmallImageId(), smallBytes);
        }
        this.addTemplateResources(newTemplate, true, true);
        return newTemplate;
    }

    public void deleteTemplate(long groupId, String templateId) throws PortalException, SystemException {
        templateId = templateId.trim().toUpperCase();
        JournalTemplate template = this.journalTemplatePersistence.findByG_T(groupId, templateId);
        this.deleteTemplate(template);
    }

    public void deleteTemplate(JournalTemplate template) throws PortalException, SystemException {
        if (this.journalArticlePersistence.countByG_T(template.getGroupId(), template.getTemplateId()) > 0) {
            throw new RequiredTemplateException();
        }
        this.webDAVPropsLocalService.deleteWebDAVProps(JournalTemplate.class.getName(), template.getId());
        this.imageLocalService.deleteImage(template.getSmallImageId());
        this.expandoValueLocalService.deleteValues(JournalTemplate.class.getName(), template.getId());
        this.resourceLocalService.deleteResource(template.getCompanyId(), JournalTemplate.class.getName(), 4, template.getId());
        this.journalTemplatePersistence.remove((BaseModel)template);
    }

    public void deleteTemplates(long groupId) throws PortalException, SystemException {
        for (JournalTemplate template : this.journalTemplatePersistence.findByGroupId(groupId)) {
            this.deleteTemplate(template);
        }
    }

    public List<JournalTemplate> getStructureTemplates(long groupId, String structureId) throws SystemException {
        return this.journalTemplatePersistence.findByG_S(groupId, structureId);
    }

    public List<JournalTemplate> getStructureTemplates(long groupId, String structureId, int start, int end) throws SystemException {
        return this.journalTemplatePersistence.findByG_S(groupId, structureId, start, end);
    }

    public int getStructureTemplatesCount(long groupId, String structureId) throws SystemException {
        return this.journalTemplatePersistence.countByG_S(groupId, structureId);
    }

    public JournalTemplate getTemplate(long id) throws PortalException, SystemException {
        return this.journalTemplatePersistence.findByPrimaryKey(id);
    }

    public JournalTemplate getTemplate(long groupId, String templateId) throws PortalException, SystemException {
        templateId = GetterUtil.getString((String)templateId).toUpperCase();
        if (groupId == 0L) {
            _log.error((Object)("No group id was passed for " + templateId + ". Group id is " + "required since 4.2.0. Please update all custom code and " + "data that references templates without a group id."));
            List templates = this.journalTemplatePersistence.findByTemplateId(templateId);
            if (templates.size() == 0) {
                throw new NoSuchTemplateException("No JournalTemplate exists with the template id " + templateId);
            }
            return (JournalTemplate)templates.get(0);
        }
        return this.journalTemplatePersistence.findByG_T(groupId, templateId);
    }

    public JournalTemplate getTemplateBySmallImageId(long smallImageId) throws PortalException, SystemException {
        return this.journalTemplatePersistence.findBySmallImageId(smallImageId);
    }

    public List<JournalTemplate> getTemplates() throws SystemException {
        return this.journalTemplatePersistence.findAll();
    }

    public List<JournalTemplate> getTemplates(long groupId) throws SystemException {
        return this.journalTemplatePersistence.findByGroupId(groupId);
    }

    public List<JournalTemplate> getTemplates(long groupId, int start, int end) throws SystemException {
        return this.journalTemplatePersistence.findByGroupId(groupId, start, end);
    }

    public int getTemplatesCount(long groupId) throws SystemException {
        return this.journalTemplatePersistence.countByGroupId(groupId);
    }

    public boolean hasTemplate(long groupId, String templateId) throws SystemException {
        try {
            this.getTemplate(groupId, templateId);
            return true;
        }
        catch (PortalException portalException) {
            return false;
        }
    }

    public List<JournalTemplate> search(long companyId, long groupId, String keywords, String structureId, String structureIdComparator, int start, int end, OrderByComparator obc) throws SystemException {
        return this.journalTemplateFinder.findByKeywords(companyId, groupId, keywords, structureId, structureIdComparator, start, end, obc);
    }

    public List<JournalTemplate> search(long companyId, long groupId, String templateId, String structureId, String structureIdComparator, String name, String description, boolean andOperator, int start, int end, OrderByComparator obc) throws SystemException {
        return this.journalTemplateFinder.findByC_G_T_S_N_D(companyId, groupId, templateId, structureId, structureIdComparator, name, description, andOperator, start, end, obc);
    }

    public int searchCount(long companyId, long groupId, String keywords, String structureId, String structureIdComparator) throws SystemException {
        return this.journalTemplateFinder.countByKeywords(companyId, groupId, keywords, structureId, structureIdComparator);
    }

    public int searchCount(long companyId, long groupId, String templateId, String structureId, String structureIdComparator, String name, String description, boolean andOperator) throws SystemException {
        return this.journalTemplateFinder.countByC_G_T_S_N_D(companyId, groupId, templateId, structureId, structureIdComparator, name, description, andOperator);
    }

    public JournalTemplate updateTemplate(long groupId, String templateId, String structureId, String name, String description, String xsl, boolean formatXsl, String langType, boolean cacheable, boolean smallImage, String smallImageURL, File smallFile, ServiceContext serviceContext) throws PortalException, SystemException {
        templateId = templateId.trim().toUpperCase();
        try {
            if (formatXsl) {
                xsl = langType.equals("vm") ? JournalUtil.formatVM(xsl) : JournalUtil.formatXML(xsl);
            }
        }
        catch (Exception exception) {
            throw new TemplateXslException();
        }
        byte[] smallBytes = null;
        try {
            smallBytes = FileUtil.getBytes((File)smallFile);
        }
        catch (IOException iOException) {}
        this.validate(name, description, xsl, smallImage, smallImageURL, smallFile, smallBytes);
        JournalTemplate template = this.journalTemplatePersistence.findByG_T(groupId, templateId);
        template.setModifiedDate(new Date());
        if (Validator.isNull((String)template.getStructureId()) && Validator.isNotNull((String)structureId)) {
            template.setStructureId(structureId);
        }
        template.setName(name);
        template.setDescription(description);
        template.setXsl(xsl);
        template.setLangType(langType);
        template.setCacheable(cacheable);
        template.setSmallImage(smallImage);
        template.setSmallImageURL(smallImageURL);
        template.setModifiedDate(serviceContext.getModifiedDate(null));
        this.journalTemplatePersistence.update((BaseModel)template, false);
        ExpandoBridge expandoBridge = template.getExpandoBridge();
        expandoBridge.setAttributes(serviceContext);
        this.saveImages(smallImage, template.getSmallImageId(), smallFile, smallBytes);
        return template;
    }

    protected void saveImages(boolean smallImage, long smallImageId, File smallFile, byte[] smallBytes) throws PortalException, SystemException {
        if (smallImage) {
            if (smallFile != null && smallBytes != null) {
                this.imageLocalService.updateImage(smallImageId, smallBytes);
            }
        } else {
            this.imageLocalService.deleteImage(smallImageId);
        }
    }

    protected void validate(String templateId) throws PortalException {
        if (Validator.isNull((String)templateId) || Validator.isNumber((String)templateId) || templateId.indexOf(32) != -1) {
            throw new TemplateIdException();
        }
    }

    protected void validate(long groupId, String templateId, boolean autoTemplateId, String name, String description, String xsl, boolean smallImage, String smallImageURL, File smallFile, byte[] smallBytes) throws PortalException, SystemException {
        if (!autoTemplateId) {
            this.validate(templateId);
            JournalTemplate template = this.journalTemplatePersistence.fetchByG_T(groupId, templateId);
            if (template != null) {
                throw new DuplicateTemplateIdException();
            }
        }
        this.validate(name, description, xsl, smallImage, smallImageURL, smallFile, smallBytes);
    }

    protected void validate(String name, String description, String xsl, boolean smallImage, String smallImageURL, File smallFile, byte[] smallBytes) throws PortalException, SystemException {
        if (Validator.isNull((String)name)) {
            throw new TemplateNameException();
        }
        if (Validator.isNull((String)description)) {
            throw new TemplateDescriptionException();
        }
        if (Validator.isNull((String)xsl)) {
            throw new TemplateXslException();
        }
        String[] imageExtensions = PrefsPropsUtil.getStringArray("journal.image.extensions", ",");
        if (smallImage && Validator.isNull((String)smallImageURL) && smallFile != null && smallBytes != null) {
            long smallImageMaxSize;
            String smallImageName = smallFile.getName();
            if (smallImageName != null) {
                boolean validSmallImageExtension = false;
                int i = 0;
                while (i < imageExtensions.length) {
                    if ("*".equals(imageExtensions[i]) || StringUtil.endsWith((String)smallImageName, (String)imageExtensions[i])) {
                        validSmallImageExtension = true;
                        break;
                    }
                    ++i;
                }
                if (!validSmallImageExtension) {
                    throw new TemplateSmallImageNameException(smallImageName);
                }
            }
            if ((smallImageMaxSize = PrefsPropsUtil.getLong("journal.image.small.max.size")) > 0L && (smallBytes == null || (long)smallBytes.length > smallImageMaxSize)) {
                throw new TemplateSmallImageSizeException();
            }
        }
    }
}

