/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.imagegallery.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.security.auth.HttpPrincipal;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.http.TunnelUtil;
import com.liferay.portlet.imagegallery.model.IGImage;
import com.liferay.portlet.imagegallery.service.IGImageServiceUtil;
import java.io.File;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IGImageServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(IGImageServiceHttp.class);

    public static IGImage addImage(HttpPrincipal httpPrincipal, long groupId, long folderId, String name, String description, File file, String contentType, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(IGImageServiceUtil.class.getName(), "addImage", new Class[]{Long.TYPE, Long.TYPE, String.class, String.class, File.class, String.class, ServiceContext.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, folderId, name, description, file, contentType, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (IGImage)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void deleteImage(HttpPrincipal httpPrincipal, long imageId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(IGImageServiceUtil.class.getName(), "deleteImage", new Class[]{Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{imageId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void deleteImageByFolderIdAndNameWithExtension(HttpPrincipal httpPrincipal, long groupId, long folderId, String nameWithExtension) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(IGImageServiceUtil.class.getName(), "deleteImageByFolderIdAndNameWithExtension", new Class[]{Long.TYPE, Long.TYPE, String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, folderId, nameWithExtension});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<IGImage> getGroupImages(HttpPrincipal httpPrincipal, long groupId, long userId, int start, int end) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(IGImageServiceUtil.class.getName(), "getGroupImages", new Class[]{Long.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, userId, start, end});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static int getGroupImagesCount(HttpPrincipal httpPrincipal, long groupId, long userId) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(IGImageServiceUtil.class.getName(), "getGroupImagesCount", new Class[]{Long.TYPE, Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, userId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Integer)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static IGImage getImage(HttpPrincipal httpPrincipal, long imageId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(IGImageServiceUtil.class.getName(), "getImage", new Class[]{Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{imageId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (IGImage)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static IGImage getImageByFolderIdAndNameWithExtension(HttpPrincipal httpPrincipal, long groupId, long folderId, String nameWithExtension) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(IGImageServiceUtil.class.getName(), "getImageByFolderIdAndNameWithExtension", new Class[]{Long.TYPE, Long.TYPE, String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, folderId, nameWithExtension});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (IGImage)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static IGImage getImageByLargeImageId(HttpPrincipal httpPrincipal, long largeImageId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(IGImageServiceUtil.class.getName(), "getImageByLargeImageId", new Class[]{Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{largeImageId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (IGImage)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static IGImage getImageBySmallImageId(HttpPrincipal httpPrincipal, long smallImageId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(IGImageServiceUtil.class.getName(), "getImageBySmallImageId", new Class[]{Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{smallImageId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (IGImage)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<IGImage> getImages(HttpPrincipal httpPrincipal, long groupId, long folderId) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(IGImageServiceUtil.class.getName(), "getImages", new Class[]{Long.TYPE, Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, folderId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<IGImage> getImages(HttpPrincipal httpPrincipal, long groupId, long folderId, int start, int end) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(IGImageServiceUtil.class.getName(), "getImages", new Class[]{Long.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, folderId, start, end});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static int getImagesCount(HttpPrincipal httpPrincipal, long groupId, long folderId) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(IGImageServiceUtil.class.getName(), "getImagesCount", new Class[]{Long.TYPE, Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, folderId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Integer)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static IGImage updateImage(HttpPrincipal httpPrincipal, long imageId, long groupId, long folderId, String name, String description, File file, String contentType, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(IGImageServiceUtil.class.getName(), "updateImage", new Class[]{Long.TYPE, Long.TYPE, Long.TYPE, String.class, String.class, File.class, String.class, ServiceContext.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{imageId, groupId, folderId, name, description, file, contentType, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (IGImage)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }
}

