/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.imagegallery.asset;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.asset.model.AssetRenderer;
import com.liferay.portlet.asset.model.BaseAssetRendererFactory;
import com.liferay.portlet.assetpublisher.util.AssetPublisherUtil;
import com.liferay.portlet.imagegallery.asset.IGImageAssetRenderer;
import com.liferay.portlet.imagegallery.model.IGImage;
import com.liferay.portlet.imagegallery.service.IGImageLocalServiceUtil;
import com.liferay.portlet.imagegallery.service.permission.IGImagePermission;
import com.liferay.portlet.imagegallery.service.permission.IGPermission;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;

public class IGImageAssetRendererFactory
extends BaseAssetRendererFactory {
    public static final String CLASS_NAME = IGImage.class.getName();
    public static final String TYPE = "image";

    public AssetRenderer getAssetRenderer(long classPK, int type) throws PortalException, SystemException {
        IGImage image = IGImageLocalServiceUtil.getImage((long)classPK);
        return new IGImageAssetRenderer(image);
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public String getType() {
        return TYPE;
    }

    public PortletURL getURLAdd(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) {
        ThemeDisplay themeDisplay = (ThemeDisplay)liferayPortletRequest.getAttribute("THEME_DISPLAY");
        LiferayPortletURL addAssetURL = null;
        if (IGPermission.contains(themeDisplay.getPermissionChecker(), themeDisplay.getScopeGroupId(), "ADD_IMAGE")) {
            addAssetURL = liferayPortletResponse.createRenderURL("31");
            addAssetURL.setParameter("struts_action", "/image_gallery/edit_image");
            addAssetURL.setParameter("groupId", String.valueOf(themeDisplay.getScopeGroupId()));
            addAssetURL.setParameter("folderId", String.valueOf(AssetPublisherUtil.getRecentFolderId((PortletRequest)liferayPortletRequest, CLASS_NAME)));
            addAssetURL.setParameter("uploader", "classic");
        }
        return addAssetURL;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws Exception {
        return IGImagePermission.contains(permissionChecker, classPK, actionId);
    }

    protected String getIconPath(ThemeDisplay themeDisplay) {
        return String.valueOf(themeDisplay.getPathThemeImages()) + "/file_system/small/bmp.png";
    }
}

