/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.enterpriseadmin.util;

import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.BooleanQueryFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.ExpandoIndexer;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.FullNameGenerator;
import com.liferay.portal.security.auth.FullNameGeneratorFactory;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetCategoryLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetTagLocalServiceUtil;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeFactoryUtil;
import com.liferay.portlet.expando.util.ExpandoBridgeIndexerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletURL;

public class UserIndexer
extends ExpandoIndexer {
    public static final String[] CLASS_NAMES = new String[]{User.class.getName()};
    public static final String PORTLET_ID = "125";

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public Summary getSummary(Document document, String snippet, PortletURL portletURL) {
        String firstName = document.get("firstName");
        String middleName = document.get("middleName");
        String lastName = document.get("lastName");
        FullNameGenerator fullNameGenerator = FullNameGeneratorFactory.getInstance();
        String title = fullNameGenerator.getFullName(firstName, middleName, lastName);
        String content = null;
        String userId = document.get("userId");
        portletURL.setParameter("struts_action", "/enterprise_admin/edit_user");
        portletURL.setParameter("p_u_i_d", userId);
        return new Summary(title, content, portletURL);
    }

    protected void addContextQueryParams(BooleanQuery contextQuery, String key, Object value) throws Exception {
        if (key.equals("usersOrgs")) {
            if (value instanceof Long[]) {
                Long[] values = (Long[])value;
                BooleanQuery usersOrgsQuery = BooleanQueryFactoryUtil.create();
                Long[] longArray = values;
                int n = values.length;
                int n2 = 0;
                while (n2 < n) {
                    long organizationId = longArray[n2];
                    usersOrgsQuery.addTerm("organizationIds", organizationId);
                    usersOrgsQuery.addTerm("ancestorOrganizationIds", organizationId);
                    ++n2;
                }
                contextQuery.add((Query)usersOrgsQuery, BooleanClauseOccur.MUST);
            } else {
                contextQuery.addRequiredTerm("organizationIds", String.valueOf(value));
            }
        } else if (key.equals("usersRoles")) {
            contextQuery.addRequiredTerm("roleIds", String.valueOf(value));
        } else if (key.equals("usersTeams")) {
            contextQuery.addRequiredTerm("teamIds", String.valueOf(value));
        } else if (key.equals("usersUserGroups")) {
            contextQuery.addRequiredTerm("userGroupIds", String.valueOf(value));
        }
    }

    protected void doDelete(Object obj) throws Exception {
        User user = (User)obj;
        DocumentImpl document = new DocumentImpl();
        document.addUID(PORTLET_ID, user.getUserId());
        SearchEngineUtil.deleteDocument((long)user.getCompanyId(), (String)document.get("uid"));
    }

    protected Document doGetDocument(Object obj) throws Exception {
        User user = (User)obj;
        long companyId = user.getCompanyId();
        long userId = user.getUserId();
        String screenName = user.getScreenName();
        String emailAddress = user.getEmailAddress();
        String firstName = user.getFirstName();
        String middleName = user.getMiddleName();
        String lastName = user.getLastName();
        String jobTitle = user.getJobTitle();
        boolean active = user.isActive();
        long[] groupIds = user.getGroupIds();
        long[] organizationIds = user.getOrganizationIds();
        long[] roleIds = user.getRoleIds();
        long[] teamIds = user.getTeamIds();
        long[] userGroupIds = user.getUserGroupIds();
        long[] assetCategoryIds = AssetCategoryLocalServiceUtil.getCategoryIds((String)User.class.getName(), (long)userId);
        String[] assetTagNames = AssetTagLocalServiceUtil.getTagNames((String)User.class.getName(), (long)userId);
        ExpandoBridge expandoBridge = user.getExpandoBridge();
        DocumentImpl document = new DocumentImpl();
        document.addUID(PORTLET_ID, userId);
        document.addModifiedDate();
        document.addKeyword("companyId", companyId);
        document.addKeyword("portletId", PORTLET_ID);
        document.addKeyword("userId", userId);
        document.addKeyword("screenName", screenName);
        document.addKeyword("emailAddress", emailAddress);
        document.addKeyword("firstName", firstName, true);
        document.addKeyword("middleName", middleName, true);
        document.addKeyword("lastName", lastName, true);
        document.addKeyword("jobTitle", jobTitle);
        document.addKeyword("active", active);
        document.addKeyword("groupIds", groupIds);
        document.addKeyword("organizationIds", organizationIds);
        document.addKeyword("ancestorOrganizationIds", this.getAncestorOrganizationIds(userId, organizationIds));
        document.addKeyword("roleIds", roleIds);
        document.addKeyword("teamIds", teamIds);
        document.addKeyword("userGroupIds", userGroupIds);
        document.addKeyword("assetCategoryIds", assetCategoryIds);
        document.addKeyword("assetTagNames", assetTagNames);
        document.addKeyword("entryClassName", User.class.getName());
        document.addKeyword("entryClassPK", userId);
        ExpandoBridgeIndexerUtil.addAttributes((Document)document, (ExpandoBridge)expandoBridge);
        return document;
    }

    protected void doReindex(Object obj) throws Exception {
        if (obj instanceof List) {
            List users = (List)obj;
            for (User user : users) {
                this.doReindex(user);
            }
        } else if (obj instanceof Long) {
            long userId = (Long)obj;
            User user = UserLocalServiceUtil.getUserById((long)userId);
            this.doReindex(user);
        } else if (obj instanceof long[]) {
            long[] userIds = (long[])obj;
            HashMap<Long, ArrayList<Document>> documentsMap = new HashMap<Long, ArrayList<Document>>();
            long[] lArray = userIds;
            int n = userIds.length;
            int n2 = 0;
            while (n2 < n) {
                long userId = lArray[n2];
                User user = UserLocalServiceUtil.getUserById((long)userId);
                if (!user.isDefaultUser()) {
                    Document document = this.getDocument(user);
                    long companyId = user.getCompanyId();
                    ArrayList<Document> documents = (ArrayList<Document>)documentsMap.get(companyId);
                    if (documents == null) {
                        documents = new ArrayList<Document>();
                        documentsMap.put(companyId, documents);
                    }
                    documents.add(document);
                }
                ++n2;
            }
            for (Map.Entry entry : documentsMap.entrySet()) {
                long companyId = (Long)entry.getKey();
                Collection documents = (Collection)entry.getValue();
                SearchEngineUtil.updateDocuments((long)companyId, (Collection)documents);
            }
        } else if (obj instanceof User) {
            User user = (User)obj;
            if (user.isDefaultUser()) {
                return;
            }
            Document document = this.getDocument(user);
            SearchEngineUtil.updateDocument((long)user.getCompanyId(), (Document)document);
        }
    }

    protected void doReindex(String className, long classPK) throws Exception {
        User user = UserLocalServiceUtil.getUserById((long)classPK);
        this.doReindex(user);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexUsers(companyId);
    }

    protected long[] getAncestorOrganizationIds(long userId, long[] organizationIds) throws Exception {
        ArrayList ancestorOrganizations = new ArrayList();
        long[] lArray = organizationIds;
        int n = organizationIds.length;
        int n2 = 0;
        while (n2 < n) {
            long organizationId = lArray[n2];
            Organization organization = OrganizationLocalServiceUtil.getOrganization((long)organizationId);
            ancestorOrganizations.addAll(organization.getAncestors());
            ++n2;
        }
        long[] ancestorOrganizationIds = new long[ancestorOrganizations.size()];
        int i = 0;
        while (i < ancestorOrganizations.size()) {
            Organization ancestorOrganization = (Organization)ancestorOrganizations.get(i);
            ancestorOrganizationIds[i] = ancestorOrganization.getOrganizationId();
            ++i;
        }
        return ancestorOrganizationIds;
    }

    protected String getPortletId(SearchContext searchContext) {
        return PORTLET_ID;
    }

    protected void postProcessContextQuery(BooleanQuery contextQuery, SearchContext searchContext) throws Exception {
        LinkedHashMap params;
        Boolean active = (Boolean)searchContext.getAttribute("active");
        if (active != null) {
            contextQuery.addRequiredTerm("active", active);
        }
        if ((params = (LinkedHashMap)searchContext.getAttribute("params")) == null) {
            return;
        }
        for (Map.Entry entry : params.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value == null) continue;
            this.addContextQueryParams(contextQuery, key, value);
        }
    }

    protected void postProcessSearchQuery(BooleanQuery searchQuery, SearchContext searchContext) throws Exception {
        LinkedHashMap params;
        String screenName;
        String middleName;
        String lastName;
        String firstName;
        String emailAddress = (String)((Object)searchContext.getAttribute("emailAddress"));
        if (Validator.isNotNull((String)emailAddress)) {
            if (searchContext.isAndSearch()) {
                searchQuery.addRequiredTerm("emailAddress", emailAddress, true);
            } else {
                searchQuery.addTerm("emailAddress", emailAddress, true);
            }
        }
        if (Validator.isNotNull((String)(firstName = (String)((Object)searchContext.getAttribute("firstName"))))) {
            if (searchContext.isAndSearch()) {
                searchQuery.addRequiredTerm("firstName", firstName, true);
            } else {
                searchQuery.addTerm("firstName", firstName, true);
            }
        }
        if (Validator.isNotNull((String)(lastName = (String)((Object)searchContext.getAttribute("lastName"))))) {
            if (searchContext.isAndSearch()) {
                searchQuery.addRequiredTerm("lastName", lastName, true);
            } else {
                searchQuery.addTerm("lastName", lastName, true);
            }
        }
        if (Validator.isNotNull((String)(middleName = (String)((Object)searchContext.getAttribute("middleName"))))) {
            if (searchContext.isAndSearch()) {
                searchQuery.addRequiredTerm("middleName", middleName, true);
            } else {
                searchQuery.addTerm("middleName", middleName, true);
            }
        }
        if (Validator.isNotNull((String)(screenName = (String)((Object)searchContext.getAttribute("screenName"))))) {
            if (searchContext.isAndSearch()) {
                searchQuery.addRequiredTerm("screenName", screenName, true);
            } else {
                searchQuery.addTerm("screenName", screenName, true);
            }
        }
        if ((params = (LinkedHashMap)searchContext.getAttribute("params")) != null) {
            ExpandoBridge expandoBridge = ExpandoBridgeFactoryUtil.getExpandoBridge((long)searchContext.getCompanyId(), (String)User.class.getName());
            Set attributeNames = SetUtil.fromEnumeration((Enumeration)expandoBridge.getAttributeNames());
            for (Map.Entry entry : params.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if (key.equals("usersOrgs") || key.equals("usersRoles") || key.equals("usersTeams") || key.equals("usersUserGroups") || value == null) continue;
                this.addSearchQueryParams(searchQuery, searchContext, expandoBridge, attributeNames, key, value);
            }
        }
    }

    protected void reindexUsers(long companyId) throws Exception {
        int count = UserLocalServiceUtil.getCompanyUsersCount((long)companyId);
        int pages = count / 1000;
        int i = 0;
        while (i <= pages) {
            int start = i * 1000;
            int end = start + 1000;
            this.reindexUsers(companyId, start, end);
            ++i;
        }
    }

    protected void reindexUsers(long companyId, int start, int end) throws Exception {
        List users = UserLocalServiceUtil.getCompanyUsers((long)companyId, (int)start, (int)end);
        if (users.isEmpty()) {
            return;
        }
        ArrayList<Document> documents = new ArrayList<Document>();
        for (User user : users) {
            if (user.isDefaultUser()) continue;
            Document document = this.getDocument(user);
            documents.add(document);
        }
        SearchEngineUtil.updateDocuments((long)companyId, documents);
    }
}

