/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.documentlibrary.FileShortcutPermissionException;
import com.liferay.portlet.documentlibrary.model.DLFileShortcut;
import com.liferay.portlet.documentlibrary.service.base.DLFileShortcutServiceBaseImpl;
import com.liferay.portlet.documentlibrary.service.permission.DLFileEntryPermission;
import com.liferay.portlet.documentlibrary.service.permission.DLFileShortcutPermission;
import com.liferay.portlet.documentlibrary.service.permission.DLFolderPermission;

public class DLFileShortcutServiceImpl
extends DLFileShortcutServiceBaseImpl {
    public DLFileShortcut addFileShortcut(long groupId, long folderId, long toFolderId, String toName, ServiceContext serviceContext) throws PortalException, SystemException {
        DLFolderPermission.check(this.getPermissionChecker(), groupId, folderId, "ADD_SHORTCUT");
        try {
            DLFileEntryPermission.check(this.getPermissionChecker(), groupId, toFolderId, toName, "VIEW");
        }
        catch (PrincipalException principalException) {
            throw new FileShortcutPermissionException();
        }
        return this.dlFileShortcutLocalService.addFileShortcut(this.getUserId(), groupId, folderId, toFolderId, toName, serviceContext);
    }

    public void deleteFileShortcut(long fileShortcutId) throws PortalException, SystemException {
        DLFileShortcutPermission.check(this.getPermissionChecker(), fileShortcutId, "DELETE");
        this.dlFileShortcutLocalService.deleteFileShortcut(fileShortcutId);
    }

    public DLFileShortcut getFileShortcut(long fileShortcutId) throws PortalException, SystemException {
        DLFileShortcutPermission.check(this.getPermissionChecker(), fileShortcutId, "VIEW");
        return this.dlFileShortcutLocalService.getFileShortcut(fileShortcutId);
    }

    public DLFileShortcut updateFileShortcut(long fileShortcutId, long folderId, long toFolderId, String toName, ServiceContext serviceContext) throws PortalException, SystemException {
        DLFileShortcutPermission.check(this.getPermissionChecker(), fileShortcutId, "UPDATE");
        DLFileShortcut fileShortcut = this.dlFileShortcutLocalService.getDLFileShortcut(fileShortcutId);
        try {
            DLFileEntryPermission.check(this.getPermissionChecker(), fileShortcut.getGroupId(), toFolderId, toName, "VIEW");
        }
        catch (PrincipalException principalException) {
            throw new FileShortcutPermissionException();
        }
        return this.dlFileShortcutLocalService.updateFileShortcut(this.getUserId(), fileShortcutId, folderId, toFolderId, toName, serviceContext);
    }
}

