/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.model.Lock;
import com.liferay.portal.security.auth.HttpPrincipal;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.http.TunnelUtil;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.service.DLFolderServiceUtil;
import java.rmi.RemoteException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DLFolderServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(DLFolderServiceHttp.class);

    public static DLFolder addFolder(HttpPrincipal httpPrincipal, long groupId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(DLFolderServiceUtil.class.getName(), "addFolder", new Class[]{Long.TYPE, Long.TYPE, String.class, String.class, ServiceContext.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, parentFolderId, name, description, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (DLFolder)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static DLFolder copyFolder(HttpPrincipal httpPrincipal, long groupId, long sourceFolderId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException, SystemException, RemoteException {
        try {
            MethodKey methodKey = new MethodKey(DLFolderServiceUtil.class.getName(), "copyFolder", new Class[]{Long.TYPE, Long.TYPE, Long.TYPE, String.class, String.class, ServiceContext.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, sourceFolderId, parentFolderId, name, description, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                if (e instanceof RemoteException) {
                    throw (RemoteException)e;
                }
                throw new SystemException((Throwable)e);
            }
            return (DLFolder)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void deleteFolder(HttpPrincipal httpPrincipal, long folderId) throws PortalException, SystemException, RemoteException {
        try {
            MethodKey methodKey = new MethodKey(DLFolderServiceUtil.class.getName(), "deleteFolder", new Class[]{Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{folderId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                if (e instanceof RemoteException) {
                    throw (RemoteException)e;
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void deleteFolder(HttpPrincipal httpPrincipal, long groupId, long parentFolderId, String name) throws PortalException, SystemException, RemoteException {
        try {
            MethodKey methodKey = new MethodKey(DLFolderServiceUtil.class.getName(), "deleteFolder", new Class[]{Long.TYPE, Long.TYPE, String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, parentFolderId, name});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                if (e instanceof RemoteException) {
                    throw (RemoteException)e;
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<Object> getFileEntriesAndFileShortcuts(HttpPrincipal httpPrincipal, long groupId, List<Long> folderIds, int status, int start, int end) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(DLFolderServiceUtil.class.getName(), "getFileEntriesAndFileShortcuts", new Class[]{Long.TYPE, List.class, Integer.TYPE, Integer.TYPE, Integer.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, folderIds, status, start, end});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<Object> getFileEntriesAndFileShortcuts(HttpPrincipal httpPrincipal, long groupId, long folderId, int status, int start, int end) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(DLFolderServiceUtil.class.getName(), "getFileEntriesAndFileShortcuts", new Class[]{Long.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, folderId, status, start, end});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static int getFileEntriesAndFileShortcutsCount(HttpPrincipal httpPrincipal, long groupId, List<Long> folderIds, int status) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(DLFolderServiceUtil.class.getName(), "getFileEntriesAndFileShortcutsCount", new Class[]{Long.TYPE, List.class, Integer.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, folderIds, status});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Integer)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static int getFileEntriesAndFileShortcutsCount(HttpPrincipal httpPrincipal, long groupId, long folderId, int status) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(DLFolderServiceUtil.class.getName(), "getFileEntriesAndFileShortcutsCount", new Class[]{Long.TYPE, Long.TYPE, Integer.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, folderId, status});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Integer)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static DLFolder getFolder(HttpPrincipal httpPrincipal, long folderId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(DLFolderServiceUtil.class.getName(), "getFolder", new Class[]{Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{folderId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (DLFolder)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static DLFolder getFolder(HttpPrincipal httpPrincipal, long groupId, long parentFolderId, String name) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(DLFolderServiceUtil.class.getName(), "getFolder", new Class[]{Long.TYPE, Long.TYPE, String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, parentFolderId, name});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (DLFolder)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static long getFolderId(HttpPrincipal httpPrincipal, long groupId, long parentFolderId, String name) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(DLFolderServiceUtil.class.getName(), "getFolderId", new Class[]{Long.TYPE, Long.TYPE, String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, parentFolderId, name});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Long)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static long[] getFolderIds(HttpPrincipal httpPrincipal, long groupId, long folderId) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(DLFolderServiceUtil.class.getName(), "getFolderIds", new Class[]{Long.TYPE, Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, folderId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (long[])returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<DLFolder> getFolders(HttpPrincipal httpPrincipal, long groupId, long parentFolderId) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(DLFolderServiceUtil.class.getName(), "getFolders", new Class[]{Long.TYPE, Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, parentFolderId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<DLFolder> getFolders(HttpPrincipal httpPrincipal, long groupId, long parentFolderId, int start, int end) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(DLFolderServiceUtil.class.getName(), "getFolders", new Class[]{Long.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, parentFolderId, start, end});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<Object> getFoldersAndFileEntriesAndFileShortcuts(HttpPrincipal httpPrincipal, long groupId, List<Long> folderIds, int status, int start, int end) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(DLFolderServiceUtil.class.getName(), "getFoldersAndFileEntriesAndFileShortcuts", new Class[]{Long.TYPE, List.class, Integer.TYPE, Integer.TYPE, Integer.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, folderIds, status, start, end});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<Object> getFoldersAndFileEntriesAndFileShortcuts(HttpPrincipal httpPrincipal, long groupId, long folderId, int status, int start, int end) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(DLFolderServiceUtil.class.getName(), "getFoldersAndFileEntriesAndFileShortcuts", new Class[]{Long.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, folderId, status, start, end});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static int getFoldersAndFileEntriesAndFileShortcutsCount(HttpPrincipal httpPrincipal, long groupId, List<Long> folderIds, int status) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(DLFolderServiceUtil.class.getName(), "getFoldersAndFileEntriesAndFileShortcutsCount", new Class[]{Long.TYPE, List.class, Integer.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, folderIds, status});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Integer)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static int getFoldersAndFileEntriesAndFileShortcutsCount(HttpPrincipal httpPrincipal, long groupId, long folderId, int status) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(DLFolderServiceUtil.class.getName(), "getFoldersAndFileEntriesAndFileShortcutsCount", new Class[]{Long.TYPE, Long.TYPE, Integer.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, folderId, status});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Integer)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static int getFoldersCount(HttpPrincipal httpPrincipal, long groupId, long parentFolderId) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(DLFolderServiceUtil.class.getName(), "getFoldersCount", new Class[]{Long.TYPE, Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, parentFolderId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Integer)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void getSubfolderIds(HttpPrincipal httpPrincipal, List<Long> folderIds, long groupId, long folderId) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(DLFolderServiceUtil.class.getName(), "getSubfolderIds", new Class[]{List.class, Long.TYPE, Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{folderIds, groupId, folderId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static boolean hasInheritableLock(HttpPrincipal httpPrincipal, long folderId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(DLFolderServiceUtil.class.getName(), "hasInheritableLock", new Class[]{Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{folderId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Boolean)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Lock lockFolder(HttpPrincipal httpPrincipal, long folderId) throws PortalException, SystemException, RemoteException {
        try {
            MethodKey methodKey = new MethodKey(DLFolderServiceUtil.class.getName(), "lockFolder", new Class[]{Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{folderId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                if (e instanceof RemoteException) {
                    throw (RemoteException)e;
                }
                throw new SystemException((Throwable)e);
            }
            return (Lock)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Lock lockFolder(HttpPrincipal httpPrincipal, long folderId, String owner, boolean inheritable, long expirationTime) throws PortalException, SystemException, RemoteException {
        try {
            MethodKey methodKey = new MethodKey(DLFolderServiceUtil.class.getName(), "lockFolder", new Class[]{Long.TYPE, String.class, Boolean.TYPE, Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{folderId, owner, inheritable, expirationTime});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                if (e instanceof RemoteException) {
                    throw (RemoteException)e;
                }
                throw new SystemException((Throwable)e);
            }
            return (Lock)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Lock refreshFolderLock(HttpPrincipal httpPrincipal, String lockUuid, long expirationTime) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(DLFolderServiceUtil.class.getName(), "refreshFolderLock", new Class[]{String.class, Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{lockUuid, expirationTime});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Lock)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void unlockFolder(HttpPrincipal httpPrincipal, long groupId, long folderId, String lockUuid) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(DLFolderServiceUtil.class.getName(), "unlockFolder", new Class[]{Long.TYPE, Long.TYPE, String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, folderId, lockUuid});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void unlockFolder(HttpPrincipal httpPrincipal, long groupId, long parentFolderId, String name, String lockUuid) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(DLFolderServiceUtil.class.getName(), "unlockFolder", new Class[]{Long.TYPE, Long.TYPE, String.class, String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, parentFolderId, name, lockUuid});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static DLFolder updateFolder(HttpPrincipal httpPrincipal, long folderId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException, SystemException, RemoteException {
        try {
            MethodKey methodKey = new MethodKey(DLFolderServiceUtil.class.getName(), "updateFolder", new Class[]{Long.TYPE, Long.TYPE, String.class, String.class, ServiceContext.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{folderId, parentFolderId, name, description, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                if (e instanceof RemoteException) {
                    throw (RemoteException)e;
                }
                throw new SystemException((Throwable)e);
            }
            return (DLFolder)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static boolean verifyInheritableLock(HttpPrincipal httpPrincipal, long folderId, String lockUuid) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(DLFolderServiceUtil.class.getName(), "verifyInheritableLock", new Class[]{Long.TYPE, String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{folderId, lockUuid});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Boolean)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }
}

