/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.http;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileEntrySoap;
import com.liferay.portlet.documentlibrary.service.DLFileEntryServiceUtil;
import java.rmi.RemoteException;
import java.util.List;

public class DLFileEntryServiceSoap {
    private static Log _log = LogFactoryUtil.getLog(DLFileEntryServiceSoap.class);

    public static DLFileEntrySoap addFileEntry(long groupId, long folderId, String name, String title, String description, String changeLog, String extraSettings, byte[] bytes, ServiceContext serviceContext) throws RemoteException {
        try {
            DLFileEntry returnValue = DLFileEntryServiceUtil.addFileEntry((long)groupId, (long)folderId, (String)name, (String)title, (String)description, (String)changeLog, (String)extraSettings, (byte[])bytes, (ServiceContext)serviceContext);
            return DLFileEntrySoap.toSoapModel((DLFileEntry)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void deleteFileEntry(long groupId, long folderId, String name) throws RemoteException {
        try {
            DLFileEntryServiceUtil.deleteFileEntry((long)groupId, (long)folderId, (String)name);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void deleteFileEntry(long groupId, long folderId, String name, String version) throws RemoteException {
        try {
            DLFileEntryServiceUtil.deleteFileEntry((long)groupId, (long)folderId, (String)name, (String)version);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void deleteFileEntryByTitle(long groupId, long folderId, String titleWithExtension) throws RemoteException {
        try {
            DLFileEntryServiceUtil.deleteFileEntryByTitle((long)groupId, (long)folderId, (String)titleWithExtension);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static DLFileEntrySoap[] getFileEntries(long groupId, long folderId) throws RemoteException {
        try {
            List returnValue = DLFileEntryServiceUtil.getFileEntries((long)groupId, (long)folderId);
            return DLFileEntrySoap.toSoapModels((List)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static DLFileEntrySoap[] getFileEntries(long groupId, long folderId, int start, int end) throws RemoteException {
        try {
            List returnValue = DLFileEntryServiceUtil.getFileEntries((long)groupId, (long)folderId, (int)start, (int)end);
            return DLFileEntrySoap.toSoapModels((List)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static DLFileEntrySoap[] getFileEntries(long groupId, long folderId, int start, int end, OrderByComparator obc) throws RemoteException {
        try {
            List returnValue = DLFileEntryServiceUtil.getFileEntries((long)groupId, (long)folderId, (int)start, (int)end, (OrderByComparator)obc);
            return DLFileEntrySoap.toSoapModels((List)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getFileEntriesCount(long groupId, long folderId) throws RemoteException {
        try {
            int returnValue = DLFileEntryServiceUtil.getFileEntriesCount((long)groupId, (long)folderId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static DLFileEntrySoap getFileEntry(long groupId, long folderId, String name) throws RemoteException {
        try {
            DLFileEntry returnValue = DLFileEntryServiceUtil.getFileEntry((long)groupId, (long)folderId, (String)name);
            return DLFileEntrySoap.toSoapModel((DLFileEntry)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static DLFileEntrySoap getFileEntryByTitle(long groupId, long folderId, String titleWithExtension) throws RemoteException {
        try {
            DLFileEntry returnValue = DLFileEntryServiceUtil.getFileEntryByTitle((long)groupId, (long)folderId, (String)titleWithExtension);
            return DLFileEntrySoap.toSoapModel((DLFileEntry)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static DLFileEntrySoap getFileEntryByUuidAndGroupId(String uuid, long groupId) throws RemoteException {
        try {
            DLFileEntry returnValue = DLFileEntryServiceUtil.getFileEntryByUuidAndGroupId((String)uuid, (long)groupId);
            return DLFileEntrySoap.toSoapModel((DLFileEntry)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getFoldersFileEntriesCount(long groupId, Long[] folderIds, int status) throws RemoteException {
        try {
            int returnValue = DLFileEntryServiceUtil.getFoldersFileEntriesCount((long)groupId, (List)ListUtil.toList((Object[])folderIds), (int)status);
            return returnValue;
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static DLFileEntrySoap[] getGroupFileEntries(long groupId, long userId, int start, int end) throws RemoteException {
        try {
            List returnValue = DLFileEntryServiceUtil.getGroupFileEntries((long)groupId, (long)userId, (int)start, (int)end);
            return DLFileEntrySoap.toSoapModels((List)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static DLFileEntrySoap[] getGroupFileEntries(long groupId, long userId, int start, int end, OrderByComparator obc) throws RemoteException {
        try {
            List returnValue = DLFileEntryServiceUtil.getGroupFileEntries((long)groupId, (long)userId, (int)start, (int)end, (OrderByComparator)obc);
            return DLFileEntrySoap.toSoapModels((List)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getGroupFileEntriesCount(long groupId, long userId) throws RemoteException {
        try {
            int returnValue = DLFileEntryServiceUtil.getGroupFileEntriesCount((long)groupId, (long)userId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static boolean hasFileEntryLock(long groupId, long folderId, String name) throws RemoteException {
        try {
            boolean returnValue = DLFileEntryServiceUtil.hasFileEntryLock((long)groupId, (long)folderId, (String)name);
            return returnValue;
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static DLFileEntrySoap moveFileEntry(long groupId, long folderId, long newFolderId, String name, ServiceContext serviceContext) throws RemoteException {
        try {
            DLFileEntry returnValue = DLFileEntryServiceUtil.moveFileEntry((long)groupId, (long)folderId, (long)newFolderId, (String)name, (ServiceContext)serviceContext);
            return DLFileEntrySoap.toSoapModel((DLFileEntry)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void unlockFileEntry(long groupId, long folderId, String name) throws RemoteException {
        try {
            DLFileEntryServiceUtil.unlockFileEntry((long)groupId, (long)folderId, (String)name);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void unlockFileEntry(long groupId, long folderId, String name, String lockUuid) throws RemoteException {
        try {
            DLFileEntryServiceUtil.unlockFileEntry((long)groupId, (long)folderId, (String)name, (String)lockUuid);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static DLFileEntrySoap updateFileEntry(long groupId, long folderId, String name, String sourceFileName, String title, String description, String changeLog, boolean majorVersion, String extraSettings, byte[] bytes, ServiceContext serviceContext) throws RemoteException {
        try {
            DLFileEntry returnValue = DLFileEntryServiceUtil.updateFileEntry((long)groupId, (long)folderId, (String)name, (String)sourceFileName, (String)title, (String)description, (String)changeLog, (boolean)majorVersion, (String)extraSettings, (byte[])bytes, (ServiceContext)serviceContext);
            return DLFileEntrySoap.toSoapModel((DLFileEntry)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static boolean verifyFileEntryLock(long groupId, long folderId, String name, String lockUuid) throws RemoteException {
        try {
            boolean returnValue = DLFileEntryServiceUtil.verifyFileEntryLock((long)groupId, (long)folderId, (String)name, (String)lockUuid);
            return returnValue;
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }
}

