/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.model.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.model.Lock;
import com.liferay.portal.service.LockLocalServiceUtil;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileVersion;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.model.impl.DLFileEntryModelImpl;
import com.liferay.portlet.documentlibrary.model.impl.DLFolderImpl;
import com.liferay.portlet.documentlibrary.service.DLFileVersionLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFolderLocalServiceUtil;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

public class DLFileEntryImpl
extends DLFileEntryModelImpl
implements DLFileEntry {
    private static Log _log = LogFactoryUtil.getLog(DLFileEntryImpl.class);
    private UnicodeProperties _extraSettingsProperties = null;

    public static long getFolderId(long groupId, long repositoryId) {
        if (groupId != repositoryId) {
            return repositoryId;
        }
        return 0L;
    }

    public static long getRepositoryId(long groupId, long folderId) {
        if (folderId == 0L) {
            return groupId;
        }
        return folderId;
    }

    public String getExtraSettings() {
        if (this._extraSettingsProperties == null) {
            return super.getExtraSettings();
        }
        return this._extraSettingsProperties.toString();
    }

    public UnicodeProperties getExtraSettingsProperties() {
        if (this._extraSettingsProperties == null) {
            this._extraSettingsProperties = new UnicodeProperties(true);
            try {
                this._extraSettingsProperties.load(super.getExtraSettings());
            }
            catch (IOException ioe) {
                _log.error((Object)ioe, (Throwable)ioe);
            }
        }
        return this._extraSettingsProperties;
    }

    public DLFileVersion getFileVersion() throws PortalException, SystemException {
        return DLFileVersionLocalServiceUtil.getFileVersion((long)this.getGroupId(), (long)this.getFolderId(), (String)this.getName(), (String)this.getVersion());
    }

    public DLFolder getFolder() {
        DLFolderImpl folder = null;
        if (this.getFolderId() > 0L) {
            try {
                folder = DLFolderLocalServiceUtil.getFolder((long)this.getFolderId());
            }
            catch (Exception e) {
                folder = new DLFolderImpl();
                _log.error((Object)e, (Throwable)e);
            }
        } else {
            folder = new DLFolderImpl();
        }
        return folder;
    }

    public String getIcon() {
        return DLUtil.getFileIcon((String)this.getExtension());
    }

    public DLFileVersion getLatestFileVersion() throws PortalException, SystemException {
        return DLFileVersionLocalServiceUtil.getLatestFileVersion((long)this.getGroupId(), (long)this.getFolderId(), (String)this.getName());
    }

    public Lock getLock() {
        try {
            String lockId = DLUtil.getLockId((long)this.getGroupId(), (long)this.getFolderId(), (String)this.getName());
            return LockLocalServiceUtil.getLock((String)DLFileEntry.class.getName(), (String)lockId);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getLuceneProperties() {
        UnicodeProperties extraSettingsProps = this.getExtraSettingsProperties();
        Iterator itr = extraSettingsProps.entrySet().iterator();
        StringBundler sb = new StringBundler(extraSettingsProps.entrySet().size() + 4);
        sb.append(FileUtil.stripExtension((String)this.getTitle()));
        sb.append(" ");
        sb.append(this.getDescription());
        sb.append(" ");
        while (itr.hasNext()) {
            Map.Entry entry = (Map.Entry)itr.next();
            String value = GetterUtil.getString((String)((String)entry.getValue()));
            sb.append(value);
        }
        return sb.toString();
    }

    public long getRepositoryId() {
        return DLFileEntryImpl.getRepositoryId(this.getGroupId(), this.getFolderId());
    }

    public boolean hasLock(long userId) {
        try {
            String lockId = DLUtil.getLockId((long)this.getGroupId(), (long)this.getFolderId(), (String)this.getName());
            return LockLocalServiceUtil.hasLock((long)userId, (String)DLFileEntry.class.getName(), (String)lockId);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isLocked() {
        try {
            String lockId = DLUtil.getLockId((long)this.getGroupId(), (long)this.getFolderId(), (String)this.getName());
            return LockLocalServiceUtil.isLocked((String)DLFileEntry.class.getName(), (String)lockId);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void setExtraSettings(String extraSettings) {
        this._extraSettingsProperties = null;
        super.setExtraSettings(extraSettings);
    }

    public void setExtraSettingsProperties(UnicodeProperties extraSettingsProperties) {
        this._extraSettingsProperties = extraSettingsProperties;
        super.setExtraSettings(this._extraSettingsProperties.toString());
    }
}

