/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.lar;

import com.liferay.portal.kernel.lar.BasePortletDataHandler;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataHandlerBoolean;
import com.liferay.portal.kernel.lar.PortletDataHandlerControl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portlet.documentlibrary.lar.DLPortletDataHandlerImpl;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.service.persistence.DLFolderUtil;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;

public class DLDisplayPortletDataHandlerImpl
extends BasePortletDataHandler {
    private static final String _NAMESPACE = "document_library";
    private static final boolean _PUBLISH_TO_LIVE_BY_DEFAULT = true;
    private static PortletDataHandlerBoolean _comments = new PortletDataHandlerBoolean("document_library", "comments");
    private static PortletDataHandlerBoolean _foldersAndDocuments = new PortletDataHandlerBoolean("document_library", "folders-and-documents", true, true);
    private static PortletDataHandlerBoolean _ranks = new PortletDataHandlerBoolean("document_library", "ranks");
    private static PortletDataHandlerBoolean _ratings = new PortletDataHandlerBoolean("document_library", "ratings");
    private static PortletDataHandlerBoolean _shortcuts = new PortletDataHandlerBoolean("document_library", "shortcuts");
    private static PortletDataHandlerBoolean _tags = new PortletDataHandlerBoolean("document_library", "tags");

    public PortletDataHandlerControl[] getExportControls() {
        return new PortletDataHandlerControl[]{_foldersAndDocuments, _shortcuts, _ranks, _comments, _ratings, _tags};
    }

    public PortletDataHandlerControl[] getImportControls() {
        return new PortletDataHandlerControl[]{_foldersAndDocuments, _shortcuts, _ranks, _comments, _ratings, _tags};
    }

    public boolean isPublishToLiveByDefault() {
        return true;
    }

    protected PortletPreferences doDeleteData(PortletDataContext context, String portletId, PortletPreferences preferences) throws Exception {
        preferences.setValue("rootFolderId", "");
        preferences.setValue("showBreadcrumbs", "");
        preferences.setValue("showFoldersSearch", "");
        preferences.setValue("showSubfolders", "");
        preferences.setValue("foldersPerPage", "");
        preferences.setValue("folderColumns", "");
        preferences.setValue("showFileEntriesSearch", "");
        preferences.setValue("fileEntriesPerPage", "");
        preferences.setValue("fileEntryColumns", "");
        preferences.setValue("enable-comment-ratings", "");
        return preferences;
    }

    protected String doExportData(PortletDataContext context, String portletId, PortletPreferences preferences) throws Exception {
        context.addPermissions("com.liferay.portlet.documentlibrary", context.getScopeGroupId());
        long rootFolderId = GetterUtil.getLong((String)preferences.getValue("rootFolderId", null));
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("documentlibrary-display-data");
        Element foldersElement = rootElement.addElement("folders");
        Element fileEntriesElement = rootElement.addElement("file-entries");
        Element fileShortcutsElement = rootElement.addElement("file-shortcuts");
        Element fileRanksElement = rootElement.addElement("file-ranks");
        if (rootFolderId == 0L) {
            List folders = DLFolderUtil.findByGroupId((long)context.getScopeGroupId());
            for (DLFolder folder : folders) {
                DLPortletDataHandlerImpl.exportFolder(context, foldersElement, fileEntriesElement, fileShortcutsElement, fileRanksElement, folder);
            }
        } else {
            DLFolder folder = DLFolderUtil.findByPrimaryKey((long)rootFolderId);
            rootElement.addAttribute("root-folder-id", String.valueOf(folder.getFolderId()));
            DLPortletDataHandlerImpl.exportFolder(context, foldersElement, fileEntriesElement, fileShortcutsElement, fileRanksElement, folder);
        }
        return document.formattedString();
    }

    protected PortletPreferences doImportData(PortletDataContext context, String portletId, PortletPreferences preferences, String data) throws Exception {
        long rootFolderId;
        context.importPermissions("com.liferay.portlet.documentlibrary", context.getSourceGroupId(), context.getScopeGroupId());
        Document document = SAXReaderUtil.read((String)data);
        Element rootElement = document.getRootElement();
        Element foldersElement = rootElement.element("folders");
        List folderElements = foldersElement.elements("folder");
        for (Element folderElement : folderElements) {
            DLPortletDataHandlerImpl.importFolder(context, folderElement);
        }
        Element fileEntriesElement = rootElement.element("file-entries");
        List fileEntryElements = fileEntriesElement.elements("file-entry");
        for (Element fileEntryElement : fileEntryElements) {
            DLPortletDataHandlerImpl.importFileEntry(context, fileEntryElement);
        }
        if (context.getBooleanParameter(_NAMESPACE, "shortcuts")) {
            List fileShortcutElements = rootElement.element("file-shortcuts").elements("file-shortcut");
            for (Element fileShortcutElement : fileShortcutElements) {
                DLPortletDataHandlerImpl.importFileShortcut(context, fileShortcutElement);
            }
        }
        if (context.getBooleanParameter(_NAMESPACE, "ranks")) {
            Element fileRanksElement = rootElement.element("file-ranks");
            List fileRankElements = fileRanksElement.elements("file-rank");
            for (Element fileRankElement : fileRankElements) {
                DLPortletDataHandlerImpl.importFileRank(context, fileRankElement);
            }
        }
        if ((rootFolderId = GetterUtil.getLong((String)rootElement.attributeValue("root-folder-id"))) > 0L) {
            Map folderPKs = context.getNewPrimaryKeysMap(DLFolder.class);
            rootFolderId = MapUtil.getLong((Map)folderPKs, (long)rootFolderId, (long)rootFolderId);
            preferences.setValue("rootFolderId", String.valueOf(rootFolderId));
        }
        return preferences;
    }
}

