/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.communities.action;

import com.liferay.portal.ImageTypeException;
import com.liferay.portal.LayoutFriendlyURLException;
import com.liferay.portal.LayoutHiddenException;
import com.liferay.portal.LayoutNameException;
import com.liferay.portal.LayoutParentLayoutIdException;
import com.liferay.portal.LayoutSetVirtualHostException;
import com.liferay.portal.LayoutTypeException;
import com.liferay.portal.NoSuchGroupException;
import com.liferay.portal.NoSuchLayoutException;
import com.liferay.portal.RemoteExportException;
import com.liferay.portal.RemoteOptionsException;
import com.liferay.portal.RequiredLayoutException;
import com.liferay.portal.events.EventsProcessorUtil;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PropertiesParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.ColorScheme;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutPrototype;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.GroupServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutPrototypeServiceUtil;
import com.liferay.portal.service.LayoutServiceUtil;
import com.liferay.portal.service.LayoutSetServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.service.ThemeLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.permission.GroupPermissionUtil;
import com.liferay.portal.service.permission.LayoutPermissionUtil;
import com.liferay.portal.service.permission.LayoutPrototypePermissionUtil;
import com.liferay.portal.service.permission.LayoutSetPrototypePermissionUtil;
import com.liferay.portal.service.permission.OrganizationPermissionUtil;
import com.liferay.portal.service.permission.UserPermissionUtil;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.LayoutSettings;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.communities.action.ActionUtil;
import com.liferay.portlet.communities.util.CommunitiesUtil;
import com.liferay.portlet.tasks.NoSuchProposalException;
import com.liferay.util.servlet.UploadException;
import java.io.File;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditPagesAction
extends PortletAction {
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        try {
            this.checkPermissions((PortletRequest)actionRequest);
        }
        catch (PrincipalException principalException) {
            return;
        }
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            Layout layout = null;
            String oldFriendlyURL = "";
            if (cmd.equals("add") || cmd.equals("update")) {
                Object[] returnValue = this.updateLayout(actionRequest, actionResponse);
                layout = (Layout)returnValue[0];
                oldFriendlyURL = (String)returnValue[1];
            } else if (cmd.equals("delete")) {
                CommunitiesUtil.deleteLayout(actionRequest, actionResponse);
            } else if (cmd.equals("copy_from_live")) {
                StagingUtil.copyFromLive((PortletRequest)actionRequest);
            } else if (cmd.equals("display_order")) {
                this.updateDisplayOrder(actionRequest);
            } else if (cmd.equals("logo")) {
                this.updateLogo(actionRequest);
            } else if (cmd.equals("look_and_feel")) {
                this.updateLookAndFeel(actionRequest);
            } else if (cmd.equals("merge_pages")) {
                this.updateMergePages(actionRequest);
            } else if (cmd.equals("monitoring")) {
                this.updateMonitoring(actionRequest);
            } else if (cmd.equals("publish_to_live")) {
                StagingUtil.publishToLive((PortletRequest)actionRequest);
            } else if (cmd.equals("publish_to_remote")) {
                StagingUtil.publishToRemote((PortletRequest)actionRequest);
            } else if (cmd.equals("schedule_copy_from_live")) {
                StagingUtil.scheduleCopyFromLive((PortletRequest)actionRequest);
            } else if (cmd.equals("schedule_publish_to_live")) {
                StagingUtil.schedulePublishToLive((PortletRequest)actionRequest);
            } else if (cmd.equals("schedule_publish_to_remote")) {
                StagingUtil.schedulePublishToRemote((PortletRequest)actionRequest);
            } else if (cmd.equals("staging")) {
                StagingUtil.updateStaging((PortletRequest)actionRequest);
            } else if (cmd.equals("unschedule_copy_from_live")) {
                StagingUtil.unscheduleCopyFromLive((PortletRequest)actionRequest);
            } else if (cmd.equals("unschedule_publish_to_live")) {
                StagingUtil.unschedulePublishToLive((PortletRequest)actionRequest);
            } else if (cmd.equals("unschedule_publish_to_remote")) {
                StagingUtil.unschedulePublishToRemote((PortletRequest)actionRequest);
            } else if (cmd.equals("virtual_host")) {
                this.updateVirtualHost(actionRequest);
            }
            String redirect = (String)actionRequest.getAttribute("REDIRECT");
            if (Validator.isNull((String)redirect)) {
                redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"pagesRedirect");
            }
            if (layout != null && Validator.isNotNull((String)oldFriendlyURL)) {
                ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
                if (layout.getPlid() == themeDisplay.getPlid()) {
                    Group group = layout.getGroup();
                    String oldPath = String.valueOf(group.getFriendlyURL()) + oldFriendlyURL;
                    String newPath = String.valueOf(group.getFriendlyURL()) + layout.getFriendlyURL();
                    redirect = StringUtil.replace((String)redirect, (String)oldPath, (String)newPath);
                    redirect = StringUtil.replace((String)redirect, (String)HttpUtil.encodeURL((String)oldPath), (String)HttpUtil.encodeURL((String)newPath));
                }
            }
            this.sendRedirect(actionRequest, actionResponse, redirect);
        }
        catch (Exception e) {
            if (e instanceof NoSuchLayoutException || e instanceof NoSuchProposalException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
                this.setForward((PortletRequest)actionRequest, "portlet.communities.error");
            }
            if (e instanceof ImageTypeException || e instanceof LayoutFriendlyURLException || e instanceof LayoutHiddenException || e instanceof LayoutNameException || e instanceof LayoutParentLayoutIdException || e instanceof LayoutSetVirtualHostException || e instanceof LayoutTypeException || e instanceof RequiredLayoutException || e instanceof UploadException) {
                if (e instanceof LayoutFriendlyURLException) {
                    SessionErrors.add((PortletRequest)actionRequest, (String)LayoutFriendlyURLException.class.getName(), (Object)e);
                } else {
                    SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName(), (Object)e);
                }
            }
            if (e instanceof RemoteExportException || e instanceof RemoteOptionsException || e instanceof SystemException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName(), (Object)e);
                String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"pagesRedirect");
                this.sendRedirect(actionRequest, actionResponse, redirect);
            }
            throw e;
        }
    }

    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            this.checkPermissions((PortletRequest)renderRequest);
        }
        catch (PrincipalException principalException) {
            SessionErrors.add((PortletRequest)renderRequest, (String)PrincipalException.class.getName());
            return mapping.findForward("portlet.communities.error");
        }
        try {
            this.getGroup((PortletRequest)renderRequest);
        }
        catch (Exception e) {
            if (e instanceof NoSuchGroupException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, (String)e.getClass().getName());
                return mapping.findForward("portlet.communities.error");
            }
            throw e;
        }
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.communities.edit_pages"));
    }

    public void serveResource(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        PortletRequestDispatcher portletRequestDispatcher = portletConfig.getPortletContext().getRequestDispatcher("/html/portlet/communities/scheduled_publishing_events.jsp");
        portletRequestDispatcher.include((PortletRequest)resourceRequest, (PortletResponse)resourceResponse);
    }

    protected void checkPermissions(PortletRequest portletRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("THEME_DISPLAY");
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        Group group = this.getGroup(portletRequest);
        if (group == null) {
            throw new PrincipalException();
        }
        Layout layout = themeDisplay.getLayout();
        boolean hasUpdateLayoutPermission = false;
        if (layout != null) {
            hasUpdateLayoutPermission = LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)"UPDATE");
        }
        if (group.isCommunity()) {
            boolean publishToLive;
            String cmd = ParamUtil.getString((PortletRequest)portletRequest, (String)"cmd");
            boolean bl = publishToLive = GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)group.getGroupId(), (String)"PUBLISH_STAGING") && cmd.equals("publish_to_live");
            if (!(GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)group.getGroupId(), (String)"APPROVE_PROPOSAL") || GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)group.getGroupId(), (String)"MANAGE_LAYOUTS") || hasUpdateLayoutPermission || publishToLive)) {
                throw new PrincipalException();
            }
        } else if (group.isCompany()) {
            if (!permissionChecker.isCompanyAdmin()) {
                throw new PrincipalException();
            }
        } else if (group.isLayoutPrototype()) {
            LayoutPrototypePermissionUtil.check((PermissionChecker)permissionChecker, (long)group.getClassPK(), (String)"UPDATE");
        } else if (group.isLayoutSetPrototype()) {
            LayoutSetPrototypePermissionUtil.check((PermissionChecker)permissionChecker, (long)group.getClassPK(), (String)"UPDATE");
        } else if (group.isOrganization()) {
            boolean publishToLive;
            long organizationId = group.getOrganizationId();
            String cmd = ParamUtil.getString((PortletRequest)portletRequest, (String)"cmd");
            boolean bl = publishToLive = OrganizationPermissionUtil.contains((PermissionChecker)permissionChecker, (long)organizationId, (String)"PUBLISH_STAGING") && cmd.equals("publish_to_live");
            if (!(OrganizationPermissionUtil.contains((PermissionChecker)permissionChecker, (long)organizationId, (String)"APPROVE_PROPOSAL") || OrganizationPermissionUtil.contains((PermissionChecker)permissionChecker, (long)organizationId, (String)"MANAGE_LAYOUTS") || hasUpdateLayoutPermission || publishToLive)) {
                throw new PrincipalException();
            }
        } else if (group.isUser()) {
            long groupUserId = group.getClassPK();
            User groupUser = UserLocalServiceUtil.getUserById((long)groupUserId);
            long[] organizationIds = groupUser.getOrganizationIds();
            UserPermissionUtil.check((PermissionChecker)permissionChecker, (long)groupUserId, (long[])organizationIds, (String)"UPDATE");
            if (!PropsValues.LAYOUT_USER_PRIVATE_LAYOUTS_MODIFIABLE && !PropsValues.LAYOUT_USER_PUBLIC_LAYOUTS_MODIFIABLE) {
                throw new PrincipalException();
            }
        }
    }

    protected Group getGroup(PortletRequest portletRequest) throws Exception {
        return ActionUtil.getGroup(portletRequest);
    }

    protected UnicodeProperties getTypeSettingsProperties(ActionRequest actionRequest) {
        return PropertiesParamUtil.getProperties((PortletRequest)actionRequest, (String)"TypeSettingsProperties--");
    }

    protected void updateDisplayOrder(ActionRequest actionRequest) throws Exception {
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        boolean privateLayout = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"privateLayout");
        long parentLayoutId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"parentLayoutId");
        long[] layoutIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"layoutIds"), (long)0L);
        LayoutServiceUtil.setLayouts((long)groupId, (boolean)privateLayout, (long)parentLayoutId, (long[])layoutIds);
    }

    protected Object[] updateLayout(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        UploadPortletRequest uploadRequest = PortalUtil.getUploadPortletRequest((PortletRequest)actionRequest);
        String cmd = ParamUtil.getString((HttpServletRequest)uploadRequest, (String)"cmd");
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        boolean privateLayout = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"privateLayout");
        long layoutId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"layoutId");
        long parentLayoutId = ParamUtil.getLong((HttpServletRequest)uploadRequest, (String)"parentLayoutId");
        String description = ParamUtil.getString((HttpServletRequest)uploadRequest, (String)"description");
        String type = ParamUtil.getString((HttpServletRequest)uploadRequest, (String)"type");
        boolean hidden = ParamUtil.getBoolean((HttpServletRequest)uploadRequest, (String)"hidden");
        String friendlyURL = ParamUtil.getString((HttpServletRequest)uploadRequest, (String)"friendlyURL");
        boolean iconImage = ParamUtil.getBoolean((HttpServletRequest)uploadRequest, (String)"iconImage");
        byte[] iconBytes = FileUtil.getBytes((File)uploadRequest.getFile("iconFileName"));
        long layoutPrototypeId = ParamUtil.getLong((HttpServletRequest)uploadRequest, (String)"layoutPrototypeId");
        boolean inheritFromParentLayoutId = ParamUtil.getBoolean((HttpServletRequest)uploadRequest, (String)"inheritFromParentLayoutId");
        long copyLayoutId = ParamUtil.getLong((HttpServletRequest)uploadRequest, (String)"copyLayoutId");
        Map localeNamesMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"name");
        Map localeTitlesMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"title");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)Layout.class.getName(), (PortletRequest)actionRequest);
        Layout layout = null;
        String oldFriendlyURL = "";
        if (cmd.equals("add")) {
            if (inheritFromParentLayoutId && parentLayoutId > 0L) {
                Layout parentLayout = LayoutLocalServiceUtil.getLayout((long)groupId, (boolean)privateLayout, (long)parentLayoutId);
                layout = LayoutServiceUtil.addLayout((long)groupId, (boolean)privateLayout, (long)parentLayoutId, (Map)localeNamesMap, (Map)localeTitlesMap, (String)description, (String)parentLayout.getType(), (boolean)hidden, (String)friendlyURL, (ServiceContext)serviceContext);
                LayoutServiceUtil.updateLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)parentLayout.getTypeSettings());
                if (parentLayout.isTypePortlet()) {
                    ActionUtil.copyPreferences((PortletRequest)actionRequest, layout, parentLayout);
                }
            } else if (layoutPrototypeId > 0L) {
                LayoutPrototype layoutPrototype = LayoutPrototypeServiceUtil.getLayoutPrototype((long)layoutPrototypeId);
                Layout layoutPrototypeLayout = layoutPrototype.getLayout();
                layout = LayoutServiceUtil.addLayout((long)groupId, (boolean)privateLayout, (long)parentLayoutId, (Map)localeNamesMap, (Map)localeTitlesMap, (String)description, (String)"portlet", (boolean)false, (String)friendlyURL, (ServiceContext)serviceContext);
                LayoutServiceUtil.updateLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)layoutPrototypeLayout.getTypeSettings());
                ActionUtil.copyPreferences((PortletRequest)actionRequest, layout, layoutPrototypeLayout);
                if (Validator.isNotNull((String)layoutPrototypeLayout.getThemeId())) {
                    LayoutServiceUtil.updateLookAndFeel((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)layoutPrototypeLayout.getThemeId(), (String)layoutPrototypeLayout.getColorSchemeId(), (String)layoutPrototypeLayout.getCss(), (boolean)false);
                }
                if (Validator.isNotNull((String)layoutPrototypeLayout.getWapThemeId())) {
                    LayoutServiceUtil.updateLookAndFeel((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)layoutPrototypeLayout.getWapThemeId(), (String)layoutPrototypeLayout.getWapColorSchemeId(), (String)layoutPrototypeLayout.getCss(), (boolean)true);
                }
            } else {
                LayoutServiceUtil.addLayout((long)groupId, (boolean)privateLayout, (long)parentLayoutId, (Map)localeNamesMap, (Map)localeTitlesMap, (String)description, (String)type, (boolean)hidden, (String)friendlyURL, (ServiceContext)serviceContext);
            }
        } else {
            layout = LayoutLocalServiceUtil.getLayout((long)groupId, (boolean)privateLayout, (long)layoutId);
            oldFriendlyURL = layout.getFriendlyURL();
            if (oldFriendlyURL.equals((layout = LayoutServiceUtil.updateLayout((long)groupId, (boolean)privateLayout, (long)layoutId, (long)layout.getParentLayoutId(), (Map)localeNamesMap, (Map)localeTitlesMap, (String)description, (String)type, (boolean)hidden, (String)friendlyURL, (Boolean)iconImage, (byte[])iconBytes, (ServiceContext)serviceContext)).getFriendlyURL())) {
                oldFriendlyURL = "";
            }
            UnicodeProperties formTypeSettingsProperties = this.getTypeSettingsProperties(actionRequest);
            if (type.equals("portlet")) {
                if (copyLayoutId > 0L && copyLayoutId != layout.getLayoutId()) {
                    try {
                        Layout copyLayout = LayoutLocalServiceUtil.getLayout((long)groupId, (boolean)privateLayout, (long)copyLayoutId);
                        if (copyLayout.isTypePortlet()) {
                            LayoutServiceUtil.updateLayout((long)groupId, (boolean)privateLayout, (long)layoutId, (String)copyLayout.getTypeSettings());
                            ActionUtil.copyPreferences((PortletRequest)actionRequest, layout, copyLayout);
                        }
                    }
                    catch (NoSuchLayoutException noSuchLayoutException) {}
                } else {
                    UnicodeProperties layoutTypeSettingsProperties = layout.getTypeSettingsProperties();
                    layoutTypeSettingsProperties.putAll((Map)formTypeSettingsProperties);
                    LayoutServiceUtil.updateLayout((long)groupId, (boolean)privateLayout, (long)layoutId, (String)layout.getTypeSettings());
                }
            } else {
                layout.setTypeSettingsProperties(formTypeSettingsProperties);
                LayoutServiceUtil.updateLayout((long)groupId, (boolean)privateLayout, (long)layoutId, (String)layout.getTypeSettings());
            }
            HttpServletResponse response = PortalUtil.getHttpServletResponse((PortletResponse)actionResponse);
            LayoutSettings layoutSettings = LayoutSettings.getInstance(layout);
            EventsProcessorUtil.process("layout.configuration.action.update", layoutSettings.getConfigurationActionUpdate(), (HttpServletRequest)uploadRequest, response);
        }
        return new Object[]{layout, oldFriendlyURL};
    }

    protected void updateLogo(ActionRequest actionRequest) throws Exception {
        UploadPortletRequest uploadRequest = PortalUtil.getUploadPortletRequest((PortletRequest)actionRequest);
        long liveGroupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"liveGroupId");
        long stagingGroupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"stagingGroupId");
        boolean privateLayout = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"privateLayout");
        boolean logo = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"logo");
        File file = uploadRequest.getFile("logoFileName");
        byte[] bytes = FileUtil.getBytes((File)file);
        if (logo && (bytes == null || bytes.length == 0)) {
            throw new UploadException();
        }
        LayoutSetServiceUtil.updateLogo((long)liveGroupId, (boolean)privateLayout, (boolean)logo, (File)file);
        if (stagingGroupId > 0L) {
            LayoutSetServiceUtil.updateLogo((long)stagingGroupId, (boolean)privateLayout, (boolean)logo, (File)file);
        }
    }

    protected void updateLookAndFeel(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        long companyId = themeDisplay.getCompanyId();
        long liveGroupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"liveGroupId");
        long stagingGroupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"stagingGroupId");
        boolean privateLayout = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"privateLayout");
        long layoutId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"layoutId");
        String themeId = ParamUtil.getString((PortletRequest)actionRequest, (String)"themeId");
        String colorSchemeId = ParamUtil.getString((PortletRequest)actionRequest, (String)"colorSchemeId");
        String css = ParamUtil.getString((PortletRequest)actionRequest, (String)"css");
        boolean wapTheme = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"wapTheme");
        if (stagingGroupId > 0L) {
            this.updateLookAndFeel(companyId, stagingGroupId, privateLayout, layoutId, themeId, colorSchemeId, css, wapTheme);
        } else {
            this.updateLookAndFeel(companyId, liveGroupId, privateLayout, layoutId, themeId, colorSchemeId, css, wapTheme);
        }
    }

    protected void updateLookAndFeel(long companyId, long groupId, boolean privateLayout, long layoutId, String themeId, String colorSchemeId, String css, boolean wapTheme) throws Exception {
        if (Validator.isNotNull((String)themeId) && Validator.isNull((String)colorSchemeId)) {
            ColorScheme colorScheme = ThemeLocalServiceUtil.getColorScheme((long)companyId, (String)themeId, (String)colorSchemeId, (boolean)wapTheme);
            colorSchemeId = colorScheme.getColorSchemeId();
        }
        if (layoutId <= 0L) {
            LayoutSetServiceUtil.updateLookAndFeel((long)groupId, (boolean)privateLayout, (String)themeId, (String)colorSchemeId, (String)css, (boolean)wapTheme);
        } else {
            LayoutServiceUtil.updateLookAndFeel((long)groupId, (boolean)privateLayout, (long)layoutId, (String)themeId, (String)colorSchemeId, (String)css, (boolean)wapTheme);
        }
    }

    protected void updateMergePages(ActionRequest actionRequest) throws Exception {
        long liveGroupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"liveGroupId");
        boolean mergeGuestPublicPages = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"mergeGuestPublicPages");
        Group liveGroup = GroupLocalServiceUtil.getGroup((long)liveGroupId);
        UnicodeProperties props = liveGroup.getTypeSettingsProperties();
        props.setProperty("mergeGuestPublicPages", String.valueOf(mergeGuestPublicPages));
        GroupServiceUtil.updateGroup((long)liveGroupId, (String)liveGroup.getTypeSettings());
    }

    protected void updateMonitoring(ActionRequest actionRequest) throws Exception {
        long liveGroupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"liveGroupId");
        String googleAnalyticsId = ParamUtil.getString((PortletRequest)actionRequest, (String)"googleAnalyticsId");
        Group liveGroup = GroupLocalServiceUtil.getGroup((long)liveGroupId);
        UnicodeProperties props = liveGroup.getTypeSettingsProperties();
        props.setProperty("googleAnalyticsId", googleAnalyticsId);
        GroupServiceUtil.updateGroup((long)liveGroupId, (String)liveGroup.getTypeSettings());
    }

    protected void updateVirtualHost(ActionRequest actionRequest) throws Exception {
        long liveGroupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"liveGroupId");
        String publicVirtualHost = ParamUtil.getString((PortletRequest)actionRequest, (String)"publicVirtualHost");
        String privateVirtualHost = ParamUtil.getString((PortletRequest)actionRequest, (String)"privateVirtualHost");
        String friendlyURL = ParamUtil.getString((PortletRequest)actionRequest, (String)"friendlyURL");
        LayoutSetServiceUtil.updateVirtualHost((long)liveGroupId, (boolean)false, (String)publicVirtualHost);
        LayoutSetServiceUtil.updateVirtualHost((long)liveGroupId, (boolean)true, (String)privateVirtualHost);
        GroupServiceUtil.updateFriendlyURL((long)liveGroupId, (String)friendlyURL);
        Group liveGroup = GroupServiceUtil.getGroup((long)liveGroupId);
        if (liveGroup.hasStagingGroup()) {
            Group stagingGroup = liveGroup.getStagingGroup();
            publicVirtualHost = ParamUtil.getString((PortletRequest)actionRequest, (String)"stagingPublicVirtualHost");
            privateVirtualHost = ParamUtil.getString((PortletRequest)actionRequest, (String)"stagingPrivateVirtualHost");
            friendlyURL = ParamUtil.getString((PortletRequest)actionRequest, (String)"stagingFriendlyURL");
            LayoutSetServiceUtil.updateVirtualHost((long)stagingGroup.getGroupId(), (boolean)false, (String)publicVirtualHost);
            LayoutSetServiceUtil.updateVirtualHost((long)stagingGroup.getGroupId(), (boolean)true, (String)privateVirtualHost);
            GroupServiceUtil.updateFriendlyURL((long)stagingGroup.getGroupId(), (String)friendlyURL);
        }
    }
}

