/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.calendar.asset;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.asset.model.AssetRenderer;
import com.liferay.portlet.asset.model.BaseAssetRendererFactory;
import com.liferay.portlet.calendar.asset.CalEventAssetRenderer;
import com.liferay.portlet.calendar.model.CalEvent;
import com.liferay.portlet.calendar.service.CalEventLocalServiceUtil;
import com.liferay.portlet.calendar.service.permission.CalEventPermission;
import com.liferay.portlet.calendar.service.permission.CalendarPermission;
import javax.portlet.PortletURL;

public class CalEventAssetRendererFactory
extends BaseAssetRendererFactory {
    public static final String CLASS_NAME = CalEvent.class.getName();
    public static final String TYPE = "event";

    public AssetRenderer getAssetRenderer(long classPK, int type) throws PortalException, SystemException {
        CalEvent event = CalEventLocalServiceUtil.getEvent((long)classPK);
        return new CalEventAssetRenderer(event);
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public String getType() {
        return TYPE;
    }

    public PortletURL getURLAdd(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) {
        ThemeDisplay themeDisplay = (ThemeDisplay)liferayPortletRequest.getAttribute("THEME_DISPLAY");
        LiferayPortletURL addAssetURL = null;
        if (CalendarPermission.contains(themeDisplay.getPermissionChecker(), themeDisplay.getScopeGroupId(), "ADD_EVENT")) {
            addAssetURL = liferayPortletResponse.createRenderURL("8");
            addAssetURL.setParameter("struts_action", "/calendar/edit_event");
        }
        return addAssetURL;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws Exception {
        return CalEventPermission.contains(permissionChecker, classPK, actionId);
    }

    protected String getIconPath(ThemeDisplay themeDisplay) {
        return String.valueOf(themeDisplay.getPathThemeImages()) + "/common/date.png";
    }
}

